/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.BetaIntegerCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class BetaIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int offset;
    private final int bitsPerValue;

    public BetaIntegerEncoding(int offset, int bitsPerValue) {
        super(EncodingID.BETA);
        if (bitsPerValue < 0) {
            throw new IllegalArgumentException("Number of bits per value must not be negative");
        }
        if (bitsPerValue > 32) {
            throw new IllegalArgumentException("Number of bits per value must be 32 or lower");
        }
        this.offset = offset;
        this.bitsPerValue = bitsPerValue;
    }

    public static BetaIntegerEncoding fromParams(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int offset = ITF8.readUnsignedITF8(buffer);
        int bitLimit = ITF8.readUnsignedITF8(buffer);
        return new BetaIntegerEncoding(offset, bitLimit);
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.bitsPerValue, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new BetaIntegerCodec(coreBlockInputStream, coreBlockOutputStream, this.offset, this.bitsPerValue);
    }
}

