/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.experimental;

import htsjdk.samtools.cram.encoding.core.experimental.ExperimentalCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;

class GolombRiceIntegerCodec
extends ExperimentalCodec<Integer> {
    private final int m;
    private final int log2m;
    private final long mask;
    private final boolean quotientBit = true;
    private final int offset;

    public GolombRiceIntegerCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, int offset, int log2m) {
        super(coreBlockInputStream, coreBlockOutputStream);
        this.log2m = log2m;
        this.m = 1 << log2m;
        this.offset = offset;
        this.mask = ~(-1 << log2m);
    }

    @Override
    public final Integer read() {
        int unary = 0;
        try {
            while (this.coreBlockInputStream.readBit()) {
                ++unary;
            }
            int remainder = this.coreBlockInputStream.readBits(this.log2m);
            int result = unary * this.m + remainder;
            return result - this.offset;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public final void write(Integer value) {
        long newValue = value + this.offset;
        long quotient = newValue >>> this.log2m;
        try {
            if (quotient > Integer.MAX_VALUE) {
                for (long i = 0L; i < quotient; ++i) {
                    this.coreBlockOutputStream.write(true);
                }
            } else if (quotient > 0L) {
                int qi = (int)quotient;
                for (int i = 0; i < qi; ++i) {
                    this.coreBlockOutputStream.write(true);
                }
            }
            this.coreBlockOutputStream.write(false);
            long remainder = newValue & this.mask;
            long reminderMask = 1 << this.log2m - 1;
            for (int i = this.log2m - 1; i >= 0; --i) {
                long b = remainder & reminderMask;
                this.coreBlockOutputStream.write(b != 0L);
                reminderMask >>>= 1;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public Integer read(int length) {
        throw new RuntimeException("Not implemented.");
    }
}

