/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.external;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalLongCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public class ExternalLongEncoding
extends CRAMEncoding<Long> {
    private final int externalBlockContentId;

    ExternalLongEncoding(int externalBlockContentId) {
        super(EncodingID.EXTERNAL);
        this.externalBlockContentId = externalBlockContentId;
    }

    public static ExternalLongEncoding fromParams(byte[] params) {
        int contentId = ITF8.readUnsignedITF8(params);
        return new ExternalLongEncoding(contentId);
    }

    @Override
    public byte[] toByteArray() {
        return ITF8.writeUnsignedITF8(this.externalBlockContentId);
    }

    @Override
    public CRAMCodec<Long> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        ByteArrayInputStream inputStream = externalBlockInputMap == null ? null : externalBlockInputMap.get(this.externalBlockContentId);
        ByteArrayOutputStream outputStream = externalBlockOutputMap == null ? null : externalBlockOutputMap.get(this.externalBlockContentId);
        return new ExternalLongCodec(inputStream, outputStream);
    }
}

