/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MultiRefSliceAlignmentSpanReader
extends CramRecordReader {
    private int currentAlignmentStart;
    private final Map<Integer, AlignmentSpan> spans = new HashMap<Integer, AlignmentSpan>();

    public MultiRefSliceAlignmentSpanReader(BitInputStream coreInputStream, Map<Integer, ByteArrayInputStream> externalInputMap, CompressionHeader header, ValidationStringency validationStringency, int initialAlignmentStart, int recordCount) {
        super(coreInputStream, externalInputMap, header, -2, validationStringency);
        this.currentAlignmentStart = initialAlignmentStart;
        for (int i = 0; i < recordCount; ++i) {
            this.readCramRecord();
        }
    }

    public Map<Integer, AlignmentSpan> getReferenceSpans() {
        return Collections.unmodifiableMap(this.spans);
    }

    private void readCramRecord() {
        CramCompressionRecord cramRecord = new CramCompressionRecord();
        super.read(cramRecord);
        this.currentAlignmentStart = this.APDelta ? (this.currentAlignmentStart += cramRecord.alignmentDelta) : cramRecord.alignmentStart;
        if (!this.spans.containsKey(cramRecord.sequenceId)) {
            this.spans.put(cramRecord.sequenceId, new AlignmentSpan(this.currentAlignmentStart, cramRecord.readLength));
        } else {
            this.spans.get(cramRecord.sequenceId).addSingle(this.currentAlignmentStart, cramRecord.readLength);
        }
    }
}

