/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class CramInt {
    public static int readInt32(InputStream inputStream) throws IOException {
        return inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
    }

    public static int readInt32(byte[] data) {
        if (data.length != 4) {
            throw new IllegalArgumentException("Expecting a 4-byte integer. ");
        }
        return 0xFF & data[0] | (0xFF & data[1]) << 8 | (0xFF & data[2]) << 16 | (0xFF & data[3]) << 24;
    }

    public static int readInt32(ByteBuffer buffer) {
        return 0xFF & buffer.get() | (0xFF & buffer.get()) << 8 | (0xFF & buffer.get()) << 16 | (0xFF & buffer.get()) << 24;
    }

    public static int writeInt32(int value, OutputStream outputStream) throws IOException {
        outputStream.write((byte)value);
        outputStream.write((byte)(value >> 8));
        outputStream.write((byte)(value >> 16));
        outputStream.write((byte)(value >> 24));
        return 32;
    }

    public static byte[] writeInt32(int value) {
        byte[] data = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return data;
    }
}

