/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure.block;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.compression.ExternalCompression;
import htsjdk.samtools.cram.io.CRC32InputStream;
import htsjdk.samtools.cram.io.CRC32OutputStream;
import htsjdk.samtools.cram.io.CramInt;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.samtools.cram.structure.block.ExternalBlock;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Block {
    public static final int NO_CONTENT_ID = 0;
    private final BlockCompressionMethod compressionMethod;
    private final BlockContentType contentType;
    private final byte[] compressedContent;
    private final int uncompressedLength;

    protected Block(BlockCompressionMethod compressionMethod, BlockContentType contentType, byte[] compressedContent, int uncompressedLength) {
        this.compressionMethod = compressionMethod;
        this.contentType = contentType;
        this.compressedContent = compressedContent;
        this.uncompressedLength = uncompressedLength;
        if (contentType != BlockContentType.EXTERNAL && this.getContentId() != 0) {
            throw new CRAMException("Cannot set a Content ID for non-external blocks.");
        }
    }

    protected Block(BlockContentType contentType, byte[] rawContent) {
        this(BlockCompressionMethod.RAW, contentType, rawContent, rawContent.length);
    }

    public static Block createRawFileHeaderBlock(byte[] rawContent) {
        return new Block(BlockContentType.FILE_HEADER, rawContent);
    }

    public static Block createRawCompressionHeaderBlock(byte[] rawContent) {
        return new Block(BlockContentType.COMPRESSION_HEADER, rawContent);
    }

    public static Block createRawSliceHeaderBlock(byte[] rawContent) {
        return new Block(BlockContentType.MAPPED_SLICE, rawContent);
    }

    public static Block createRawCoreDataBlock(byte[] rawContent) {
        return new Block(BlockContentType.CORE, rawContent);
    }

    public final BlockCompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public final BlockContentType getContentType() {
        return this.contentType;
    }

    public int getContentId() {
        return 0;
    }

    public final byte[] getUncompressedContent() {
        byte[] uncompressedContent = ExternalCompression.uncompress(this.compressionMethod, this.compressedContent);
        if (uncompressedContent.length != this.uncompressedLength) {
            throw new CRAMException(String.format("Block uncompressed length did not match expected length: %04x vs %04x", this.uncompressedLength, uncompressedContent.length));
        }
        return uncompressedContent;
    }

    public int getUncompressedContentSize() {
        return this.uncompressedLength;
    }

    public final byte[] getCompressedContent() {
        return this.compressedContent;
    }

    public final int getCompressedContentSize() {
        return this.compressedContent.length;
    }

    public static Block read(int major, InputStream inputStream) {
        boolean v3OrHigher;
        boolean bl = v3OrHigher = major >= CramVersions.CRAM_v3.major;
        if (v3OrHigher) {
            inputStream = new CRC32InputStream(inputStream);
        }
        try {
            BlockCompressionMethod compressionMethod = BlockCompressionMethod.byId(inputStream.read());
            BlockContentType contentType = BlockContentType.byId(inputStream.read());
            int contentId = ITF8.readUnsignedITF8(inputStream);
            int compressedSize = ITF8.readUnsignedITF8(inputStream);
            int uncompressedSize = ITF8.readUnsignedITF8(inputStream);
            byte[] compressedContent = new byte[compressedSize];
            InputStreamUtils.readFully(inputStream, compressedContent, 0, compressedSize);
            if (v3OrHigher) {
                int actualChecksum = ((CRC32InputStream)inputStream).getCRC32();
                int checksum = CramInt.readInt32(inputStream);
                if (checksum != actualChecksum) {
                    throw new RuntimeException(String.format("Block CRC32 mismatch: %04x vs %04x", checksum, actualChecksum));
                }
            }
            if (contentType == BlockContentType.EXTERNAL) {
                return new ExternalBlock(compressionMethod, contentId, compressedContent, uncompressedSize);
            }
            return new Block(compressionMethod, contentType, compressedContent, uncompressedSize);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public final void write(int major, OutputStream outputStream) {
        try {
            if (major >= CramVersions.CRAM_v3.major) {
                CRC32OutputStream crc32OutputStream = new CRC32OutputStream(outputStream);
                this.doWrite(crc32OutputStream);
                outputStream.write(crc32OutputStream.getCrc32_LittleEndian());
            } else {
                this.doWrite(outputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void doWrite(OutputStream outputStream) throws IOException {
        outputStream.write(this.getCompressionMethod().getMethodId());
        outputStream.write(this.getContentType().getContentTypeId());
        ITF8.writeUnsignedITF8(this.getContentId(), outputStream);
        ITF8.writeUnsignedITF8(this.getCompressedContentSize(), outputStream);
        ITF8.writeUnsignedITF8(this.getUncompressedContentSize(), outputStream);
        outputStream.write(this.getCompressedContent());
    }

    public String toString() {
        byte[] uncompressed = this.getUncompressedContent();
        byte[] compressed = this.getCompressedContent();
        String raw = Arrays.toString(Arrays.copyOf(uncompressed, Math.min(5, uncompressed.length)));
        String comp = Arrays.toString(Arrays.copyOf(compressed, Math.min(5, compressed.length)));
        return String.format("compression method=%s, content type=%s, id=%d, raw size=%d, compressed size=%d, raw=%s, comp=%s.", this.getCompressionMethod().name(), this.getContentType().name(), this.getContentId(), this.getUncompressedContentSize(), this.getCompressedContentSize(), raw, comp);
    }
}

