/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekIterator;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import picard.PicardException;
import picard.illumina.BasecallsConverter;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

public class IlluminaBasecallsConverter<CLUSTER_OUTPUT_RECORD>
extends BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    final boolean includeNonPfReads;
    private static final Log log = Log.getInstance(IlluminaBasecallsConverter.class);
    public static final IlluminaDataType[] DATA_TYPES_NO_BARCODE = new IlluminaDataType[]{IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF};
    private static final IlluminaDataType[] DATA_TYPES_WITH_BARCODE = Arrays.copyOf(DATA_TYPES_NO_BARCODE, DATA_TYPES_NO_BARCODE.length + 1);
    private final TimerTask gcTimerTask;

    public IlluminaBasecallsConverter(File basecallsDir, int lane, ReadStructure readStructure, Map<String, ? extends BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int maxReadsInRamPerTile, List<File> tmpDirs, int numProcessors, boolean forceGc, Integer firstTile, Integer tileLimit, Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean applyEamssFiltering, boolean includeNonPfReads, boolean ignoreUnexpectedBarcodes) {
        this(basecallsDir, null, lane, readStructure, barcodeRecordWriterMap, demultiplex, maxReadsInRamPerTile, tmpDirs, numProcessors, forceGc, firstTile, tileLimit, outputRecordComparator, codecPrototype, outputRecordClass, bclQualityEvaluationStrategy, applyEamssFiltering, includeNonPfReads, ignoreUnexpectedBarcodes);
    }

    public IlluminaBasecallsConverter(File basecallsDir, File barcodesDir, int lane, ReadStructure readStructure, Map<String, ? extends BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int maxReadsInRamPerTile, List<File> tmpDirs, int numProcessors, boolean forceGc, Integer firstTile, Integer tileLimit, Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean applyEamssFiltering, boolean includeNonPfReads, boolean ignoreUnexpectedBarcodes) {
        super(barcodeRecordWriterMap, maxReadsInRamPerTile, tmpDirs, codecPrototype, ignoreUnexpectedBarcodes, demultiplex, outputRecordComparator, bclQualityEvaluationStrategy, outputRecordClass, numProcessors, new IlluminaDataProviderFactory(basecallsDir, barcodesDir, lane, readStructure, bclQualityEvaluationStrategy, IlluminaBasecallsConverter.getDataTypesFromReadStructure(readStructure, demultiplex)));
        this.includeNonPfReads = includeNonPfReads;
        this.tiles = this.factory.getAvailableTiles();
        this.tiles.sort(TILE_NUMBER_COMPARATOR);
        this.setTileLimits(firstTile, tileLimit);
        this.numThreads = Math.max(1, Math.min(this.numThreads, this.tiles.size()));
        if (forceGc) {
            Timer gcTimer = new Timer(true);
            long delay = 300000L;
            this.gcTimerTask = new TimerTask(){

                @Override
                public void run() {
                    log.info("Before explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                    System.gc();
                    System.runFinalization();
                    log.info("After explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                }
            };
            gcTimer.scheduleAtFixedRate(this.gcTimerTask, 300000L, 300000L);
        } else {
            this.gcTimerTask = null;
        }
        this.factory.setApplyEamssFiltering(applyEamssFiltering);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doTileProcessing() {
        try {
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            for (Integer tileNumber : this.tiles) {
                tiles.add(new Tile(tileNumber));
            }
            TileReadAggregator tileReadAggregator = new TileReadAggregator(tiles);
            tileReadAggregator.submit();
            try {
                tileReadAggregator.awaitWorkComplete();
            }
            catch (InterruptedException e) {
                log.error(e, "Failure encountered in worker thread; attempting to shut down remaining worker threads and terminate ...");
                throw new PicardException("Failure encountered in worker thread; see log for details.");
            }
            finally {
                tileReadAggregator.shutdown();
            }
            for (Map.Entry<Byte, Integer> entry : this.bclQualityEvaluationStrategy.getPoorQualityFrequencies().entrySet()) {
                log.warn(String.format("Observed low quality of %s %s times.", entry.getKey(), entry.getValue()));
            }
            this.bclQualityEvaluationStrategy.assertMinimumQualities();
        }
        catch (Throwable throwable) {
            try {
                if (this.gcTimerTask != null) {
                    this.gcTimerTask.cancel();
                }
            }
            catch (Throwable ex) {
                log.warn(ex, "Ignoring exception stopping background GC thread.");
            }
            Iterator iterator = this.barcodeRecordWriterMap.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                Map.Entry entry = iterator.next();
                BasecallsConverter.ConvertedClusterDataWriter writer = (BasecallsConverter.ConvertedClusterDataWriter)entry.getValue();
                log.debug(String.format("Closing file for barcode %s.", entry.getKey()));
                writer.close();
            }
        }
        try {
            if (this.gcTimerTask != null) {
                this.gcTimerTask.cancel();
            }
        }
        catch (Throwable ex) {
            log.warn(ex, "Ignoring exception stopping background GC thread.");
        }
        Iterator iterator = this.barcodeRecordWriterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BasecallsConverter.ConvertedClusterDataWriter writer = (BasecallsConverter.ConvertedClusterDataWriter)entry.getValue();
            log.debug(String.format("Closing file for barcode %s.", entry.getKey()));
            writer.close();
        }
        return;
    }

    private static IlluminaDataType[] getDataTypesFromReadStructure(ReadStructure readStructure, boolean demultiplex) {
        if (!readStructure.hasSampleBarcode() || !demultiplex) {
            return DATA_TYPES_NO_BARCODE;
        }
        return DATA_TYPES_WITH_BARCODE;
    }

    static {
        IlluminaBasecallsConverter.DATA_TYPES_WITH_BARCODE[IlluminaBasecallsConverter.DATA_TYPES_WITH_BARCODE.length - 1] = IlluminaDataType.Barcodes;
    }

    private class TileReadAggregator {
        private final Map<Tile, TileProcessingRecord> tileRecords = new TreeMap<Tile, TileProcessingRecord>();
        private final ExecutorService prioritizingThreadPool;
        private final Object completionLatch;
        private Thread parentThread;
        private final Object workEnqueueMonitor;
        private final AtomicBoolean submitted;

        public TileReadAggregator(Collection<Tile> tiles) {
            this.prioritizingThreadPool = new ThreadPoolExecutor(IlluminaBasecallsConverter.this.numThreads, IlluminaBasecallsConverter.this.numThreads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(5, (o1, o2) -> ((PriorityRunnable)o2).getPriority() - ((PriorityRunnable)o1).getPriority()));
            this.completionLatch = new Object();
            this.workEnqueueMonitor = new Object();
            this.submitted = new AtomicBoolean(false);
            for (Tile t : tiles) {
                this.tileRecords.put(t, new TileProcessingRecord());
            }
        }

        public void submit() {
            if (!this.submitted.compareAndSet(false, true)) {
                throw new IllegalStateException("The submit() method may not be called more than once.");
            }
            this.parentThread = Thread.currentThread();
            int priority = 0;
            for (Tile tile : this.tileRecords.keySet()) {
                final TileReader reader = new TileReader(tile, this, this.tileRecords.get(tile));
                this.prioritizingThreadPool.execute(new PriorityRunnable(--priority){

                    @Override
                    public void run() {
                        try {
                            reader.process();
                        }
                        catch (Error | RuntimeException e) {
                            TileReadAggregator.this.parentThread.interrupt();
                            throw e;
                        }
                    }
                });
            }
        }

        private void completeTile(Tile tile) {
            TileProcessingRecord tileRecord = this.tileRecords.get(tile);
            if (tileRecord.getState() == TileProcessingState.DONE_READING) {
                throw new IllegalStateException("This tile is already in the completed state.");
            }
            for (String barcode : tileRecord.getBarcodes()) {
                tileRecord.setBarcodeState(barcode, TileBarcodeProcessingState.READ);
                ((SortingCollection)tileRecord.barcodeToRecordCollection.get(barcode)).doneAdding();
            }
            tileRecord.setState(TileProcessingState.DONE_READING);
            log.debug(String.format("Completed reading tile %s; collected %s reads spanning %s barcodes.", tile.getNumber(), tileRecord.getRecordCount(), tileRecord.getBarcodeCount()));
            this.findAndEnqueueWorkOrSignalCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitWorkComplete() throws InterruptedException {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalWorkComplete() {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findAndEnqueueWorkOrSignalCompletion() {
            Object object = this.workEnqueueMonitor;
            synchronized (object) {
                if (this.isWorkCompleted()) {
                    this.signalWorkComplete();
                } else {
                    LinkedList<PriorityRunnable> tasks = new LinkedList<PriorityRunnable>();
                    block8: for (String string : IlluminaBasecallsConverter.this.barcodeRecordWriterMap.keySet()) {
                        block9: for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                            Tile tile = entry.getKey();
                            TileProcessingRecord tileRecord = entry.getValue();
                            if (tileRecord.getState() != TileProcessingState.DONE_READING) continue block8;
                            switch (tileRecord.getBarcodeState(string)) {
                                case NA: 
                                case WRITTEN: {
                                    continue block9;
                                }
                                case QUEUED_FOR_WRITE: {
                                    continue block8;
                                }
                                case READ: {
                                    tileRecord.setBarcodeState(string, TileBarcodeProcessingState.QUEUED_FOR_WRITE);
                                    log.debug(String.format("Enqueuing work for tile %s and barcode %s.", tile.getNumber(), string));
                                    tasks.add(this.newBarcodeWorkInstance(tile, tileRecord, string));
                                    continue block8;
                                }
                            }
                        }
                    }
                    for (Runnable runnable : tasks) {
                        this.prioritizingThreadPool.execute(runnable);
                    }
                }
            }
        }

        private PriorityRunnable newBarcodeWorkInstance(final Tile tile, final TileProcessingRecord tileRecord, final String barcode) {
            return new PriorityRunnable(){

                @Override
                public void run() {
                    try {
                        SortingCollection records = tileRecord.getBarcodeRecords().get(barcode);
                        BasecallsConverter.ConvertedClusterDataWriter writer = (BasecallsConverter.ConvertedClusterDataWriter)IlluminaBasecallsConverter.this.barcodeRecordWriterMap.get(barcode);
                        log.debug(String.format("Writing records from tile %s with barcode %s ...", tile.getNumber(), barcode));
                        PeekIterator it = new PeekIterator(records.iterator());
                        while (it.hasNext()) {
                            Object lookAhead;
                            Object rec = it.next();
                            if (it.hasNext() && IlluminaBasecallsConverter.this.outputRecordComparator.compare(rec, lookAhead = it.peek()) == 0) {
                                it.next();
                                log.info("Skipping reads with identical read names: " + rec.toString());
                                continue;
                            }
                            writer.write(rec);
                            IlluminaBasecallsConverter.this.writeProgressLogger.record(null, 0);
                        }
                        tileRecord.setBarcodeState(barcode, TileBarcodeProcessingState.WRITTEN);
                        TileReadAggregator.this.findAndEnqueueWorkOrSignalCompletion();
                    }
                    catch (Error | RuntimeException e) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw e;
                    }
                }
            };
        }

        public boolean isWorkCompleted() {
            for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                TileProcessingRecord tileProcessingRecord = entry.getValue();
                if (tileProcessingRecord.getState() != TileProcessingState.DONE_READING) {
                    log.debug(String.format("Work is not completed because a tile isn't done being read: %s.", entry.getKey().getNumber()));
                    return false;
                }
                for (Map.Entry<String, TileBarcodeProcessingState> barcodeStateEntry : tileProcessingRecord.getBarcodeProcessingStates().entrySet()) {
                    TileBarcodeProcessingState barcodeProcessingState = barcodeStateEntry.getValue();
                    if (barcodeProcessingState == TileBarcodeProcessingState.WRITTEN) continue;
                    log.debug(String.format("Work is not completed because a tile isn't done being read: Tile %s, Barcode %s, Processing State %s.", new Object[]{entry.getKey().getNumber(), barcodeStateEntry.getKey(), barcodeProcessingState}));
                    return false;
                }
            }
            log.info("All work is complete.");
            return true;
        }

        public void shutdown() {
            this.prioritizingThreadPool.shutdownNow();
        }
    }

    private class TileReader {
        private final Tile tile;
        private final TileReadAggregator handler;
        private final TileProcessingRecord processingRecord;

        public TileReader(Tile tile, TileReadAggregator handler, TileProcessingRecord processingRecord) {
            this.tile = tile;
            this.handler = handler;
            this.processingRecord = processingRecord;
        }

        public void process() {
            BaseIlluminaDataProvider dataProvider = IlluminaBasecallsConverter.this.factory.makeDataProvider(Collections.singletonList(this.tile.getNumber()));
            log.debug(String.format("Reading data from tile %s ...", this.tile.getNumber()));
            while (dataProvider.hasNext()) {
                ClusterData cluster = (ClusterData)dataProvider.next();
                IlluminaBasecallsConverter.this.readProgressLogger.record(null, 0);
                if (!cluster.isPf().booleanValue() && !IlluminaBasecallsConverter.this.includeNonPfReads) continue;
                String barcode = IlluminaBasecallsConverter.this.demultiplex ? cluster.getMatchedBarcode() : null;
                this.processingRecord.addRecord(barcode, IlluminaBasecallsConverter.this.converter.convertClusterToOutputRecord(cluster));
            }
            this.handler.completeTile(this.tile);
            dataProvider.close();
        }
    }

    private class TileProcessingRecord {
        private final Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> barcodeToRecordCollection = new HashMap();
        private final Map<String, TileBarcodeProcessingState> barcodeToProcessingState = new HashMap<String, TileBarcodeProcessingState>();
        private TileProcessingState state = TileProcessingState.NOT_DONE_READING;
        private long recordCount = 0L;

        private TileProcessingRecord() {
        }

        public synchronized TileProcessingState getState() {
            return this.state;
        }

        public synchronized void setState(TileProcessingState state) {
            this.state = state;
        }

        public synchronized void addRecord(String barcode, CLUSTER_OUTPUT_RECORD record) {
            ++this.recordCount;
            SortingCollection recordCollection = this.barcodeToRecordCollection.get(barcode);
            if (recordCollection == null) {
                if (!IlluminaBasecallsConverter.this.barcodeRecordWriterMap.containsKey(barcode)) {
                    if (IlluminaBasecallsConverter.this.ignoreUnexpectedBarcodes) {
                        return;
                    }
                    throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", barcode));
                }
                recordCollection = this.newSortingCollection();
                this.barcodeToRecordCollection.put(barcode, recordCollection);
                this.barcodeToProcessingState.put(barcode, null);
            }
            recordCollection.add(record);
        }

        private synchronized SortingCollection<CLUSTER_OUTPUT_RECORD> newSortingCollection() {
            int maxRecordsInRam = Math.max(1, IlluminaBasecallsConverter.this.maxReadsInRamPerTile / IlluminaBasecallsConverter.this.barcodeRecordWriterMap.size());
            return SortingCollection.newInstance(IlluminaBasecallsConverter.this.outputRecordClass, IlluminaBasecallsConverter.this.codecPrototype.clone(), IlluminaBasecallsConverter.this.outputRecordComparator, maxRecordsInRam, IlluminaBasecallsConverter.this.tmpDirs);
        }

        public synchronized long getBarcodeCount() {
            return this.barcodeToRecordCollection.size();
        }

        public synchronized long getRecordCount() {
            return this.recordCount;
        }

        public synchronized Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> getBarcodeRecords() {
            return this.barcodeToRecordCollection;
        }

        public synchronized TileBarcodeProcessingState getBarcodeState(String barcode) {
            if (this.getState() == TileProcessingState.NOT_DONE_READING) {
                throw new IllegalStateException("A tile's barcode data's state cannot be queried until the tile has been completely read.");
            }
            return this.barcodeToProcessingState.getOrDefault(barcode, TileBarcodeProcessingState.NA);
        }

        public synchronized Map<String, TileBarcodeProcessingState> getBarcodeProcessingStates() {
            return this.barcodeToProcessingState;
        }

        public synchronized void setBarcodeState(String barcode, TileBarcodeProcessingState state) {
            if (!this.barcodeToProcessingState.containsKey(barcode)) {
                throw new NoSuchElementException(String.format("No record of the provided barcode, %s.", barcode));
            }
            this.barcodeToProcessingState.put(barcode, state);
        }

        public synchronized Set<String> getBarcodes() {
            return this.getBarcodeRecords().keySet();
        }
    }

    private abstract class PriorityRunnable
    implements Runnable {
        private final int priority;

        public PriorityRunnable() {
            this(1);
        }

        public PriorityRunnable(int priority) {
            this.priority = priority;
        }

        int getPriority() {
            return this.priority;
        }
    }

    private static class Tile
    implements Comparable<Tile> {
        private final int tileNumber;

        public Tile(int i) {
            this.tileNumber = i;
        }

        public int getNumber() {
            return this.tileNumber;
        }

        public boolean equals(Object o) {
            return o instanceof Tile && this.getNumber() == ((Tile)o).getNumber();
        }

        @Override
        public int compareTo(Tile o) {
            return BasecallsConverter.TILE_NUMBER_COMPARATOR.compare(this.getNumber(), o.getNumber());
        }
    }

    private static enum TileProcessingState {
        NOT_DONE_READING,
        DONE_READING;

    }

    private static enum TileBarcodeProcessingState {
        NA,
        READ,
        QUEUED_FOR_WRITE,
        WRITTEN;

    }
}

