/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import picard.PicardException;
import picard.illumina.parser.MultiTileBclFileUtil;
import picard.illumina.parser.MultiTileFilterFileUtil;
import picard.illumina.parser.MultiTileLocsFileUtil;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.PerTileFileUtil;
import picard.illumina.parser.PerTileOrPerRunFileUtil;
import picard.illumina.parser.PerTilePerCycleFileUtil;
import picard.illumina.parser.fakers.BarcodeFileFaker;
import picard.illumina.parser.fakers.BclFileFaker;
import picard.illumina.parser.fakers.ClocsFileFaker;
import picard.illumina.parser.fakers.FilterFileFaker;
import picard.illumina.parser.fakers.LocsFileFaker;
import picard.illumina.parser.fakers.PosFileFaker;
import picard.illumina.parser.readers.TileMetricsOutReader;

public class IlluminaFileUtil {
    public static final Pattern CYCLE_SUBDIRECTORY_PATTERN = Pattern.compile("^C(\\d+)\\.1$");
    private final File basecallLaneDir;
    private final File intensityLaneDir;
    private final File basecallDir;
    private final File barcodeDir;
    private final File intensityDir;
    private final int lane;
    private final File tileMetricsOut;
    private final Map<SupportedIlluminaFormat, ParameterizedFileUtil> utils = new EnumMap<SupportedIlluminaFormat, ParameterizedFileUtil>(SupportedIlluminaFormat.class);

    public IlluminaFileUtil(File basecallDir, int lane) {
        this(basecallDir, null, lane);
    }

    public IlluminaFileUtil(File basecallDir, File barcodeDir, int lane) {
        this.lane = lane;
        this.basecallDir = basecallDir;
        this.barcodeDir = barcodeDir;
        this.intensityDir = basecallDir.getParentFile();
        File dataDir = this.intensityDir.getParentFile();
        this.basecallLaneDir = new File(basecallDir, IlluminaFileUtil.longLaneStr(lane));
        this.intensityLaneDir = new File(this.intensityDir, IlluminaFileUtil.longLaneStr(lane));
        File interopDir = new File(dataDir.getParentFile(), "InterOp");
        this.tileMetricsOut = new File(interopDir, "TileMetricsOut.bin");
    }

    public int getLane() {
        return this.lane;
    }

    public ParameterizedFileUtil getUtil(SupportedIlluminaFormat format) {
        ParameterizedFileUtil parameterizedFileUtil = this.utils.get((Object)format);
        if (parameterizedFileUtil == null) {
            switch (format) {
                case Bcl: {
                    PerTilePerCycleFileUtil bclFileUtil = new PerTilePerCycleFileUtil(".bcl", this.basecallLaneDir, new BclFileFaker(), this.lane);
                    PerTilePerCycleFileUtil gzBclFileUtil = new PerTilePerCycleFileUtil(".bcl.gz", this.basecallLaneDir, new BclFileFaker(), this.lane);
                    if (((ParameterizedFileUtil)bclFileUtil).filesAvailable() && !((ParameterizedFileUtil)gzBclFileUtil).filesAvailable()) {
                        parameterizedFileUtil = bclFileUtil;
                    } else if (!((ParameterizedFileUtil)bclFileUtil).filesAvailable() && ((ParameterizedFileUtil)gzBclFileUtil).filesAvailable()) {
                        parameterizedFileUtil = gzBclFileUtil;
                    } else if (!((ParameterizedFileUtil)bclFileUtil).filesAvailable() && !((ParameterizedFileUtil)gzBclFileUtil).filesAvailable()) {
                        parameterizedFileUtil = bclFileUtil;
                    } else {
                        throw new PicardException("Not all BCL files in " + this.basecallLaneDir.getAbsolutePath() + " have the same extension!");
                    }
                    this.utils.put(SupportedIlluminaFormat.Bcl, parameterizedFileUtil);
                    break;
                }
                case Locs: {
                    parameterizedFileUtil = new PerTileOrPerRunFileUtil(".locs", this.intensityLaneDir, new LocsFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Locs, parameterizedFileUtil);
                    break;
                }
                case Clocs: {
                    parameterizedFileUtil = new PerTileFileUtil(".clocs", this.intensityLaneDir, new ClocsFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Clocs, parameterizedFileUtil);
                    break;
                }
                case Pos: {
                    parameterizedFileUtil = new PerTileFileUtil("_pos.txt", this.intensityDir, new PosFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Pos, parameterizedFileUtil);
                    break;
                }
                case Filter: {
                    parameterizedFileUtil = new PerTileFileUtil(".filter", this.basecallLaneDir, new FilterFileFaker(), this.lane);
                    this.utils.put(SupportedIlluminaFormat.Filter, parameterizedFileUtil);
                    break;
                }
                case Barcode: {
                    parameterizedFileUtil = new PerTileFileUtil("_barcode.txt", this.barcodeDir != null ? this.barcodeDir : this.basecallDir, new BarcodeFileFaker(), this.lane, false);
                    this.utils.put(SupportedIlluminaFormat.Barcode, parameterizedFileUtil);
                    break;
                }
                case MultiTileFilter: {
                    parameterizedFileUtil = new MultiTileFilterFileUtil(this.basecallLaneDir, this.lane);
                    this.utils.put(SupportedIlluminaFormat.MultiTileFilter, parameterizedFileUtil);
                    break;
                }
                case MultiTileLocs: {
                    parameterizedFileUtil = new MultiTileLocsFileUtil(new File(this.intensityDir, this.basecallLaneDir.getName()), this.basecallLaneDir, this.lane);
                    this.utils.put(SupportedIlluminaFormat.MultiTileLocs, parameterizedFileUtil);
                    break;
                }
                case MultiTileBcl: {
                    parameterizedFileUtil = new MultiTileBclFileUtil(this.basecallLaneDir, this.lane);
                    this.utils.put(SupportedIlluminaFormat.MultiTileBcl, parameterizedFileUtil);
                }
            }
        }
        return parameterizedFileUtil;
    }

    public List<Integer> getExpectedTiles() {
        IOUtil.assertFileIsReadable(this.tileMetricsOut);
        TreeSet<Integer> expectedTiles = new TreeSet<Integer>();
        TileMetricsOutReader tileMetrics = new TileMetricsOutReader(this.tileMetricsOut, TileMetricsOutReader.TileMetricsVersion.TWO);
        while (tileMetrics.hasNext()) {
            TileMetricsOutReader.IlluminaTileMetrics tileMetric = (TileMetricsOutReader.IlluminaTileMetrics)tileMetrics.next();
            if (tileMetric.getLaneNumber() != this.lane || expectedTiles.contains(tileMetric.getTileNumber())) continue;
            expectedTiles.add(tileMetric.getTileNumber());
        }
        CloserUtil.close(tileMetrics);
        return new ArrayList<Integer>(expectedTiles);
    }

    public List<Integer> getActualTiles(List<SupportedIlluminaFormat> formats) {
        if (formats == null) {
            throw new PicardException("Format list provided to getTiles was null!");
        }
        if (formats.isEmpty()) {
            throw new PicardException("0 Formats were specified.  You need to specify at least SupportedIlluminaFormat to use getTiles");
        }
        List<ParameterizedFileUtil> tileBasedFormats = formats.stream().map(this::getUtil).filter(ParameterizedFileUtil::checkTileCount).collect(Collectors.toList());
        if (tileBasedFormats.size() > 0) {
            List<Integer> expectedTiles = ((ParameterizedFileUtil)tileBasedFormats.get(0)).getTiles();
            tileBasedFormats.forEach(util -> {
                if (expectedTiles.size() != util.getTiles().size() || !expectedTiles.containsAll(util.getTiles())) {
                    throw new PicardException("Formats do not have the same number of tiles! " + this.summarizeTileCounts(formats));
                }
            });
            return expectedTiles;
        }
        return new ArrayList<Integer>();
    }

    public File tileMetricsOut() {
        return this.tileMetricsOut;
    }

    public static String longLaneStr(int lane) {
        StringBuilder lstr = new StringBuilder(String.valueOf(lane));
        int zerosToAdd = 3 - lstr.length();
        for (int i = 0; i < zerosToAdd; ++i) {
            lstr.insert(0, "0");
        }
        return "L" + lstr;
    }

    private String liToStr(List<Integer> intList) {
        if (intList.isEmpty()) {
            return "";
        }
        StringBuilder summary = new StringBuilder(String.valueOf(intList.get(0)));
        for (int i = 1; i < intList.size(); ++i) {
            summary.append(", ").append(String.valueOf(intList.get(i)));
        }
        return summary.toString();
    }

    private String summarizeTileCounts(List<SupportedIlluminaFormat> formats) {
        ParameterizedFileUtil pfu = this.getUtil(formats.get(0));
        List<Integer> tiles = pfu.getTiles();
        StringBuilder summary = new StringBuilder(pfu.extension + "(" + this.liToStr(tiles) + ")");
        for (SupportedIlluminaFormat format : formats) {
            pfu = this.getUtil(format);
            tiles = pfu.getTiles();
            summary.append(", ").append(pfu.extension).append("(").append(this.liToStr(tiles)).append(")");
        }
        return summary.toString();
    }

    public static boolean hasCbcls(File basecallDir, int lane) {
        File laneDir = new File(basecallDir, IlluminaFileUtil.longLaneStr(lane));
        File[] cycleDirs = IOUtil.getFilesMatchingRegexp(laneDir, CYCLE_SUBDIRECTORY_PATTERN);
        if (cycleDirs == null) {
            return false;
        }
        ArrayList cbcls = new ArrayList();
        Arrays.asList(cycleDirs).forEach(cycleDir -> cbcls.addAll(Arrays.asList(IOUtil.getFilesMatchingRegexp(cycleDir, "^" + IlluminaFileUtil.longLaneStr(lane) + "_(\\d{1,5}).cbcl$"))));
        return cbcls.size() > 0;
    }

    public static enum SupportedIlluminaFormat {
        Bcl,
        Locs,
        Clocs,
        Pos,
        Filter,
        Barcode,
        MultiTileFilter,
        MultiTileLocs,
        MultiTileBcl;

    }
}

