/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tool takes in an aligned SAM or BAM and adds the OA tag to every aligned read unless an interval list is specified, where it only adds the tag to reads that fall within the intervals in the interval list. This can be useful if you are about to realign but want to keep the original alignment information as a separate tag.<br /><h4>Usage example:</h4><pre>java -jar picard.jar AddOATag \\<br />      L=some_picard.interval_list \\<br />      I=sorted.bam \\<br />      O=fixed.bam <br /></pre>", oneLineSummary="Record current alignment information to OA tag.", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class AddOATag
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Record current alignment information to OA tag.";
    static final String USAGE_DETAILS = "This tool takes in an aligned SAM or BAM and adds the OA tag to every aligned read unless an interval list is specified, where it only adds the tag to reads that fall within the intervals in the interval list. This can be useful if you are about to realign but want to keep the original alignment information as a separate tag.<br /><h4>Usage example:</h4><pre>java -jar picard.jar AddOATag \\<br />      L=some_picard.interval_list \\<br />      I=sorted.bam \\<br />      O=fixed.bam <br /></pre>";
    @Argument(shortName="I", doc="SAM or BAM input file")
    public String INPUT;
    @Argument(shortName="O", doc="SAM or BAM file to write merged result to")
    public String OUTPUT;
    @Argument(shortName="L", doc="If provided, only records that overlap given interval list will have the OA tag added.", optional=true)
    public File INTERVAL_LIST;
    public static final String OA = "OA";
    private static final Log log = Log.getInstance(AddOATag.class);

    @Override
    protected int doWork() {
        try (SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(IOUtil.getPath(this.INPUT));
             SAMFileWriter writer = new SAMFileWriterFactory().makeWriter(reader.getFileHeader(), true, IOUtil.getPath(this.OUTPUT), this.REFERENCE_SEQUENCE);){
            writer.setProgressLogger(new ProgressLogger(log, 10000000, "Wrote", "records"));
            OverlapDetector<Interval> overlapDetector = AddOATag.getOverlapDetectorFromIntervalListFile(this.INTERVAL_LIST, 0, 0);
            for (SAMRecord rec : reader) {
                if (overlapDetector == null || overlapDetector.overlapsAny(rec)) {
                    this.setOATag(rec);
                }
                writer.addAlignment(rec);
            }
        }
        catch (IOException e) {
            log.error(e, new Object[0]);
            return 1;
        }
        return 0;
    }

    static OverlapDetector<Interval> getOverlapDetectorFromIntervalListFile(File intervalList, int lhsBuffer, int rhsBuffer) {
        if (intervalList == null) {
            return null;
        }
        List<Interval> intervals = IntervalList.fromFile(intervalList).uniqued().getIntervals();
        OverlapDetector<Interval> detector = new OverlapDetector<Interval>(lhsBuffer, rhsBuffer);
        detector.addAll(intervals, intervals);
        return detector;
    }

    private void setOATag(SAMRecord rec) {
        if (rec.getReferenceName().contains(",")) {
            throw new PicardException(String.format("Reference name for record %s contains a comma character.", rec.getReadName()));
        }
        String oaValue = rec.getReadUnmappedFlag() ? String.format("*,0,%s,*,255,;", rec.getReadNegativeStrandFlag() ? "-" : "+") : String.format("%s,%s,%s,%s,%s,%s;", rec.getReferenceName(), rec.getAlignmentStart(), rec.getReadNegativeStrandFlag() ? "-" : "+", rec.getCigarString(), rec.getMappingQuality(), Optional.ofNullable(rec.getAttribute(SAMTag.NM.name())).orElse(""));
        rec.setAttribute(OA, (Object)(Optional.ofNullable(rec.getAttribute(OA)).orElse("") + oaValue));
    }
}

