/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.AbstractIterator;
import htsjdk.samtools.util.CloseableIterator;
import java.util.Iterator;
import picard.PicardException;

public abstract class AbstractInputParser
extends AbstractIterator<String[]>
implements Iterable<String[]>,
CloseableIterator<String[]> {
    private boolean treatGroupedDelimitersAsOne = true;
    private int wordCount = 0;
    private boolean skipBlankLines = true;

    @Override
    public abstract void close();

    protected abstract byte[] readNextLine();

    public abstract String getFileName();

    @Override
    public Iterator<String[]> iterator() {
        if (this.isIterating()) {
            throw new IllegalStateException("iterator() method can only be called once, before thefirst call to hasNext()");
        }
        this.hasNext();
        return this;
    }

    @Override
    protected String[] advance() {
        byte[] nextLine;
        while ((nextLine = this.readNextLine()) != null && (this.skipBlankLines && this.isBlank(nextLine) || this.isComment(nextLine))) {
        }
        return nextLine == null ? null : this.parseLine(nextLine);
    }

    private String[] parseLine(byte[] line) {
        if (this.getWordCount() == 0) {
            this.calculateWordCount(line);
        }
        String[] parts = new String[this.getWordCount()];
        boolean delimiter = true;
        int index = 0;
        int start = 0;
        try {
            for (int i = 0; i < line.length; ++i) {
                if (this.isDelimiter(line[i])) {
                    if (!delimiter) {
                        parts[index++] = new String(line, start, i - start);
                    } else if (!this.isTreatGroupedDelimitersAsOne()) {
                        parts[index++] = null;
                    }
                    delimiter = true;
                    continue;
                }
                if (delimiter) {
                    start = i;
                }
                delimiter = false;
            }
            if (!delimiter) {
                parts[index] = new String(line, start, line.length - start);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PicardException("Unexpected number of elements found when parsing file " + this.getFileName() + ": " + index + ".  Expected a maximum of " + this.getWordCount() + " elements per line:" + new String(line, 0, line.length), e);
        }
        return parts;
    }

    protected void calculateWordCount(byte[] line) {
        int words = 0;
        boolean delimiter = true;
        for (byte b : line) {
            if (this.isDelimiter(b)) {
                if (delimiter && !this.isTreatGroupedDelimitersAsOne()) {
                    ++words;
                }
                delimiter = true;
                continue;
            }
            if (delimiter) {
                ++words;
            }
            delimiter = false;
        }
        if (delimiter && !this.isTreatGroupedDelimitersAsOne()) {
            ++words;
        }
        this.setWordCount(words);
    }

    protected boolean isComment(byte[] line) {
        return line.length > 0 && line[0] == 35;
    }

    protected boolean isBlank(byte[] line) {
        return line.length == 0;
    }

    protected boolean isDelimiter(byte b) {
        return b == 32 || b == 9;
    }

    protected int getWordCount() {
        return this.wordCount;
    }

    protected void setWordCount(int wordCount) {
        this.wordCount = wordCount;
    }

    protected boolean isTreatGroupedDelimitersAsOne() {
        return this.treatGroupedDelimitersAsOne;
    }

    protected void setTreatGroupedDelimitersAsOne(boolean treatGroupedDelimitersAsOne) {
        this.treatGroupedDelimitersAsOne = treatGroupedDelimitersAsOne;
    }

    protected boolean isSkipBlankLines() {
        return this.skipBlankLines;
    }

    protected void setSkipBlankLines(boolean skipBlankLines) {
        this.skipBlankLines = skipBlankLines;
    }
}

