/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import java.util.List;
import picard.vcf.filter.VariantFilter;

public class QdFilter
implements VariantFilter {
    public static final String FILTER_NAME = "LowQD";
    private final double minimumQd;

    public QdFilter(double minimumQd) {
        this.minimumQd = minimumQd;
    }

    @Override
    public String filter(VariantContext ctx) {
        double qd = ctx.getAttributeAsDouble("QD", -1.0);
        if (qd >= 0.0 && qd < this.minimumQd) {
            return FILTER_NAME;
        }
        return null;
    }

    @Override
    public List<VCFFilterHeaderLine> headerLines() {
        return CollectionUtil.makeList(new VCFFilterHeaderLine(FILTER_NAME, "Site exhibits QD value below a hard limit."));
    }
}

