/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BaseStorageWriteChannel;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.LazyWriteChannel;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.Retrying;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.util.function.Supplier;

final class GrpcBlobWriteChannel
extends BaseStorageWriteChannel<WriteObjectResponse> {
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final Retrying.RetryingDependencies deps;
    private final ResultRetryAlgorithm<?> alg;
    private final Supplier<ApiFuture<ResumableWrite>> start;
    private final Hasher hasher;

    GrpcBlobWriteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, Supplier<ApiFuture<ResumableWrite>> start, Hasher hasher) {
        super(Conversions.grpc().blobInfo().compose(WriteObjectResponse::getResource));
        this.write = write;
        this.deps = deps;
        this.alg = alg;
        this.start = start;
        this.hasher = hasher;
    }

    @Override
    public RestorableState<WriteChannel> capture() {
        return (RestorableState)GrpcStorageImpl.throwHttpJsonOnly(WriteChannel.class, "capture");
    }

    @Override
    protected LazyWriteChannel<WriteObjectResponse> newLazyWriteChannel() {
        return new LazyWriteChannel<WriteObjectResponse>(() -> ResumableMedia.gapic().write().byteChannel(this.write).setHasher(this.hasher).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(this.deps, this.alg).buffered(this.getBufferHandle()).setStartAsync(this.start.get()).build());
    }
}

