/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GrpcResumableSession {
    private final Retrying.RetryingDependencies deps;
    private final ResultRetryAlgorithm<?> alg;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeCallable;
    private final UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable;
    private final ResumableWrite resumableWrite;
    private final Hasher hasher;

    GrpcResumableSession(Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeCallable, UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable, ResumableWrite resumableWrite, Hasher hasher) {
        this.deps = deps;
        this.alg = alg;
        this.writeCallable = writeCallable;
        this.queryWriteStatusCallable = queryWriteStatusCallable;
        this.resumableWrite = resumableWrite;
        this.hasher = hasher;
    }

    ResumableOperationResult<@Nullable com.google.storage.v2.Object> query() {
        QueryWriteStatusRequest.Builder b = QueryWriteStatusRequest.newBuilder().setUploadId(this.resumableWrite.getRes().getUploadId());
        if (this.resumableWrite.getReq().hasCommonObjectRequestParams()) {
            b.setCommonObjectRequestParams(this.resumableWrite.getReq().getCommonObjectRequestParams());
        }
        QueryWriteStatusRequest req = b.build();
        try {
            QueryWriteStatusResponse response = this.queryWriteStatusCallable.call(req);
            if (response.hasResource()) {
                return ResumableOperationResult.complete(response.getResource(), response.getResource().getSize());
            }
            return ResumableOperationResult.incremental(response.getPersistedSize());
        }
        catch (Exception e) {
            throw StorageException.coalesce(e);
        }
    }

    ResumableOperationResult<@Nullable com.google.storage.v2.Object> put(RewindableContent content) {
        AtomicBoolean dirty = new AtomicBoolean(false);
        GrpcCallContext retryingCallContext = Retrying.newCallContext();
        BufferHandle handle = BufferHandle.allocate(0x200000);
        return (ResumableOperationResult)Retrying.run(this.deps, this.alg, () -> {
            if (dirty.getAndSet(true)) {
                ResumableOperationResult<@Nullable com.google.storage.v2.Object> query = this.query();
                if (query.getObject() != null) {
                    return query;
                }
                content.rewindTo(query.getPersistedSize());
            }
            BufferedWritableByteChannelSession<WriteObjectResponse> session = ResumableMedia.gapic().write().byteChannel(this.writeCallable.withDefaultCallContext(retryingCallContext)).setByteStringStrategy(ByteStringStrategy.copy()).setHasher(this.hasher).resumable().setFsyncEvery(false).buffered(handle).setStartAsync(ApiFutures.immediateFuture(this.resumableWrite)).build();
            try (BufferedWritableByteChannelSession.BufferedWritableByteChannel channel = (BufferedWritableByteChannelSession.BufferedWritableByteChannel)session.open();){
                content.writeTo(channel);
            }
            WriteObjectResponse response = (WriteObjectResponse)session.getResult().get();
            if (response.hasResource()) {
                return ResumableOperationResult.complete(response.getResource(), response.getResource().getSize());
            }
            return ResumableOperationResult.incremental(response.getPersistedSize());
        }, Conversions.Decoder.identity());
    }
}

