/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageObjectAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageObjectImmutableException;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import com.google.cloud.storage.contrib.nio.CloudStoragePseudoDirectoryAttributes;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CloudStorageFileAttributeView
implements BasicFileAttributeView {
    private final Storage storage;
    private final CloudStoragePath path;

    CloudStorageFileAttributeView(Storage storage, CloudStoragePath path) {
        this.storage = Preconditions.checkNotNull(storage);
        this.path = Preconditions.checkNotNull(path);
    }

    @Override
    public String name() {
        return "gcs";
    }

    @Override
    public CloudStorageFileAttributes readAttributes() throws IOException {
        if (this.path.seemsLikeADirectory() && this.path.getFileSystem().config().usePseudoDirectories()) {
            return new CloudStoragePseudoDirectoryAttributes(this.path);
        }
        Blob blobInfo = this.storage.get(this.path.getBlobId());
        if (blobInfo == null) {
            throw new NoSuchFileException(this.path.toUri().toString());
        }
        return new CloudStorageObjectAttributes(blobInfo);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
        throw new CloudStorageObjectImmutableException();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CloudStorageFileAttributeView && Objects.equals(this.storage, ((CloudStorageFileAttributeView)other).storage) && Objects.equals(this.path, ((CloudStorageFileAttributeView)other).path);
    }

    public int hashCode() {
        return Objects.hash(this.storage, this.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("storage", this.storage).add("path", this.path).toString();
    }
}

