/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.Storage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

@BetaApi
public final class ParallelUploadConfig {
    private final boolean skipIfExists;
    private final @NonNull String prefix;
    private final @NonNull String bucketName;
    private final @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest;

    private ParallelUploadConfig(boolean skipIfExists, @NonNull String prefix, @NonNull String bucketName, @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest) {
        this.skipIfExists = skipIfExists;
        this.prefix = prefix;
        this.bucketName = bucketName;
        this.writeOptsPerRequest = ParallelUploadConfig.applySkipIfExists(skipIfExists, writeOptsPerRequest);
    }

    @BetaApi
    public boolean isSkipIfExists() {
        return this.skipIfExists;
    }

    @BetaApi
    public @NonNull String getPrefix() {
        return this.prefix;
    }

    @BetaApi
    public @NonNull String getBucketName() {
        return this.bucketName;
    }

    @BetaApi
    public @NonNull List<Storage.BlobWriteOption> getWriteOptsPerRequest() {
        return this.writeOptsPerRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParallelUploadConfig that = (ParallelUploadConfig)o;
        return this.skipIfExists == that.skipIfExists && this.prefix.equals(that.prefix) && this.bucketName.equals(that.bucketName) && this.writeOptsPerRequest.equals(that.writeOptsPerRequest);
    }

    public int hashCode() {
        return Objects.hash(this.skipIfExists, this.prefix, this.bucketName, this.writeOptsPerRequest);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("skipIfExists", this.skipIfExists).add("prefix", this.prefix).add("bucketName", this.bucketName).add("writeOptsPerRequest", this.writeOptsPerRequest).toString();
    }

    @BetaApi
    public static Builder newBuilder() {
        return new Builder();
    }

    private static List<Storage.BlobWriteOption> applySkipIfExists(boolean skipIfExists, List<Storage.BlobWriteOption> writeOptsPerRequest) {
        if (skipIfExists) {
            return ImmutableList.copyOf(Storage.BlobWriteOption.dedupe(writeOptsPerRequest, Storage.BlobWriteOption.doesNotExist()));
        }
        return writeOptsPerRequest;
    }

    @BetaApi
    public static final class Builder {
        private boolean skipIfExists;
        private @NonNull String prefix = "";
        private @NonNull String bucketName = "";
        private @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest = ImmutableList.of();

        private Builder() {
        }

        @BetaApi
        public Builder setSkipIfExists(boolean skipIfExists) {
            this.skipIfExists = skipIfExists;
            return this;
        }

        @BetaApi
        public Builder setPrefix(@NonNull String prefix) {
            this.prefix = prefix;
            return this;
        }

        @BetaApi
        public Builder setBucketName(@NonNull String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @BetaApi
        public Builder setWriteOptsPerRequest(@NonNull List<Storage.BlobWriteOption> writeOptsPerRequest) {
            this.writeOptsPerRequest = writeOptsPerRequest;
            return this;
        }

        @BetaApi
        public ParallelUploadConfig build() {
            Preconditions.checkNotNull(this.prefix);
            Preconditions.checkNotNull(this.bucketName);
            Preconditions.checkNotNull(this.writeOptsPerRequest);
            return new ParallelUploadConfig(this.skipIfExists, this.prefix, this.bucketName, this.writeOptsPerRequest);
        }
    }
}

