/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl;

import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import java.util.regex.Pattern;
import org.broadinstitute.gatk.nativebindings.NativeLibrary;

public final class IntelGKLUtils
implements NativeLibrary {
    private static final String NATIVE_LIBRARY_NAME;
    private static boolean initialized;
    private static final Object lock_class;
    private static final String TEST_RESOURCES_PATH;
    private static final String TEST_RESOURCES_ABSPATH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load(File tempDir) {
        Object object = lock_class;
        synchronized (object) {
            if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
                return false;
            }
            if (!initialized) {
                initialized = true;
            }
        }
        return true;
    }

    public static String pathToTestResource(String filename) throws NullPointerException, IllegalArgumentException {
        if (filename == null) {
            throw new NullPointerException("Input is null");
        }
        Pattern pattern = Pattern.compile("[-_.A-Za-z0-9]+");
        if (!pattern.matcher(filename).matches()) {
            throw new IllegalArgumentException("Invalid filename");
        }
        return TEST_RESOURCES_ABSPATH + filename;
    }

    public boolean getFlushToZero() {
        return this.getFlushToZeroNative();
    }

    public void setFlushToZero(boolean value) {
        this.setFlushToZeroNative(value);
    }

    public boolean isAvxSupported() {
        return this.isAvxSupportedNative();
    }

    public boolean isAvx2Supported() {
        return this.isAvx2SupportedNative();
    }

    public boolean isAvx512Supported() {
        return this.isAvx512SupportedNative();
    }

    public int getAvailableOmpThreads() {
        return this.getAvailableOmpThreadsNative();
    }

    private native boolean getFlushToZeroNative();

    private native void setFlushToZeroNative(boolean var1);

    private native boolean isAvxSupportedNative();

    private native boolean isAvx2SupportedNative();

    private native boolean isAvx512SupportedNative();

    private native int getAvailableOmpThreadsNative();

    static {
        lock_class = new Object();
        NATIVE_LIBRARY_NAME = "gkl_utils";
        initialized = false;
        TEST_RESOURCES_PATH = System.getProperty("user.dir") + "/src/test/resources/";
        TEST_RESOURCES_ABSPATH = new File(TEST_RESOURCES_PATH).getAbsolutePath() + "/";
    }
}

