/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.compression;

import com.intel.gkl.compression.IntelDeflater;
import htsjdk.samtools.util.zip.DeflaterFactory;
import java.io.File;
import java.util.zip.Deflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntelDeflaterFactory
extends DeflaterFactory {
    private static final Log logger = LogFactory.getLog(IntelDeflaterFactory.class);
    private boolean intelDeflaterSupported;

    public IntelDeflaterFactory(File tmpDir) {
        this.intelDeflaterSupported = new IntelDeflater().load(tmpDir);
    }

    public IntelDeflaterFactory() {
        this(null);
    }

    @Override
    public Deflater makeDeflater(int compressionLevel, boolean gzipCompatible) {
        if (this.intelDeflaterSupported) {
            try {
                return new IntelDeflater(compressionLevel, gzipCompatible);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid configuration requsted, using Java.util.zip.Deflater");
            }
        } else {
            logger.warn("Intel Deflater not supported, using Java.util.zip.Deflater");
        }
        return new Deflater(compressionLevel, gzipCompatible);
    }

    public boolean usingIntelDeflater() {
        return this.intelDeflaterSupported;
    }
}

