/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.smithwaterman;

import com.intel.gkl.IntelGKLUtils;
import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWAlignerNativeBinding;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWNativeAlignerResult;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWParameters;

public class IntelSmithWaterman
implements SWAlignerNativeBinding {
    private static final Log logger = LogFactory.getLog(IntelSmithWaterman.class);
    private static final String NATIVE_LIBRARY_NAME = "gkl_smithwaterman";
    private String nativeLibraryName = "gkl_smithwaterman";
    private static boolean initialized = false;
    private static final Object lock_class = new Object();
    private IntelGKLUtils gklUtils = new IntelGKLUtils();
    private final int MAX_SW_SEQUENCE_LENGTH = Short.MAX_VALUE;
    private final int MAXIMUM_SW_MATCH_VALUE = 65536;

    void setNativeLibraryName(String nativeLibraryName) {
        this.nativeLibraryName = nativeLibraryName;
    }

    public IntelSmithWaterman() {
        this.setNativeLibraryName(NATIVE_LIBRARY_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load(File tempDir) {
        boolean isLoaded = this.gklUtils.load(null);
        if (!isLoaded) {
            logger.warn("Intel GKL Utils not loaded");
            return false;
        }
        if (!this.gklUtils.isAvxSupported() || !this.gklUtils.isAvx2Supported()) {
            return false;
        }
        if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
            return false;
        }
        Object object = lock_class;
        synchronized (object) {
            if (!initialized) {
                initialized = true;
            }
        }
        if (this.gklUtils.isAvx512Supported()) {
            logger.info("Using CPU-supported AVX-512 instructions");
        }
        IntelSmithWaterman.initNative();
        return true;
    }

    @Override
    public SWNativeAlignerResult align(byte[] refArray, byte[] altArray, SWParameters parameters, SWOverhangStrategy overhangStrategy) throws NullPointerException, OutOfMemoryError, IllegalArgumentException {
        int offset = 0;
        if (refArray == null) {
            throw new NullPointerException("Reference data array is null.");
        }
        if (altArray == null) {
            throw new NullPointerException("Alternate data array is null.");
        }
        if (parameters == null) {
            throw new NullPointerException("Parameter structure is null.");
        }
        if (overhangStrategy == null) {
            throw new NullPointerException("OverhangStrategy is null.");
        }
        if (refArray.length <= 0 || altArray.length <= 0) {
            throw new IllegalArgumentException("Cannot align empty sequences");
        }
        byte intStrategy = this.getStrategy(overhangStrategy);
        byte[] cigar = new byte[2 * Integer.max(refArray.length, altArray.length)];
        if (refArray.length > Short.MAX_VALUE || altArray.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Sequences exceed maximum length of %d bytes", Short.MAX_VALUE));
        }
        if (parameters.getMatchValue() > 65536) {
            throw new IllegalArgumentException(String.format("Match value parameter exceed maximum value of %d", 65536));
        }
        if (cigar.length <= 0 || intStrategy < 9 || intStrategy > 12) {
            throw new IllegalArgumentException("Strategy is invalid.");
        }
        try {
            offset = IntelSmithWaterman.alignNative(refArray, altArray, cigar, parameters.getMatchValue(), parameters.getMismatchPenalty(), parameters.getGapOpenPenalty(), parameters.getGapExtendPenalty(), intStrategy);
        }
        catch (OutOfMemoryError e) {
            logger.warn("Exception thrown from native SW alignNative function call " + e.getMessage());
            throw new OutOfMemoryError("Memory allocation failed");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Exception thrown from native SW alignNative function call " + e.getMessage());
            throw new IllegalArgumentException("Ran into invalid argument issue");
        }
        return new SWNativeAlignerResult(new String(cigar, StandardCharsets.UTF_8).trim(), offset);
    }

    public byte getStrategy(SWOverhangStrategy strategy) {
        byte intStrategy = 0;
        switch (strategy) {
            case SOFTCLIP: {
                intStrategy = 9;
                break;
            }
            case INDEL: {
                intStrategy = 10;
                break;
            }
            case LEADING_INDEL: {
                intStrategy = 11;
                break;
            }
            case IGNORE: {
                intStrategy = 12;
            }
        }
        return intStrategy;
    }

    @Override
    public void close() {
        IntelSmithWaterman.doneNative();
    }

    private static native void initNative();

    private static native int alignNative(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5, int var6, byte var7);

    private static native void doneNative();
}

