/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.bam;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.plugin.reads.ReadsDecoder;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.utils.ValidationUtils;

public abstract class BAMDecoder
implements ReadsDecoder {
    private final Bundle inputBundle;
    private final ReadsDecoderOptions readsDecoderOptions;
    private final String displayName;

    public BAMDecoder(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        ValidationUtils.nonNull(inputBundle, "inputBundle");
        ValidationUtils.nonNull(readsDecoderOptions, "readsDecoderOptions");
        this.inputBundle = inputBundle;
        this.displayName = inputBundle.getOrThrow("ALIGNED_READS").getDisplayName();
        this.readsDecoderOptions = readsDecoderOptions;
    }

    @Override
    public final String getFileFormat() {
        return "BAM";
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    public Bundle getInputBundle() {
        return this.inputBundle;
    }

    public ReadsDecoderOptions getReadsDecoderOptions() {
        return this.readsDecoderOptions;
    }
}

