/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMHeaderRecordComparator;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CigarUtil;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.StringUtil;
import htsjdk.tribble.annotation.Strand;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class SAMUtils {
    private static final Pattern SEMICOLON_PAT = Pattern.compile("[;]");
    private static final Pattern COMMA_PAT = Pattern.compile("[,]");
    private static final byte COMPRESSED_EQUAL_LOW = 0;
    private static final byte COMPRESSED_A_LOW = 1;
    private static final byte COMPRESSED_C_LOW = 2;
    private static final byte COMPRESSED_M_LOW = 3;
    private static final byte COMPRESSED_G_LOW = 4;
    private static final byte COMPRESSED_R_LOW = 5;
    private static final byte COMPRESSED_S_LOW = 6;
    private static final byte COMPRESSED_V_LOW = 7;
    private static final byte COMPRESSED_T_LOW = 8;
    private static final byte COMPRESSED_W_LOW = 9;
    private static final byte COMPRESSED_Y_LOW = 10;
    private static final byte COMPRESSED_H_LOW = 11;
    private static final byte COMPRESSED_K_LOW = 12;
    private static final byte COMPRESSED_D_LOW = 13;
    private static final byte COMPRESSED_B_LOW = 14;
    private static final byte COMPRESSED_N_LOW = 15;
    private static final byte COMPRESSED_EQUAL_HIGH = 0;
    private static final byte COMPRESSED_A_HIGH = 16;
    private static final byte COMPRESSED_C_HIGH = 32;
    private static final byte COMPRESSED_G_HIGH = 64;
    private static final byte COMPRESSED_T_HIGH = -128;
    private static final byte COMPRESSED_N_HIGH = -16;
    private static final byte COMPRESSED_M_HIGH = 48;
    private static final byte COMPRESSED_R_HIGH = 80;
    private static final byte COMPRESSED_S_HIGH = 96;
    private static final byte COMPRESSED_V_HIGH = 112;
    private static final byte COMPRESSED_W_HIGH = -112;
    private static final byte COMPRESSED_Y_HIGH = -96;
    private static final byte COMPRESSED_H_HIGH = -80;
    private static final byte COMPRESSED_K_HIGH = -64;
    private static final byte COMPRESSED_D_HIGH = -48;
    private static final byte COMPRESSED_B_HIGH = -32;
    private static final byte[] COMPRESSED_LOOKUP_TABLE = new byte[]{61, 65, 67, 77, 71, 82, 83, 86, 84, 87, 89, 72, 75, 68, 66, 78};
    public static final int MAX_PHRED_SCORE = 93;
    private static final SAMHeaderRecordComparator<SAMReadGroupRecord> HEADER_RECORD_COMPARATOR = new SAMHeaderRecordComparator("PU", "LB", "DT", "SM", "CN", "PL", "DS", "ID");

    static byte[] bytesToCompressedBases(byte[] readBases) {
        int i;
        byte[] compressedBases = new byte[(readBases.length + 1) / 2];
        for (i = 1; i < readBases.length; i += 2) {
            compressedBases[i / 2] = (byte)(SAMUtils.charToCompressedBaseHigh(readBases[i - 1]) | SAMUtils.charToCompressedBaseLow(readBases[i]));
        }
        if (i == readBases.length) {
            compressedBases[i / 2] = SAMUtils.charToCompressedBaseHigh(readBases[i - 1]);
        }
        return compressedBases;
    }

    public static byte[] compressedBasesToBytes(int length, byte[] compressedBases, int compressedOffset) {
        int i;
        byte[] ret = new byte[length];
        for (i = 1; i < length; i += 2) {
            int compressedIndex = i / 2 + compressedOffset;
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[compressedIndex]);
            ret[i] = SAMUtils.compressedBaseToByteLow(compressedBases[compressedIndex]);
        }
        if (i == length) {
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[i / 2 + compressedOffset]);
        }
        return ret;
    }

    private static byte charToCompressedBaseLow(byte base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 71: 
            case 103: {
                return 4;
            }
            case 84: 
            case 116: {
                return 8;
            }
            case 46: 
            case 78: 
            case 110: {
                return 15;
            }
            case 77: 
            case 109: {
                return 3;
            }
            case 82: 
            case 114: {
                return 5;
            }
            case 83: 
            case 115: {
                return 6;
            }
            case 86: 
            case 118: {
                return 7;
            }
            case 87: 
            case 119: {
                return 9;
            }
            case 89: 
            case 121: {
                return 10;
            }
            case 72: 
            case 104: {
                return 11;
            }
            case 75: 
            case 107: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 66: 
            case 98: {
                return 14;
            }
        }
        throw new IllegalArgumentException("Bad base passed to charToCompressedBaseLow: " + Character.toString((char)base) + "(" + base + ")");
    }

    private static byte charToCompressedBaseHigh(byte base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 16;
            }
            case 67: 
            case 99: {
                return 32;
            }
            case 71: 
            case 103: {
                return 64;
            }
            case 84: 
            case 116: {
                return -128;
            }
            case 46: 
            case 78: 
            case 110: {
                return -16;
            }
            case 77: 
            case 109: {
                return 48;
            }
            case 82: 
            case 114: {
                return 80;
            }
            case 83: 
            case 115: {
                return 96;
            }
            case 86: 
            case 118: {
                return 112;
            }
            case 87: 
            case 119: {
                return -112;
            }
            case 89: 
            case 121: {
                return -96;
            }
            case 72: 
            case 104: {
                return -80;
            }
            case 75: 
            case 107: {
                return -64;
            }
            case 68: 
            case 100: {
                return -48;
            }
            case 66: 
            case 98: {
                return -32;
            }
        }
        throw new IllegalArgumentException("Bad base passed to charToCompressedBaseHigh: " + Character.toString((char)base) + "(" + base + ")");
    }

    private static byte compressedBaseToByte(byte base) {
        try {
            return COMPRESSED_LOOKUP_TABLE[base];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Bad base passed to charToCompressedBase: " + Character.toString((char)base) + "(" + base + ")");
        }
    }

    private static byte compressedBaseToByteLow(int base) {
        return SAMUtils.compressedBaseToByte((byte)(base & 0xF));
    }

    private static byte compressedBaseToByteHigh(int base) {
        return SAMUtils.compressedBaseToByte((byte)(base >> 4 & 0xF));
    }

    static void normalizeBases(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = StringUtil.toUpperCase(bases[i]);
            if (bases[i] != 46) continue;
            bases[i] = 78;
        }
    }

    public static String phredToFastq(byte[] data) {
        if (data == null) {
            return null;
        }
        return SAMUtils.phredToFastq(data, 0, data.length);
    }

    public static String phredToFastq(byte[] buffer, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = SAMUtils.phredToFastq(buffer[offset + i] & 0xFF);
        }
        return new String(chars);
    }

    public static char phredToFastq(int phredScore) {
        if (phredScore < 0 || phredScore > 93) {
            throw new IllegalArgumentException("Cannot encode phred score: " + phredScore);
        }
        return (char)(33 + phredScore);
    }

    public static byte[] fastqToPhred(String fastq) {
        if (fastq == null) {
            return null;
        }
        int length = fastq.length();
        byte[] scores = new byte[length];
        for (int i = 0; i < length; ++i) {
            scores[i] = (byte)SAMUtils.fastqToPhred(fastq.charAt(i));
        }
        return scores;
    }

    public static void fastqToPhred(byte[] fastq) {
        for (int i = 0; i < fastq.length; ++i) {
            fastq[i] = (byte)SAMUtils.fastqToPhred((char)(fastq[i] & 0xFF));
        }
    }

    public static int fastqToPhred(char ch) {
        if (ch < '!' || ch > '~') {
            throw new IllegalArgumentException("Invalid fastq character: " + ch);
        }
        return ch - 33;
    }

    @Deprecated
    static int reg2bin(int beg, int end) {
        return GenomicIndexUtil.regionToBin(beg, end);
    }

    public static void processValidationErrors(List<SAMValidationError> validationErrors, long samRecordIndex, ValidationStringency validationStringency) {
        if (validationErrors != null && !validationErrors.isEmpty()) {
            for (SAMValidationError validationError : validationErrors) {
                validationError.setRecordNumber(samRecordIndex);
            }
            if (validationStringency == ValidationStringency.STRICT) {
                throw new SAMFormatException("SAM validation error: " + String.valueOf(validationErrors.get(0)));
            }
            if (validationStringency == ValidationStringency.LENIENT) {
                for (SAMValidationError error : validationErrors) {
                    System.err.println("Ignoring SAM validation error: " + String.valueOf(error));
                }
            }
        }
    }

    public static void processValidationError(SAMValidationError validationError, ValidationStringency validationStringency) {
        if (validationStringency == ValidationStringency.STRICT) {
            throw new SAMFormatException("SAM validation error: " + String.valueOf(validationError));
        }
        if (validationStringency == ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error: " + String.valueOf(validationError));
        }
    }

    public static String calculateReadGroupRecordChecksum(File input, File referenceFasta) {
        MessageDigest digest;
        String ENCODING = "UTF-8";
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new Error("No MD5 algorithm was available in a Java JDK? Unheard-of!");
        }
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).open(input);
        ArrayList<SAMReadGroupRecord> sortedRecords = new ArrayList<SAMReadGroupRecord>(reader.getFileHeader().getReadGroups());
        Collections.sort(sortedRecords, HEADER_RECORD_COMPARATOR);
        for (SAMReadGroupRecord rgRecord : sortedRecords) {
            TreeMap<String, String> sortedAttributes = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : rgRecord.getAttributes()) {
                sortedAttributes.put(entry.getKey(), entry.getValue());
            }
            try {
                for (Map.Entry<String, String> entry : sortedAttributes.entrySet()) {
                    if (entry.getKey().equals("ID")) continue;
                    digest.update(entry.getKey().getBytes("UTF-8"));
                    digest.update(entry.getValue().getBytes("UTF-8"));
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error("No UTF-8!? WTH?");
            }
        }
        StringBuilder hashText = new StringBuilder(new BigInteger(1, digest.digest()).toString(16));
        while (hashText.length() < 32) {
            hashText.insert(0, "0");
        }
        CloserUtil.close(reader);
        return hashText.toString();
    }

    public static void chainSAMProgramRecord(SAMFileHeader header, SAMProgramRecord program) {
        List<SAMProgramRecord> pgs = header.getProgramRecords();
        if (!pgs.isEmpty()) {
            ArrayList<String> referencedIds = new ArrayList<String>();
            for (SAMProgramRecord pg : pgs) {
                if (pg.getPreviousProgramGroupId() == null) continue;
                referencedIds.add(pg.getPreviousProgramGroupId());
            }
            for (SAMProgramRecord pg : pgs) {
                if (pg.getProgramGroupId().equals(program.getProgramGroupId()) || referencedIds.contains(pg.getProgramGroupId())) continue;
                program.setPreviousProgramGroupId(pg.getProgramGroupId());
                break;
            }
        }
    }

    public static void makeReadUnmapped(SAMRecord rec) {
        if (rec.getReadNegativeStrandFlag()) {
            rec.reverseComplement(true);
            rec.setReadNegativeStrandFlag(false);
        }
        rec.setDuplicateReadFlag(false);
        rec.setReferenceIndex(-1);
        rec.setAlignmentStart(0);
        rec.setCigarString("*");
        rec.setMappingQuality(0);
        rec.setInferredInsertSize(0);
        rec.setSecondaryAlignment(false);
        rec.setSupplementaryAlignmentFlag(false);
        rec.setProperPairFlag(false);
        rec.setReadUnmappedFlag(true);
    }

    public static void makeReadUnmappedWithOriginalTags(SAMRecord rec) {
        if (!SAMUtils.hasOriginalMappingInformation(rec)) {
            rec.setAttribute(SAMTag.OP, (Object)rec.getAlignmentStart());
            rec.setAttribute(SAMTag.OC, (Object)rec.getCigarString());
            rec.setAttribute(SAMTag.OF, (Object)rec.getFlags());
            rec.setAttribute(SAMTag.OR, (Object)rec.getReferenceName());
        }
        SAMUtils.makeReadUnmapped(rec);
    }

    public static boolean hasOriginalMappingInformation(SAMRecord rec) {
        return rec.getAttribute(SAMTag.OP) != null || rec.getAttribute(SAMTag.OC) != null || rec.getAttribute(SAMTag.OF) != null || rec.getAttribute(SAMTag.OR) != null;
    }

    public static boolean cigarMapsNoBasesToRef(Cigar cigar) {
        for (CigarElement el : cigar.getCigarElements()) {
            if (!el.getOperator().consumesReadBases() || !el.getOperator().consumesReferenceBases()) continue;
            return false;
        }
        return true;
    }

    public static boolean recordMapsEntirelyBeyondEndOfReference(SAMRecord record) {
        if (record.getHeader() == null) {
            throw new SAMException("A non-null SAMHeader is required to resolve the mapping position: " + record.getReadName());
        }
        return record.getHeader().getSequence(record.getReferenceIndex()).getSequenceLength() < record.getAlignmentStart();
    }

    public static int compareMapqs(int mapq1, int mapq2) {
        if (mapq1 == mapq2) {
            return 0;
        }
        if (mapq1 == 0) {
            return -1;
        }
        if (mapq2 == 0) {
            return 1;
        }
        if (mapq1 == 255) {
            return -1;
        }
        if (mapq2 == 255) {
            return 1;
        }
        return mapq1 - mapq2;
    }

    public static int combineMapqs(int m1, int m22) {
        m1 = m1 == 255 ? 1 : (m1 *= 100);
        m22 = m22 == 255 ? 1 : (m22 *= 100);
        return m1 + m22;
    }

    public static long findVirtualOffsetOfFirstRecordInBam(Path bamFile) {
        long l;
        SeekablePathStream ss = new SeekablePathStream(bamFile);
        try {
            l = BAMFileReader.findVirtualOffsetOfFirstRecord(ss);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((SeekableStream)ss).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeEOFException(ioe);
            }
        }
        ((SeekableStream)ss).close();
        return l;
    }

    public static long findVirtualOffsetOfFirstRecordInBam(File bamFile) {
        try {
            return BAMFileReader.findVirtualOffsetOfFirstRecord(bamFile);
        }
        catch (IOException ioe) {
            throw new RuntimeEOFException(ioe);
        }
    }

    public static long findVirtualOffsetOfFirstRecordInBam(SeekableStream seekableStream) {
        try {
            return BAMFileReader.findVirtualOffsetOfFirstRecord(seekableStream);
        }
        catch (IOException ioe) {
            throw new RuntimeEOFException(ioe);
        }
    }

    public static List<AlignmentBlock> getAlignmentBlocks(Cigar cigar, int alignmentStart, String cigarTypeName) {
        if (cigar == null) {
            return Collections.emptyList();
        }
        ArrayList<AlignmentBlock> alignmentBlocks = new ArrayList<AlignmentBlock>();
        int readBase = 1;
        int refBase = alignmentStart;
        block9: for (CigarElement e : cigar.getCigarElements()) {
            switch (e.getOperator()) {
                case H: {
                    continue block9;
                }
                case P: {
                    continue block9;
                }
                case S: {
                    readBase += e.getLength();
                    continue block9;
                }
                case N: {
                    refBase += e.getLength();
                    continue block9;
                }
                case D: {
                    refBase += e.getLength();
                    continue block9;
                }
                case I: {
                    readBase += e.getLength();
                    continue block9;
                }
                case M: 
                case EQ: 
                case X: {
                    int length = e.getLength();
                    alignmentBlocks.add(new AlignmentBlock(readBase, refBase, length));
                    readBase += length;
                    refBase += length;
                    continue block9;
                }
            }
            throw new IllegalStateException("Case statement didn't deal with " + cigarTypeName + " op: " + String.valueOf((Object)e.getOperator()) + "in CIGAR: " + String.valueOf(cigar));
        }
        return Collections.unmodifiableList(alignmentBlocks);
    }

    public static int getUnclippedStart(int alignmentStart, Cigar cigar) {
        CigarElement cig;
        CigarOperator op;
        int unClippedStart = alignmentStart;
        Iterator<CigarElement> iterator = cigar.getCigarElements().iterator();
        while (iterator.hasNext() && ((op = (cig = iterator.next()).getOperator()) == CigarOperator.SOFT_CLIP || op == CigarOperator.HARD_CLIP)) {
            unClippedStart -= cig.getLength();
        }
        return unClippedStart;
    }

    public static int getUnclippedEnd(int alignmentEnd, Cigar cigar) {
        CigarElement cig;
        CigarOperator op;
        int unClippedEnd = alignmentEnd;
        List<CigarElement> cigs = cigar.getCigarElements();
        for (int i = cigs.size() - 1; i >= 0 && ((op = (cig = cigs.get(i)).getOperator()) == CigarOperator.SOFT_CLIP || op == CigarOperator.HARD_CLIP); --i) {
            unClippedEnd += cig.getLength();
        }
        return unClippedEnd;
    }

    public static String getMateCigarString(SAMRecord rec) {
        return rec.getStringAttribute(SAMTag.MC);
    }

    public static Cigar getMateCigar(SAMRecord rec, boolean withValidation) {
        String mateCigarString = SAMUtils.getMateCigarString(rec);
        Cigar mateCigar = null;
        if (mateCigarString != null) {
            mateCigar = TextCigarCodec.decode(mateCigarString);
            if (withValidation && rec.getValidationStringency() != ValidationStringency.SILENT) {
                List<AlignmentBlock> alignmentBlocks = SAMUtils.getAlignmentBlocks(mateCigar, rec.getMateAlignmentStart(), "mate cigar");
                SAMUtils.processValidationErrors(SAMUtils.validateCigar(rec, mateCigar, rec.getMateReferenceIndex(), alignmentBlocks, -1L, "Mate CIGAR"), -1L, rec.getValidationStringency());
            }
        }
        return mateCigar;
    }

    public static Cigar getMateCigar(SAMRecord rec) {
        return SAMUtils.getMateCigar(rec, false);
    }

    public static int getMateCigarLength(SAMRecord rec) {
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        return mateCigar != null ? mateCigar.numCigarElements() : 0;
    }

    public static int getMateAlignmentEnd(SAMRecord rec) {
        if (rec.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateAlignmentEnd called on an unmapped mate: " + String.valueOf(rec));
        }
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        if (mateCigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found:" + String.valueOf(rec));
        }
        return CoordMath.getEnd(rec.getMateAlignmentStart(), mateCigar.getReferenceLength());
    }

    public static int getMateUnclippedStart(SAMRecord rec) {
        if (rec.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateUnclippedStart called on an unmapped mate: " + String.valueOf(rec));
        }
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        if (mateCigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found: " + String.valueOf(rec));
        }
        return SAMUtils.getUnclippedStart(rec.getMateAlignmentStart(), mateCigar);
    }

    public static int getMateUnclippedEnd(SAMRecord rec) {
        if (rec.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateUnclippedEnd called on an unmapped mate: " + String.valueOf(rec));
        }
        Cigar mateCigar = SAMUtils.getMateCigar(rec);
        if (mateCigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found: " + String.valueOf(rec));
        }
        return SAMUtils.getUnclippedEnd(SAMUtils.getMateAlignmentEnd(rec), mateCigar);
    }

    public static List<AlignmentBlock> getMateAlignmentBlocks(SAMRecord rec) {
        return SAMUtils.getAlignmentBlocks(SAMUtils.getMateCigar(rec), rec.getMateAlignmentStart(), "mate cigar");
    }

    public static List<SAMValidationError> validateCigar(SAMRecord rec, Cigar cigar, Integer referenceIndex, List<AlignmentBlock> alignmentBlocks, long recordNumber, String cigarTypeName) {
        List<SAMValidationError> ret = cigar.isValid(rec.getReadName(), recordNumber);
        if (referenceIndex != -1) {
            SAMFileHeader samHeader = rec.getHeader();
            if (null == samHeader) {
                if (ret == null) {
                    ret = new ArrayList<SAMValidationError>();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.MISSING_HEADER, cigarTypeName + " A non-null SAMHeader is required to validate cigar elements for: ", rec.getReadName(), recordNumber));
            } else {
                SAMSequenceRecord sequence = samHeader.getSequence(referenceIndex);
                int referenceSequenceLength = sequence.getSequenceLength();
                for (AlignmentBlock alignmentBlock : alignmentBlocks) {
                    if (alignmentBlock.getReferenceStart() + alignmentBlock.getLength() - 1 <= referenceSequenceLength) continue;
                    if (ret == null) {
                        ret = new ArrayList<SAMValidationError>();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.CIGAR_MAPS_OFF_REFERENCE, cigarTypeName + " M operator maps off end of reference", rec.getReadName(), recordNumber));
                    break;
                }
            }
        }
        return ret;
    }

    public static List<SAMValidationError> validateMateCigar(SAMRecord rec, long recordNumber) {
        List<SAMValidationError> ret = null;
        if (rec.getValidationStringency() != ValidationStringency.SILENT) {
            if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag()) {
                if (SAMUtils.getMateCigarString(rec) != null) {
                    ret = SAMUtils.validateCigar(rec, SAMUtils.getMateCigar(rec), rec.getMateReferenceIndex(), SAMUtils.getMateAlignmentBlocks(rec), recordNumber, "Mate CIGAR");
                }
            } else if (SAMUtils.getMateCigarString(rec) != null) {
                ret = new ArrayList<SAMValidationError>();
                if (!rec.getReadPairedFlag()) {
                    ret.add(new SAMValidationError(SAMValidationError.Type.MATE_CIGAR_STRING_INVALID_PRESENCE, "Mate CIGAR String (MC Attribute) present for a read that is not paired", rec.getReadName(), recordNumber));
                } else {
                    ret.add(new SAMValidationError(SAMValidationError.Type.MATE_CIGAR_STRING_INVALID_PRESENCE, "Mate CIGAR String (MC Attribute) present for a read whose mate is unmapped", rec.getReadName(), recordNumber));
                }
            }
        }
        return ret;
    }

    public static boolean hasMateCigar(SAMRecord rec) {
        return rec.getReadPairedFlag() && !rec.getMateUnmappedFlag() && null != SAMUtils.getMateCigarString(rec);
    }

    public static String getCanonicalRecordName(SAMRecord record) {
        Object name = record.getStringAttribute(ReservedTagConstants.READ_GROUP_ID);
        name = null == name ? record.getReadName() : (String)name + ":" + record.getReadName();
        return name;
    }

    public static int getNumOverlappingAlignedBasesToClip(SAMRecord rec) {
        if (!rec.getReadPairedFlag() || rec.getReadUnmappedFlag() || rec.getMateUnmappedFlag()) {
            return 0;
        }
        if (rec.getMateAlignmentStart() < rec.getAlignmentStart()) {
            return 0;
        }
        if (rec.getMateAlignmentStart() == rec.getAlignmentStart() && rec.getFirstOfPairFlag()) {
            return 0;
        }
        int numBasesToClip = 0;
        int refStartPos = rec.getMateAlignmentStart();
        Cigar cigar = rec.getCigar();
        int refPos = rec.getAlignmentStart();
        for (CigarElement el : cigar.getCigarElements()) {
            int refBasesLength;
            CigarOperator operator = el.getOperator();
            int n = refBasesLength = operator.consumesReferenceBases() ? el.getLength() : 0;
            if (refStartPos <= refPos + refBasesLength - 1) {
                if (operator == CigarOperator.MATCH_OR_MISMATCH) {
                    numBasesToClip = refStartPos < refPos ? (numBasesToClip += refBasesLength) : (numBasesToClip += refPos + refBasesLength - refStartPos);
                } else if (operator != CigarOperator.SOFT_CLIP && operator != CigarOperator.HARD_CLIP && operator != CigarOperator.PADDING && operator != CigarOperator.SKIPPED_REGION) {
                    numBasesToClip += operator.consumesReadBases() ? el.getLength() : 0;
                }
            }
            refPos += refBasesLength;
        }
        if (numBasesToClip < 0) {
            return 0;
        }
        return numBasesToClip;
    }

    public static SAMRecord clipOverlappingAlignedBases(SAMRecord record, boolean noSideEffects) {
        return SAMUtils.clipOverlappingAlignedBases(record, SAMUtils.getNumOverlappingAlignedBasesToClip(record), noSideEffects);
    }

    public static SAMRecord clipOverlappingAlignedBases(SAMRecord record, int numOverlappingBasesToClip, boolean noSideEffects) {
        if (numOverlappingBasesToClip <= 0 || record.getReadUnmappedFlag() || record.getMateUnmappedFlag()) {
            return record;
        }
        try {
            SAMRecord rec;
            SAMRecord sAMRecord = rec = noSideEffects ? (SAMRecord)record.clone() : record;
            if (rec.getMateAlignmentStart() <= rec.getAlignmentStart()) {
                rec.setReadUnmappedFlag(true);
                return rec;
            }
            int clipFrom = rec.getReadLength() - numOverlappingBasesToClip + 1;
            CigarElement cigarElement = rec.getCigar().getCigarElement(rec.getCigarLength() - 1);
            if (CigarOperator.SOFT_CLIP == cigarElement.getOperator()) {
                clipFrom -= cigarElement.getLength();
            }
            rec.setCigar(new Cigar(CigarUtil.softClipEndOfRead(clipFrom, rec.getCigar().getCigarElements())));
            return rec;
        }
        catch (CloneNotSupportedException e) {
            throw new SAMException(e.getMessage(), e);
        }
    }

    public static boolean isValidUnsignedIntegerAttribute(long value) {
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    public static List<SAMRecord> getOtherCanonicalAlignments(SAMRecord record) {
        if (record == null) {
            throw new IllegalArgumentException("record is null");
        }
        if (record.getHeader() == null) {
            throw new IllegalArgumentException("record.getHeader() is null");
        }
        Object saValue = record.getAttribute(SAMTag.SA);
        if (saValue == null) {
            return Collections.emptyList();
        }
        if (!(saValue instanceof String)) {
            throw new SAMException("Expected a String for attribute 'SA' but got " + String.valueOf(saValue.getClass()) + ". Record: " + String.valueOf(record));
        }
        DefaultSAMRecordFactory samReaderFactory = new DefaultSAMRecordFactory();
        String[] semiColonStrs = SEMICOLON_PAT.split((String)saValue);
        ArrayList<SAMRecord> alignments = new ArrayList<SAMRecord>(semiColonStrs.length);
        int record_flag = record.getFlags();
        record_flag &= ~SAMFlag.PROPER_PAIR.flag;
        record_flag &= ~SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag;
        record_flag &= ~SAMFlag.READ_REVERSE_STRAND.flag;
        for (int i = 0; i < semiColonStrs.length; ++i) {
            int alignStart;
            int tid;
            String semiColonStr = semiColonStrs[i];
            if (semiColonStr.isEmpty()) continue;
            String[] commaStrs = COMMA_PAT.split(semiColonStr);
            if (commaStrs.length != 6) {
                throw new SAMException("Bad 'SA' attribute in " + semiColonStr + ". Record: " + String.valueOf(record));
            }
            SAMRecord otherRec = samReaderFactory.createSAMRecord(record.getHeader());
            otherRec.setReadName(record.getReadName());
            otherRec.setReadBases(record.getReadBases());
            otherRec.setBaseQualities(record.getBaseQualities());
            if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                otherRec.setMateReferenceIndex(record.getMateReferenceIndex());
                otherRec.setMateAlignmentStart(record.getMateAlignmentStart());
            }
            if ((tid = record.getHeader().getSequenceIndex(commaStrs[0])) == -1) {
                throw new SAMException("Unknown contig in " + semiColonStr + ". Record: " + String.valueOf(record));
            }
            otherRec.setReferenceIndex(tid);
            try {
                alignStart = Integer.parseInt(commaStrs[1]);
            }
            catch (NumberFormatException err) {
                throw new SAMException("bad POS in " + semiColonStr + ". Record: " + String.valueOf(record), err);
            }
            otherRec.setAlignmentStart(alignStart);
            if (record.getReadPairedFlag() && !record.getMateUnmappedFlag() && record.getMateReferenceIndex() == tid) {
                otherRec.setInferredInsertSize(record.getMateAlignmentStart() - alignStart);
            }
            int other_flag = record_flag;
            other_flag |= commaStrs[2].equals("+") ? 0 : SAMFlag.READ_REVERSE_STRAND.flag;
            if (!record.getSupplementaryAlignmentFlag() || i != 0) {
                other_flag |= SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag;
            }
            otherRec.setFlags(other_flag);
            otherRec.setCigar(TextCigarCodec.decode(commaStrs[3]));
            try {
                otherRec.setMappingQuality(Integer.parseInt(commaStrs[4]));
            }
            catch (NumberFormatException err) {
                throw new SAMException("bad MAPQ in " + semiColonStr + ". Record: " + String.valueOf(record), err);
            }
            try {
                if (!commaStrs[5].equals("*")) {
                    otherRec.setAttribute(SAMTag.NM, (Object)Integer.parseInt(commaStrs[5]));
                }
            }
            catch (NumberFormatException err) {
                throw new SAMException("bad NM in " + semiColonStr + ". Record: " + String.valueOf(record), err);
            }
            if (otherRec.getReadNegativeStrandFlag() != record.getReadNegativeStrandFlag()) {
                otherRec.reverseComplement(true);
            }
            alignments.add(otherRec);
        }
        return alignments;
    }

    @Deprecated
    public static boolean isReferenceSequenceCompatibleWithBAI(SAMSequenceRecord sequence) {
        return SAMUtils.isReferenceSequenceIncompatibleWithBAI(sequence);
    }

    public static boolean isReferenceSequenceIncompatibleWithBAI(SAMSequenceRecord sequence) {
        return sequence.getSequenceLength() > 0x20000000;
    }

    public static String calculateOATagValue(SAMRecord record) {
        if (record.getReferenceName().contains(",")) {
            throw new SAMException(String.format("Reference name for record %s contains a comma character.", record.getReadName()));
        }
        String oaValue = record.getReadUnmappedFlag() ? String.format(Locale.US, "*,0,%s,*,%s,", new Object[]{record.getReadNegativeStrandFlag() ? Strand.NEGATIVE : Strand.POSITIVE, record.getMappingQuality()}) : String.format(Locale.US, "%s,%s,%s,%s,%s,%s", new Object[]{record.getReferenceName(), record.getAlignmentStart(), record.getReadNegativeStrandFlag() ? Strand.NEGATIVE : Strand.POSITIVE, record.getCigarString(), record.getMappingQuality(), Optional.ofNullable(record.getAttribute(SAMTag.NM)).orElse("")});
        return oaValue;
    }
}

