/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class SBIIndex
implements Serializable {
    @Deprecated
    public static final String FILE_EXTENSION = ".sbi";
    static final byte[] SBI_MAGIC = "SBI\u0001".getBytes();
    private final Header header;
    private final long[] virtualOffsets;

    public SBIIndex(Header header, long[] virtualOffsets) {
        this.header = header;
        this.virtualOffsets = virtualOffsets;
        if (this.virtualOffsets.length == 0) {
            throw new RuntimeException("Invalid SBI format: should contain at least one offset");
        }
    }

    public static SBIIndex load(Path path) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            SBIIndex sBIIndex = SBIIndex.readIndex(in);
            return sBIIndex;
        }
    }

    public static SBIIndex load(InputStream in) {
        return SBIIndex.readIndex(in);
    }

    private static SBIIndex readIndex(InputStream in) {
        BinaryCodec binaryCodec = new BinaryCodec(in);
        Header header = SBIIndex.readHeader(binaryCodec);
        long numOffsetsLong = binaryCodec.readLong();
        if (numOffsetsLong > Integer.MAX_VALUE) {
            throw new RuntimeException(String.format("Cannot read SBI with more than %s offsets.", Integer.MAX_VALUE));
        }
        int numOffsets = (int)numOffsetsLong;
        long[] virtualOffsets = new long[numOffsets];
        long prev = -1L;
        for (int i = 0; i < numOffsets; ++i) {
            long cur = binaryCodec.readLong();
            if (prev > cur) {
                throw new RuntimeException(String.format("Invalid SBI; offsets not in order: %#x > %#x", prev, cur));
            }
            virtualOffsets[i] = cur;
            prev = cur;
        }
        return new SBIIndex(header, virtualOffsets);
    }

    private static Header readHeader(BinaryCodec binaryCodec) {
        byte[] buffer = new byte[SBI_MAGIC.length];
        binaryCodec.readBytes(buffer);
        if (!Arrays.equals(buffer, SBI_MAGIC)) {
            throw new RuntimeException("Invalid file header in SBI: " + new String(buffer) + " (" + Arrays.toString(buffer) + ")");
        }
        long fileLength = binaryCodec.readLong();
        byte[] md5 = new byte[16];
        binaryCodec.readBytes(md5);
        byte[] uuid = new byte[16];
        binaryCodec.readBytes(uuid);
        long totalNumberOfRecords = binaryCodec.readLong();
        long granularity = binaryCodec.readLong();
        return new Header(fileLength, md5, uuid, totalNumberOfRecords, granularity);
    }

    public Header getHeader() {
        return this.header;
    }

    public long getGranularity() {
        return this.header.getGranularity();
    }

    public long[] getVirtualOffsets() {
        return this.virtualOffsets;
    }

    public long size() {
        return this.virtualOffsets.length;
    }

    public long dataFileLength() {
        return this.header.getFileLength();
    }

    public List<Chunk> split(long splitSize) {
        if (splitSize <= 0L) {
            throw new IllegalArgumentException(String.format("Split size must be positive: %s", splitSize));
        }
        long fileSize = this.dataFileLength();
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (long splitStart = 0L; splitStart < fileSize; splitStart += splitSize) {
            Chunk chunk = this.getChunk(splitStart, splitStart + splitSize);
            if (chunk == null) continue;
            chunks.add(chunk);
        }
        return chunks;
    }

    public Chunk getChunk(long splitStart, long splitEnd) {
        long virtualSplitEndAlignment;
        if (splitStart >= splitEnd) {
            throw new IllegalArgumentException(String.format("Split start (%s) must be less than end (%s)", splitStart, splitEnd));
        }
        long lastVirtualOffset = this.virtualOffsets[this.virtualOffsets.length - 1];
        long maxEnd = BlockCompressedFilePointerUtil.getBlockAddress(lastVirtualOffset);
        long actualSplitStart = Math.min(splitStart, maxEnd);
        long actualSplitEnd = Math.min(splitEnd, maxEnd);
        long virtualSplitStart = BlockCompressedFilePointerUtil.makeFilePointer(actualSplitStart);
        long virtualSplitEnd = BlockCompressedFilePointerUtil.makeFilePointer(actualSplitEnd);
        long virtualSplitStartAlignment = this.ceiling(virtualSplitStart);
        if (virtualSplitStartAlignment == (virtualSplitEndAlignment = this.ceiling(virtualSplitEnd))) {
            return null;
        }
        return new Chunk(virtualSplitStartAlignment, virtualSplitEndAlignment);
    }

    private long ceiling(long virtualOffset) {
        int index = Arrays.binarySearch(this.virtualOffsets, virtualOffset);
        if (index < 0 && (index = -index - 1) == this.virtualOffsets.length) {
            long lastVirtualOffset = this.virtualOffsets[this.virtualOffsets.length - 1];
            throw new IllegalArgumentException(String.format("No virtual offset found for virtual file pointer %s, last virtual offset %s", BlockCompressedFilePointerUtil.asString(virtualOffset), BlockCompressedFilePointerUtil.asString(lastVirtualOffset)));
        }
        return this.virtualOffsets[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SBIIndex sbiIndex = (SBIIndex)o;
        return Objects.equals(this.header, sbiIndex.header) && Arrays.equals(this.virtualOffsets, sbiIndex.virtualOffsets);
    }

    public int hashCode() {
        int result = Objects.hash(this.header);
        result = 31 * result + Arrays.hashCode(this.virtualOffsets);
        return result;
    }

    public String toString() {
        String virtualOffsetsString = this.virtualOffsets.length > 30 ? Arrays.toString(Arrays.copyOfRange(this.virtualOffsets, 0, 30)).replace("]", ", ...]") : Arrays.toString(this.virtualOffsets);
        return "SBIIndex{header=" + String.valueOf(this.header) + ", numVirtualOffsets=" + this.virtualOffsets.length + ", virtualOffsets=" + virtualOffsetsString + "}";
    }

    public static class Header
    implements Serializable {
        private final long fileLength;
        private final byte[] md5;
        private final byte[] uuid;
        private final long totalNumberOfRecords;
        private final long granularity;

        public Header(long fileLength, byte[] md5, byte[] uuid, long totalNumberOfRecords, long granularity) {
            this.fileLength = fileLength;
            this.md5 = md5;
            this.uuid = uuid;
            this.totalNumberOfRecords = totalNumberOfRecords;
            this.granularity = granularity;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public byte[] getMd5() {
            return this.md5;
        }

        public byte[] getUuid() {
            return this.uuid;
        }

        public long getTotalNumberOfRecords() {
            return this.totalNumberOfRecords;
        }

        public long getGranularity() {
            return this.granularity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Header header = (Header)o;
            return this.fileLength == header.fileLength && this.totalNumberOfRecords == header.totalNumberOfRecords && this.granularity == header.granularity && Arrays.equals(this.md5, header.md5) && Arrays.equals(this.uuid, header.uuid);
        }

        public int hashCode() {
            int result = Objects.hash(this.fileLength, this.totalNumberOfRecords, this.granularity);
            result = 31 * result + Arrays.hashCode(this.md5);
            result = 31 * result + Arrays.hashCode(this.uuid);
            return result;
        }

        public String toString() {
            return "Header{fileLength=" + this.fileLength + ", md5=" + Arrays.toString(this.md5) + ", uuid=" + Arrays.toString(this.uuid) + ", totalNumberOfRecords=" + this.totalNumberOfRecords + ", granularity=" + this.granularity + "}";
        }
    }
}

