/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.compression.range.RangeDecode;
import htsjdk.samtools.cram.compression.range.RangeEncode;
import htsjdk.samtools.cram.compression.range.RangeParams;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import java.nio.ByteBuffer;

public class RangeExternalCompressor
extends ExternalCompressor {
    private final int formatFlags;
    private final RangeEncode rangeEncode;
    private final RangeDecode rangeDecode;

    public RangeExternalCompressor(RangeEncode rangeEncode, RangeDecode rangeDecode) {
        this(0, rangeEncode, rangeDecode);
    }

    public RangeExternalCompressor(int formatFlags, RangeEncode rangeEncode, RangeDecode rangeDecode) {
        super(BlockCompressionMethod.RANGE);
        this.rangeEncode = rangeEncode;
        this.rangeDecode = rangeDecode;
        this.formatFlags = formatFlags;
    }

    @Override
    public byte[] compress(byte[] data) {
        RangeParams params = new RangeParams(this.formatFlags);
        ByteBuffer buffer = this.rangeEncode.compress(CompressionUtils.wrap(data), params);
        return this.toByteArray(buffer);
    }

    @Override
    public byte[] uncompress(byte[] data) {
        ByteBuffer buf = this.rangeDecode.uncompress(CompressionUtils.wrap(data));
        return this.toByteArray(buf);
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", new Object[]{this.getMethod(), this.formatFlags});
    }

    private byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.limit()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }
}

