/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.fqzcomp;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.fqzcomp.FQZModels;
import htsjdk.samtools.cram.compression.fqzcomp.FQZParam;
import htsjdk.samtools.cram.compression.fqzcomp.FQZParams;
import htsjdk.samtools.cram.compression.fqzcomp.FQZState;
import htsjdk.samtools.cram.compression.range.RangeCoder;
import java.nio.ByteBuffer;

public class FQZCompDecode {
    private static final int NUMBER_OF_SYMBOLS = 256;
    private static int SUPPORTED_FQZCOMP_VERSION = 5;

    public static ByteBuffer uncompress(ByteBuffer inBuffer) {
        int outBufferLength = CompressionUtils.readUint7(inBuffer);
        int version = inBuffer.get() & 0xFF;
        if (version != SUPPORTED_FQZCOMP_VERSION) {
            throw new CRAMException("Invalid FQZComp format version number: " + version);
        }
        FQZParams fqzParams = new FQZParams(inBuffer);
        FQZModels fqzModels = new FQZModels(fqzParams);
        FQZState fqzState = new FQZState();
        RangeCoder rangeCoder = new RangeCoder();
        rangeCoder.rangeDecodeStart(inBuffer);
        ByteBuffer outBuffer = CompressionUtils.allocateByteBuffer(outBufferLength);
        FQZParam fqzParam = null;
        int i = 0;
        int last = 0;
        while (i < outBufferLength) {
            fqzState.resizeArrays(fqzState.getReadOrdinal());
            if (fqzState.getBases() == 0) {
                fqzState.setContext(0);
                FQZCompDecode.decodeFQZNewRecord(inBuffer, rangeCoder, fqzModels, fqzParams, fqzState);
                if (fqzState.getIsDuplicate()) {
                    for (int j = 0; j < fqzState.getRecordLength(); ++j) {
                        outBuffer.put(i + j, outBuffer.get(i + j - fqzState.getRecordLength()));
                    }
                    i += fqzState.getRecordLength();
                    last = 0;
                    fqzState.setBases(0);
                    fqzState.setContext(0);
                    fqzState.setIsDuplicate(false);
                    fqzState.getQualityLengthArray()[fqzState.getReadOrdinal() - 1] = fqzState.getRecordLength();
                    continue;
                }
                fqzState.resizeArrays(fqzState.getReadOrdinal());
                fqzState.getQualityLengthArray()[fqzState.getReadOrdinal() - 1] = fqzState.getRecordLength();
                fqzParam = fqzParams.getFQZParamList().get(fqzState.getSelectorTable());
                last = fqzState.getContext();
            }
            int quality = fqzModels.getQuality()[last].modelDecode(inBuffer, rangeCoder);
            if (fqzParam.isDoQmap()) {
                outBuffer.put(i++, (byte)fqzParam.getQualityMap()[quality]);
            } else {
                outBuffer.put(i++, (byte)quality);
            }
            last = FQZCompDecode.fqzUpdateContext(fqzParam, fqzState, quality);
            fqzState.setContext(last);
        }
        if (fqzParams.getFQZFlags().doReverse()) {
            FQZCompDecode.reverseQualities(outBuffer, outBufferLength, fqzState);
        }
        outBuffer.rewind();
        return outBuffer;
    }

    public static void decodeFQZNewRecord(ByteBuffer inBuffer, RangeCoder rangeCoder, FQZModels model, FQZParams fqzParams, FQZState state) {
        int len;
        if (fqzParams.getMaxSelector() > 0) {
            state.setSelector(model.getSelector().modelDecode(inBuffer, rangeCoder));
        } else {
            state.setSelector(0);
        }
        state.setSelectorTable(fqzParams.getSelectorTable()[state.getSelector()]);
        FQZParam params = fqzParams.getFQZParamList().get(state.getSelectorTable());
        if (params.getFixedLen() >= 0) {
            len = model.getLength()[0].modelDecode(inBuffer, rangeCoder);
            len |= model.getLength()[1].modelDecode(inBuffer, rangeCoder) << 8;
            len |= model.getLength()[2].modelDecode(inBuffer, rangeCoder) << 16;
            len |= model.getLength()[3].modelDecode(inBuffer, rangeCoder) << 24;
            if (params.getFixedLen() > 0) {
                params.setFixedLen(-len);
            }
        } else {
            len = -params.getFixedLen();
        }
        state.setRecordLength(len);
        if (fqzParams.getFQZFlags().doReverse()) {
            state.getReverseArray()[state.getReadOrdinal()] = model.getReverse().modelDecode(inBuffer, rangeCoder) != 0;
        }
        state.setIsDuplicate(false);
        if (params.isDoDedup() && model.getDuplicate().modelDecode(inBuffer, rangeCoder) != 0) {
            state.setIsDuplicate(true);
        }
        state.setBases(len);
        state.setDelta(0);
        state.setQualityContext(0);
        state.setPreviousQuality(0);
        state.setReadOrdinal(state.getReadOrdinal() + 1);
    }

    public static int fqzUpdateContext(FQZParam params, FQZState state, int quality) {
        int last = params.getContext();
        state.setQualityContext((state.getQualityContext() << params.getQualityContextShift()) + params.getQualityContextTable()[quality] >>> 0);
        last += (state.getQualityContext() & (1 << params.getQualityContextBits()) - 1) << params.getQualityContextLocation() >>> 0;
        if (params.isDoPos()) {
            last += params.getPositionContextTable()[Math.min(state.getBases(), 1023)] << params.getPositionContextLocation();
        }
        if (params.isDoDelta()) {
            last += params.getDeltaContextTable()[Math.min(state.getDelta(), 255)] << params.getDeltaContextLocation();
            state.setDelta(state.getDelta() + (state.getPreviousQuality() != quality ? 1 : 0));
            state.setPreviousQuality(quality);
        }
        if (params.isDoSel()) {
            last += state.getSelector() << params.getSelectorContextLocation();
        }
        state.setBases(state.getBases() - 1);
        return last & 0xFFFF;
    }

    public static void reverseQualities(ByteBuffer outBuffer, int outBufferLength, FQZState fqzState) {
        boolean[] toReverse = fqzState.getReverseArray();
        int[] qualityLengths = fqzState.getQualityLengthArray();
        int nRecs = fqzState.getReadOrdinal();
        int rec = 0;
        for (int idx = 0; idx < outBufferLength && rec != nRecs; idx += qualityLengths[rec++]) {
            if (!toReverse[rec]) continue;
            int j = 0;
            for (int k = qualityLengths[rec] - 1; j < k; ++j, --k) {
                byte tmp = outBuffer.get(idx + j);
                outBuffer.put(idx + j, outBuffer.get(idx + k));
                outBuffer.put(idx + k, tmp);
            }
        }
    }
}

