/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.fqzcomp;

import htsjdk.samtools.cram.compression.fqzcomp.FQZUtils;
import java.nio.ByteBuffer;

public class FQZParam {
    private static final int DEDUP_FLAG_MASK = 2;
    private static final int FIXED_LEN_FLAG_MASK = 4;
    private static final int SEL_FLAG_MASK = 8;
    private static final int QMAP_FLAG_MASK = 16;
    private static final int PTAB_FLAG_MASK = 32;
    private static final int DTAB_FLAG_MASK = 64;
    private static final int QTAB_FLAG_MASK = 128;
    private int context;
    private int maxSymbols;
    private int qualityContextBits;
    private int qualityContextShift;
    private int qualityContextLocation;
    private int selectorContextLocation;
    private int positionContextLocation;
    private int deltaContextLocation;
    private int[] qualityMap;
    private int[] qualityContextTable;
    private int[] positionContextTable;
    private int[] deltaContextTable;
    private boolean doDedup;
    private int fixedLen;
    private boolean doSel;
    private boolean doQmap;
    private boolean doPos;
    private boolean doDelta;
    private boolean doQtab;

    public FQZParam(ByteBuffer inBuffer, int numberOfSymbols) {
        int i;
        this.context = inBuffer.get() & 0xFF | (inBuffer.get() & 0xFF) << 8;
        this.cacheParameterFlags(inBuffer.get() & 0xFF);
        this.maxSymbols = inBuffer.get() & 0xFF;
        int x = inBuffer.get() & 0xFF;
        this.qualityContextBits = x >> 4;
        this.qualityContextShift = x & 0xF;
        int y = inBuffer.get() & 0xFF;
        this.qualityContextLocation = y >> 4;
        this.selectorContextLocation = y & 0xF;
        int z = inBuffer.get() & 0xFF;
        this.positionContextLocation = z >> 4;
        this.deltaContextLocation = z & 0xF;
        this.qualityMap = new int[numberOfSymbols];
        if (this.isDoQmap()) {
            for (i = 0; i < this.getMaxSymbols(); ++i) {
                this.qualityMap[i] = inBuffer.get() & 0xFF;
            }
        } else {
            for (i = 0; i < numberOfSymbols; ++i) {
                this.qualityMap[i] = i;
            }
        }
        this.qualityContextTable = new int[1024];
        if (this.getQualityContextBits() > 0 && this.isDoQtab()) {
            FQZUtils.readArray(inBuffer, this.qualityContextTable, numberOfSymbols);
        } else {
            for (i = 0; i < numberOfSymbols; ++i) {
                this.qualityContextTable[i] = i;
            }
        }
        if (this.isDoPos()) {
            this.positionContextTable = new int[1024];
            FQZUtils.readArray(inBuffer, this.positionContextTable, 1024);
        }
        if (this.isDoDelta()) {
            this.deltaContextTable = new int[numberOfSymbols];
            FQZUtils.readArray(inBuffer, this.deltaContextTable, numberOfSymbols);
        }
    }

    public int getContext() {
        return this.context;
    }

    public boolean isDoDedup() {
        return this.doDedup;
    }

    public int getFixedLen() {
        return this.fixedLen;
    }

    public boolean isDoSel() {
        return this.doSel;
    }

    public boolean isDoQmap() {
        return this.doQmap;
    }

    public boolean isDoPos() {
        return this.doPos;
    }

    public boolean isDoDelta() {
        return this.doDelta;
    }

    public boolean isDoQtab() {
        return this.doQtab;
    }

    public int getMaxSymbols() {
        return this.maxSymbols;
    }

    public int getQualityContextBits() {
        return this.qualityContextBits;
    }

    public int getQualityContextShift() {
        return this.qualityContextShift;
    }

    public int getQualityContextLocation() {
        return this.qualityContextLocation;
    }

    public int getSelectorContextLocation() {
        return this.selectorContextLocation;
    }

    public int getPositionContextLocation() {
        return this.positionContextLocation;
    }

    public int getDeltaContextLocation() {
        return this.deltaContextLocation;
    }

    public int[] getQualityMap() {
        return this.qualityMap;
    }

    public int[] getQualityContextTable() {
        return this.qualityContextTable;
    }

    public int[] getPositionContextTable() {
        return this.positionContextTable;
    }

    public int[] getDeltaContextTable() {
        return this.deltaContextTable;
    }

    public void setFixedLen(int fixedLen) {
        this.fixedLen = fixedLen;
    }

    private void cacheParameterFlags(int parameterFlags) {
        this.doDedup = (parameterFlags & 2) != 0;
        this.setFixedLen(parameterFlags & 4);
        this.doSel = (parameterFlags & 8) != 0;
        this.doQmap = (parameterFlags & 0x10) != 0;
        this.doPos = (parameterFlags & 0x20) != 0;
        this.doDelta = (parameterFlags & 0x40) != 0;
        this.doQtab = (parameterFlags & 0x80) != 0;
    }
}

