/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.range;

import htsjdk.samtools.cram.compression.range.RangeCoder;
import java.nio.ByteBuffer;

public class ByteModel {
    public int totalFrequency;
    public final int maxSymbol;
    public final int[] symbols;
    public final int[] frequencies;

    public ByteModel(int numSymbols) {
        this.totalFrequency = numSymbols;
        this.maxSymbol = numSymbols - 1;
        this.frequencies = new int[this.maxSymbol + 1];
        this.symbols = new int[this.maxSymbol + 1];
        for (int i = 0; i <= this.maxSymbol; ++i) {
            this.symbols[i] = i;
            this.frequencies[i] = 1;
        }
    }

    public int modelDecode(ByteBuffer inBuffer, RangeCoder rangeCoder) {
        int freq = rangeCoder.rangeGetFrequency(this.totalFrequency);
        int cumulativeFrequency = 0;
        int x = 0;
        while (cumulativeFrequency + this.frequencies[x] <= freq) {
            cumulativeFrequency += this.frequencies[x++];
        }
        rangeCoder.rangeDecode(inBuffer, cumulativeFrequency, this.frequencies[x]);
        int n = x;
        this.frequencies[n] = this.frequencies[n] + 16;
        this.totalFrequency += 16;
        if (this.totalFrequency > 65519) {
            this.modelRenormalize();
        }
        int symbol = this.symbols[x];
        if (x > 0 && this.frequencies[x] > this.frequencies[x - 1]) {
            int tmp = this.frequencies[x];
            this.frequencies[x] = this.frequencies[x - 1];
            this.frequencies[x - 1] = tmp;
            tmp = this.symbols[x];
            this.symbols[x] = this.symbols[x - 1];
            this.symbols[x - 1] = tmp;
        }
        return symbol;
    }

    public void modelRenormalize() {
        this.totalFrequency = 0;
        for (int i = 0; i <= this.maxSymbol; ++i) {
            int n = i;
            this.frequencies[n] = this.frequencies[n] - Math.floorDiv(this.frequencies[i], 2);
            this.totalFrequency += this.frequencies[i];
        }
    }

    public void modelEncode(ByteBuffer outBuffer, RangeCoder rangeCoder, int symbol) {
        int cumulativeFrequency = 0;
        int i = 0;
        while (this.symbols[i] != symbol) {
            cumulativeFrequency += this.frequencies[i];
            ++i;
        }
        rangeCoder.rangeEncode(outBuffer, cumulativeFrequency, this.frequencies[i], this.totalFrequency);
        int n = i;
        this.frequencies[n] = this.frequencies[n] + 16;
        this.totalFrequency += 16;
        if (this.totalFrequency > 65519) {
            this.modelRenormalize();
        }
        if (i > 0 && this.frequencies[i] > this.frequencies[i - 1]) {
            int tmp = this.frequencies[i];
            this.frequencies[i] = this.frequencies[i - 1];
            this.frequencies[i - 1] = tmp;
            tmp = this.symbols[i];
            this.symbols[i] = this.symbols[i - 1];
            this.symbols[i - 1] = tmp;
        }
    }
}

