/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.range;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.BZIP2ExternalCompressor;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.range.ByteModel;
import htsjdk.samtools.cram.compression.range.RangeCoder;
import htsjdk.samtools.cram.compression.range.RangeParams;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class RangeDecode {
    private static final ByteBuffer EMPTY_BUFFER = CompressionUtils.allocateByteBuffer(0);

    public ByteBuffer uncompress(ByteBuffer inBuffer) {
        return this.uncompress(inBuffer, 0);
    }

    private ByteBuffer uncompress(ByteBuffer inBuffer, int outSize) {
        ByteBuffer outBuffer;
        int uncompressedSize;
        inBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (inBuffer.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        int formatFlags = inBuffer.get() & 0xFF;
        RangeParams rangeParams = new RangeParams(formatFlags);
        int n = uncompressedSize = rangeParams.isNosz() ? outSize : CompressionUtils.readUint7(inBuffer);
        if (rangeParams.isStripe()) {
            return this.decodeStripe(inBuffer, uncompressedSize);
        }
        int packDataLength = 0;
        int numSymbols = 0;
        byte[] packMappingTable = null;
        if (rangeParams.isPack()) {
            packDataLength = uncompressedSize;
            numSymbols = inBuffer.get() & 0xFF;
            if (numSymbols <= 16 && numSymbols != 0) {
                packMappingTable = new byte[numSymbols];
                for (int i = 0; i < numSymbols; ++i) {
                    packMappingTable[i] = inBuffer.get();
                }
                uncompressedSize = CompressionUtils.readUint7(inBuffer);
            } else {
                throw new CRAMException("Bit Packing is not permitted when number of distinct symbols is greater than 16 or equal to 0. Number of distinct symbols: " + numSymbols);
            }
        }
        if (rangeParams.isCAT()) {
            outBuffer = CompressionUtils.slice(inBuffer);
            outBuffer.limit(uncompressedSize);
            inBuffer.position(inBuffer.position() + uncompressedSize);
        } else if (rangeParams.isExternalCompression()) {
            byte[] extCompressedBytes = new byte[inBuffer.remaining()];
            int extCompressedBytesIdx = 0;
            int start = inBuffer.position();
            int end = inBuffer.limit();
            for (int i = start; i < end; ++i) {
                extCompressedBytes[extCompressedBytesIdx] = inBuffer.get();
                ++extCompressedBytesIdx;
            }
            outBuffer = this.uncompressEXT(extCompressedBytes);
        } else if (rangeParams.isRLE()) {
            outBuffer = CompressionUtils.allocateByteBuffer(uncompressedSize);
            switch (rangeParams.getOrder()) {
                case ZERO: {
                    this.uncompressRLEOrder0(inBuffer, outBuffer, uncompressedSize);
                    break;
                }
                case ONE: {
                    this.uncompressRLEOrder1(inBuffer, outBuffer, uncompressedSize);
                }
            }
        } else {
            outBuffer = CompressionUtils.allocateByteBuffer(uncompressedSize);
            switch (rangeParams.getOrder()) {
                case ZERO: {
                    this.uncompressOrder0(inBuffer, outBuffer, uncompressedSize);
                    break;
                }
                case ONE: {
                    this.uncompressOrder1(inBuffer, outBuffer, uncompressedSize);
                }
            }
        }
        if (rangeParams.isPack()) {
            outBuffer = CompressionUtils.decodePack(outBuffer, packMappingTable, numSymbols, packDataLength);
        }
        outBuffer.rewind();
        return outBuffer;
    }

    private void uncompressOrder0(ByteBuffer inBuffer, ByteBuffer outBuffer, int outSize) {
        int maxSymbols = inBuffer.get() & 0xFF;
        maxSymbols = maxSymbols == 0 ? 256 : maxSymbols;
        ByteModel byteModel = new ByteModel(maxSymbols);
        RangeCoder rangeCoder = new RangeCoder();
        rangeCoder.rangeDecodeStart(inBuffer);
        for (int i = 0; i < outSize; ++i) {
            outBuffer.put(i, (byte)byteModel.modelDecode(inBuffer, rangeCoder));
        }
    }

    private void uncompressOrder1(ByteBuffer inBuffer, ByteBuffer outBuffer, int outSize) {
        int maxSymbols = inBuffer.get() & 0xFF;
        maxSymbols = maxSymbols == 0 ? 256 : maxSymbols;
        ArrayList<ByteModel> byteModelList = new ArrayList<ByteModel>(maxSymbols);
        for (int i = 0; i < maxSymbols; ++i) {
            byteModelList.add(new ByteModel(maxSymbols));
        }
        RangeCoder rangeCoder = new RangeCoder();
        rangeCoder.rangeDecodeStart(inBuffer);
        int last = 0;
        for (int i = 0; i < outSize; ++i) {
            last = ((ByteModel)byteModelList.get(last)).modelDecode(inBuffer, rangeCoder);
            outBuffer.put(i, (byte)last);
        }
    }

    private void uncompressRLEOrder0(ByteBuffer inBuffer, ByteBuffer outBuffer, int outSize) {
        int run;
        int maxSymbols = inBuffer.get() & 0xFF;
        maxSymbols = maxSymbols == 0 ? 256 : maxSymbols;
        ByteModel modelLit = new ByteModel(maxSymbols);
        ArrayList<ByteModel> byteModelRunsList = new ArrayList<ByteModel>(258);
        for (int i = 0; i <= 257; ++i) {
            byteModelRunsList.add(i, new ByteModel(4));
        }
        RangeCoder rangeCoder = new RangeCoder();
        rangeCoder.rangeDecodeStart(inBuffer);
        for (int i = 0; i < outSize; i += run + 1) {
            int part;
            outBuffer.put(i, (byte)modelLit.modelDecode(inBuffer, rangeCoder));
            int last = outBuffer.get(i) & 0xFF;
            run = part = ((ByteModel)byteModelRunsList.get(last)).modelDecode(inBuffer, rangeCoder);
            int rctx = 256;
            while (part == 3) {
                part = ((ByteModel)byteModelRunsList.get(rctx)).modelDecode(inBuffer, rangeCoder);
                rctx = 257;
                run += part;
            }
            for (int j = 1; j <= run; ++j) {
                outBuffer.put(i + j, (byte)last);
            }
        }
    }

    private void uncompressRLEOrder1(ByteBuffer inBuffer, ByteBuffer outBuffer, int outSize) {
        int run;
        int maxSymbols = inBuffer.get() & 0xFF;
        maxSymbols = maxSymbols == 0 ? 256 : maxSymbols;
        ArrayList<ByteModel> byteModelLitList = new ArrayList<ByteModel>(maxSymbols);
        for (int i = 0; i < maxSymbols; ++i) {
            byteModelLitList.add(i, new ByteModel(maxSymbols));
        }
        ArrayList<ByteModel> byteModelRunsList = new ArrayList<ByteModel>(258);
        for (int i = 0; i <= 257; ++i) {
            byteModelRunsList.add(i, new ByteModel(4));
        }
        RangeCoder rangeCoder = new RangeCoder();
        rangeCoder.rangeDecodeStart(inBuffer);
        int last = 0;
        for (int i = 0; i < outSize; i += run + 1) {
            int part;
            outBuffer.put(i, (byte)((ByteModel)byteModelLitList.get(last)).modelDecode(inBuffer, rangeCoder));
            last = outBuffer.get(i) & 0xFF;
            run = part = ((ByteModel)byteModelRunsList.get(last)).modelDecode(inBuffer, rangeCoder);
            int rctx = 256;
            while (part == 3) {
                part = ((ByteModel)byteModelRunsList.get(rctx)).modelDecode(inBuffer, rangeCoder);
                rctx = 257;
                run += part;
            }
            for (int j = 1; j <= run; ++j) {
                outBuffer.put(i + j, (byte)last);
            }
        }
    }

    private ByteBuffer uncompressEXT(byte[] extCompressedBytes) {
        BZIP2ExternalCompressor compressor = new BZIP2ExternalCompressor();
        byte[] extUncompressedBytes = compressor.uncompress(extCompressedBytes);
        return CompressionUtils.wrap(extUncompressedBytes);
    }

    private ByteBuffer decodeStripe(ByteBuffer inBuffer, int outSize) {
        int numInterleaveStreams = inBuffer.get() & 0xFF;
        for (int j = 0; j < numInterleaveStreams; ++j) {
            CompressionUtils.readUint7(inBuffer);
        }
        int[] uncompressedLengths = new int[numInterleaveStreams];
        ByteBuffer[] transposedData = new ByteBuffer[numInterleaveStreams];
        for (int j = 0; j < numInterleaveStreams; ++j) {
            uncompressedLengths[j] = (int)Math.floor((double)outSize / (double)numInterleaveStreams);
            if (outSize % numInterleaveStreams > j) {
                int n = j;
                uncompressedLengths[n] = uncompressedLengths[n] + 1;
            }
            transposedData[j] = this.uncompress(inBuffer, uncompressedLengths[j]);
        }
        ByteBuffer outBuffer = CompressionUtils.allocateByteBuffer(outSize);
        for (int j = 0; j < numInterleaveStreams; ++j) {
            for (int i = 0; i < uncompressedLengths[j]; ++i) {
                outBuffer.put(i * numInterleaveStreams + j, transposedData[j].get(i));
            }
        }
        return outBuffer;
    }
}

