/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans.rans4x8;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.rans.ArithmeticDecoder;
import htsjdk.samtools.cram.compression.rans.RANSDecode;
import htsjdk.samtools.cram.compression.rans.RANSDecodingSymbol;
import htsjdk.samtools.cram.compression.rans.RANSParams;
import htsjdk.samtools.cram.compression.rans.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class RANS4x8Decode
extends RANSDecode {
    private static final int RAW_BYTE_LENGTH = 4;
    private static final ByteBuffer EMPTY_BUFFER = CompressionUtils.allocateByteBuffer(0);

    @Override
    public ByteBuffer uncompress(ByteBuffer inBuffer) {
        if (inBuffer.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        inBuffer.order(ByteOrder.LITTLE_ENDIAN);
        RANSParams.ORDER order = RANSParams.ORDER.fromInt(inBuffer.get());
        int inSize = inBuffer.getInt();
        if (inSize != inBuffer.remaining() - 4) {
            throw new CRAMException("Invalid input length detected in a CRAM rans 4x8 input stream.");
        }
        int outSize = inBuffer.getInt();
        ByteBuffer outBuffer = CompressionUtils.allocateByteBuffer(outSize);
        this.initializeRANSDecoder();
        switch (order) {
            case ZERO: {
                this.uncompressOrder0Way4(inBuffer, outBuffer);
                return outBuffer;
            }
            case ONE: {
                this.uncompressOrder1Way4(inBuffer, outBuffer);
                return outBuffer;
            }
        }
        throw new CRAMException("Unknown rANS order: " + String.valueOf((Object)order));
    }

    private void uncompressOrder0Way4(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        this.readStatsOrder0(inBuffer);
        long rans0 = inBuffer.getInt();
        long rans1 = inBuffer.getInt();
        long rans2 = inBuffer.getInt();
        long rans3 = inBuffer.getInt();
        int out_sz = outBuffer.remaining();
        int out_end = out_sz & 0xFFFFFFFC;
        ArithmeticDecoder D = this.getD()[0];
        RANSDecodingSymbol[] syms = this.getDecodingSymbols()[0];
        for (int i = 0; i < out_end; i += 4) {
            byte c0 = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans0, 12)];
            byte c1 = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans1, 12)];
            byte c2 = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans2, 12)];
            byte c3 = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans3, 12)];
            outBuffer.put(i, c0);
            outBuffer.put(i + 1, c1);
            outBuffer.put(i + 2, c2);
            outBuffer.put(i + 3, c3);
            rans0 = syms[0xFF & c0].advanceSymbolStep(rans0, 12);
            rans1 = syms[0xFF & c1].advanceSymbolStep(rans1, 12);
            rans2 = syms[0xFF & c2].advanceSymbolStep(rans2, 12);
            rans3 = syms[0xFF & c3].advanceSymbolStep(rans3, 12);
            rans0 = Utils.RANSDecodeRenormalize4x8(rans0, inBuffer);
            rans1 = Utils.RANSDecodeRenormalize4x8(rans1, inBuffer);
            rans2 = Utils.RANSDecodeRenormalize4x8(rans2, inBuffer);
            rans3 = Utils.RANSDecodeRenormalize4x8(rans3, inBuffer);
        }
        outBuffer.position(out_end);
        switch (out_sz & 3) {
            case 0: {
                break;
            }
            case 1: {
                byte c = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans0, 12)];
                syms[0xFF & c].advanceSymbol4x8(rans0, inBuffer, 12);
                outBuffer.put(c);
                break;
            }
            case 2: {
                byte c = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans0, 12)];
                syms[0xFF & c].advanceSymbol4x8(rans0, inBuffer, 12);
                outBuffer.put(c);
                c = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans1, 12)];
                syms[0xFF & c].advanceSymbol4x8(rans1, inBuffer, 12);
                outBuffer.put(c);
                break;
            }
            case 3: {
                byte c = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans0, 12)];
                syms[0xFF & c].advanceSymbol4x8(rans0, inBuffer, 12);
                outBuffer.put(c);
                c = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans1, 12)];
                syms[0xFF & c].advanceSymbol4x8(rans1, inBuffer, 12);
                outBuffer.put(c);
                c = D.reverseLookup[Utils.RANSGetCumulativeFrequency(rans2, 12)];
                syms[0xFF & c].advanceSymbol4x8(rans2, inBuffer, 12);
                outBuffer.put(c);
            }
        }
        outBuffer.rewind();
    }

    private void uncompressOrder1Way4(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        this.readStatsOrder1(inBuffer);
        int out_sz = outBuffer.remaining();
        long rans0 = inBuffer.getInt();
        long rans1 = inBuffer.getInt();
        long rans2 = inBuffer.getInt();
        long rans7 = inBuffer.getInt();
        int isz4 = out_sz >> 2;
        int i0 = 0;
        int i1 = isz4;
        int i2 = 2 * isz4;
        int i7 = 3 * isz4;
        int l0 = 0;
        int l1 = 0;
        int l2 = 0;
        int l7 = 0;
        ArithmeticDecoder[] D = this.getD();
        RANSDecodingSymbol[][] syms = this.getDecodingSymbols();
        while (i0 < isz4) {
            int c0 = D[0xFF & l0].reverseLookup[Utils.RANSGetCumulativeFrequency(rans0, 12)];
            int c1 = D[0xFF & l1].reverseLookup[Utils.RANSGetCumulativeFrequency(rans1, 12)];
            int c2 = D[0xFF & l2].reverseLookup[Utils.RANSGetCumulativeFrequency(rans2, 12)];
            int c7 = D[0xFF & l7].reverseLookup[Utils.RANSGetCumulativeFrequency(rans7, 12)];
            outBuffer.put(i0, (byte)c0);
            outBuffer.put(i1, (byte)c1);
            outBuffer.put(i2, (byte)c2);
            outBuffer.put(i7, (byte)c7);
            rans0 = syms[0xFF & l0][0xFF & c0].advanceSymbolStep(rans0, 12);
            rans1 = syms[0xFF & l1][0xFF & c1].advanceSymbolStep(rans1, 12);
            rans2 = syms[0xFF & l2][0xFF & c2].advanceSymbolStep(rans2, 12);
            rans7 = syms[0xFF & l7][0xFF & c7].advanceSymbolStep(rans7, 12);
            rans0 = Utils.RANSDecodeRenormalize4x8(rans0, inBuffer);
            rans1 = Utils.RANSDecodeRenormalize4x8(rans1, inBuffer);
            rans2 = Utils.RANSDecodeRenormalize4x8(rans2, inBuffer);
            rans7 = Utils.RANSDecodeRenormalize4x8(rans7, inBuffer);
            l0 = c0;
            l1 = c1;
            l2 = c2;
            l7 = c7;
            ++i0;
            ++i1;
            ++i2;
            ++i7;
        }
        while (i7 < out_sz) {
            int c7 = D[0xFF & l7].reverseLookup[Utils.RANSGetCumulativeFrequency(rans7, 12)];
            outBuffer.put(i7, (byte)c7);
            rans7 = syms[0xFF & l7][0xFF & c7].advanceSymbol4x8(rans7, inBuffer, 12);
            l7 = c7;
            ++i7;
        }
    }

    private void readStatsOrder0(ByteBuffer cp) {
        ArithmeticDecoder decoder = this.getD()[0];
        RANSDecodingSymbol[] decodingSymbols = this.getDecodingSymbols()[0];
        int rle = 0;
        int cumulativeFrequency = 0;
        int symbol = cp.get() & 0xFF;
        do {
            if ((decoder.frequencies[symbol] = cp.get() & 0xFF) >= 128) {
                int n = symbol;
                decoder.frequencies[n] = decoder.frequencies[n] & 0xFFFFFF7F;
                decoder.frequencies[symbol] = (decoder.frequencies[symbol] & 0x7F) << 8 | cp.get() & 0xFF;
            }
            decodingSymbols[symbol].set(cumulativeFrequency, decoder.frequencies[symbol]);
            Arrays.fill(decoder.reverseLookup, cumulativeFrequency, cumulativeFrequency + decoder.frequencies[symbol], (byte)symbol);
            cumulativeFrequency += decoder.frequencies[symbol];
            if (rle == 0 && symbol + 1 == (0xFF & cp.get(cp.position()))) {
                symbol = cp.get() & 0xFF;
                rle = cp.get() & 0xFF;
                continue;
            }
            if (rle != 0) {
                --rle;
                ++symbol;
                continue;
            }
            symbol = cp.get() & 0xFF;
        } while (symbol != 0);
        assert (cumulativeFrequency <= 4096);
    }

    private void readStatsOrder1(ByteBuffer cp) {
        ArithmeticDecoder[] D = this.getD();
        RANSDecodingSymbol[][] decodingSymbols = this.getDecodingSymbols();
        int rle_i = 0;
        int i = 0xFF & cp.get();
        do {
            int rle_j = 0;
            int cumulativeFrequency = 0;
            int j = 0xFF & cp.get();
            do {
                if ((D[i].frequencies[j] = 0xFF & cp.get()) >= 128) {
                    int n = j;
                    D[i].frequencies[n] = D[i].frequencies[n] & 0xFFFFFF7F;
                    D[i].frequencies[j] = (D[i].frequencies[j] & 0x7F) << 8 | 0xFF & cp.get();
                }
                if (D[i].frequencies[j] == 0) {
                    D[i].frequencies[j] = 4096;
                }
                decodingSymbols[i][j].set(cumulativeFrequency, D[i].frequencies[j]);
                Arrays.fill(D[i].reverseLookup, cumulativeFrequency, cumulativeFrequency + D[i].frequencies[j], (byte)j);
                assert ((cumulativeFrequency += D[i].frequencies[j]) <= 4096);
                if (rle_j == 0 && j + 1 == (0xFF & cp.get(cp.position()))) {
                    j = 0xFF & cp.get();
                    rle_j = 0xFF & cp.get();
                    continue;
                }
                if (rle_j != 0) {
                    --rle_j;
                    ++j;
                    continue;
                }
                j = 0xFF & cp.get();
            } while (j != 0);
            if (rle_i == 0 && i + 1 == (0xFF & cp.get(cp.position()))) {
                i = 0xFF & cp.get();
                rle_i = 0xFF & cp.get();
                continue;
            }
            if (rle_i != 0) {
                --rle_i;
                ++i;
                continue;
            }
            i = 0xFF & cp.get();
        } while (i != 0);
    }
}

