/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans.ransnx16;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.rans.RANSEncode;
import htsjdk.samtools.cram.compression.rans.RANSEncodingSymbol;
import htsjdk.samtools.cram.compression.rans.RANSParams;
import htsjdk.samtools.cram.compression.rans.Utils;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Params;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RANSNx16Encode
extends RANSEncode<RANSNx16Params> {
    private static final ByteBuffer EMPTY_BUFFER = CompressionUtils.allocateByteBuffer(0);

    @Override
    public ByteBuffer compress(ByteBuffer inBuffer, RANSNx16Params ransNx16Params) {
        if (inBuffer.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        ByteBuffer outBuffer = CompressionUtils.allocateOutputBuffer(inBuffer.remaining());
        int formatFlags = ransNx16Params.getFormatFlags();
        outBuffer.put((byte)formatFlags);
        if (!ransNx16Params.isNosz()) {
            CompressionUtils.writeUint7(inBuffer.remaining(), outBuffer);
        }
        ByteBuffer inputBuffer = inBuffer;
        if (ransNx16Params.isStripe()) {
            throw new CRAMException("RANSNx16 Encoding with Stripe Flag is not implemented.");
        }
        if (ransNx16Params.isPack()) {
            int[] frequencyTable = new int[256];
            int inSize = inputBuffer.remaining();
            for (int i = 0; i < inSize; ++i) {
                int n = inputBuffer.get(i) & 0xFF;
                frequencyTable[n] = frequencyTable[n] + 1;
            }
            int numSymbols = 0;
            int[] packMappingTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                if (frequencyTable[i] <= 0) continue;
                packMappingTable[i] = numSymbols++;
            }
            if (numSymbols != 0 && numSymbols <= 16) {
                inputBuffer = CompressionUtils.encodePack(inputBuffer, outBuffer, frequencyTable, packMappingTable, numSymbols);
            } else {
                outBuffer.put(0, (byte)(outBuffer.get(0) & 0xFFFFFF7F));
            }
        }
        if (ransNx16Params.isRLE()) {
            inputBuffer = this.encodeRLE(inputBuffer, outBuffer, ransNx16Params);
        }
        if (ransNx16Params.isCAT()) {
            outBuffer.put(inputBuffer);
            outBuffer.limit(outBuffer.position());
            outBuffer.rewind();
            return outBuffer;
        }
        if (inputBuffer.remaining() < ransNx16Params.getNumInterleavedRANSStates() && ransNx16Params.getOrder() == RANSParams.ORDER.ONE) {
            outBuffer.put(0, (byte)(outBuffer.get(0) & 0xFFFFFFFE));
            if (inputBuffer.remaining() == 0) {
                outBuffer.limit(outBuffer.position());
                outBuffer.rewind();
                return outBuffer;
            }
            this.compressOrder0WayN(inputBuffer, new RANSNx16Params(outBuffer.get(0)), outBuffer);
            return outBuffer;
        }
        switch (ransNx16Params.getOrder()) {
            case ZERO: {
                this.compressOrder0WayN(inputBuffer, ransNx16Params, outBuffer);
                return outBuffer;
            }
            case ONE: {
                this.compressOrder1WayN(inputBuffer, ransNx16Params, outBuffer);
                return outBuffer;
            }
        }
        throw new CRAMException("Unknown rANS order: " + String.valueOf((Object)ransNx16Params.getOrder()));
    }

    private void compressOrder0WayN(ByteBuffer inBuffer, RANSNx16Params ransNx16Params, ByteBuffer outBuffer) {
        int i;
        this.initializeRANSEncoder();
        int inSize = inBuffer.remaining();
        int bitSize = (int)Math.ceil(Math.log(inSize) / Math.log(2.0));
        if (bitSize > 12) {
            bitSize = 12;
        }
        int prefix_size = outBuffer.position();
        int[] F = RANSNx16Encode.buildFrequenciesOrder0(inBuffer);
        ByteBuffer cp = CompressionUtils.slice(outBuffer);
        Utils.normaliseFrequenciesOrder0(F, bitSize);
        int frequencyTableSize = RANSNx16Encode.writeFrequenciesOrder0(cp, F);
        if (bitSize != 12) {
            Utils.normaliseFrequenciesOrder0Shift(F, 12);
        }
        this.buildSymsOrder0(F);
        inBuffer.rewind();
        int Nway = ransNx16Params.getNumInterleavedRANSStates();
        int inputSize = inBuffer.remaining();
        int interleaveSize = Nway == 4 ? inputSize >> 2 : inputSize >> 5;
        int remainingSize = inputSize - interleaveSize * Nway;
        int reverseIndex = 1;
        long[] rans = new long[Nway];
        for (int r = 0; r < Nway; ++r) {
            rans[r] = 32768L;
        }
        ByteBuffer ptr = CompressionUtils.slice(cp);
        RANSEncodingSymbol[] ransEncodingSymbols = this.getEncodingSymbols()[0];
        while (remainingSize > 0) {
            int remainingSymbol = 0xFF & inBuffer.get(inputSize - reverseIndex);
            rans[remainingSize - 1] = ransEncodingSymbols[remainingSymbol].putSymbolNx16(rans[remainingSize - 1], ptr);
            --remainingSize;
            ++reverseIndex;
        }
        byte[] symbol = new byte[Nway];
        for (i = interleaveSize * Nway; i > 0; i -= Nway) {
            for (int r = Nway - 1; r >= 0; --r) {
                symbol[r] = inBuffer.get(i - (Nway - r));
                rans[r] = ransEncodingSymbols[0xFF & symbol[r]].putSymbolNx16(rans[r], ptr);
            }
        }
        ptr.order(ByteOrder.BIG_ENDIAN);
        for (i = Nway - 1; i >= 0; --i) {
            ptr.putInt((int)rans[i]);
        }
        ptr.position();
        ptr.flip();
        int compressedDataSize = ptr.limit();
        Utils.reverse(ptr);
        inBuffer.position(inBuffer.limit());
        outBuffer.rewind();
        outBuffer.limit(prefix_size + frequencyTableSize + compressedDataSize);
    }

    private void compressOrder1WayN(ByteBuffer inBuffer, RANSNx16Params ransNx16Params, ByteBuffer outBuffer) {
        int r;
        int[][] frequencies = RANSNx16Encode.buildFrequenciesOrder1(inBuffer, ransNx16Params.getNumInterleavedRANSStates());
        Utils.normaliseFrequenciesOrder1(frequencies, 12);
        int prefix_size = outBuffer.position();
        ByteBuffer frequencyTable = CompressionUtils.allocateOutputBuffer(1);
        ByteBuffer compressedFrequencyTable = CompressionUtils.allocateOutputBuffer(1);
        int uncompressedFrequencyTableSize = RANSNx16Encode.writeFrequenciesOrder1(frequencyTable, frequencies);
        frequencyTable.limit(uncompressedFrequencyTableSize);
        frequencyTable.rewind();
        this.compressOrder0WayN(frequencyTable, new RANSNx16Params(-6), compressedFrequencyTable);
        frequencyTable.rewind();
        this.initializeRANSEncoder();
        int compressedFrequencyTableSize = compressedFrequencyTable.limit();
        ByteBuffer cp = CompressionUtils.slice(outBuffer);
        if (compressedFrequencyTableSize < uncompressedFrequencyTableSize) {
            cp.put((byte)-63);
            CompressionUtils.writeUint7(uncompressedFrequencyTableSize, cp);
            CompressionUtils.writeUint7(compressedFrequencyTableSize, cp);
            for (i = 0; i < compressedFrequencyTableSize; ++i) {
                cp.put(compressedFrequencyTable.get());
            }
        } else {
            cp.put((byte)-64);
            for (i = 0; i < uncompressedFrequencyTableSize; ++i) {
                cp.put(frequencyTable.get());
            }
        }
        int frequencyTableSize = cp.position();
        Utils.normaliseFrequenciesOrder1Shift(frequencies, 12);
        this.buildSymsOrder1(frequencies);
        int Nway = ransNx16Params.getNumInterleavedRANSStates();
        long[] rans = new long[Nway];
        for (int r2 = 0; r2 < Nway; ++r2) {
            rans[r2] = 32768L;
        }
        int inputSize = inBuffer.remaining();
        int interleaveSize = Nway == 4 ? inputSize >> 2 : inputSize >> 5;
        int[] interleaveStreamIndex = new int[Nway];
        byte[] symbol = new byte[Nway];
        for (int r3 = 0; r3 < Nway; ++r3) {
            interleaveStreamIndex[r3] = (r3 + 1) * interleaveSize - 2;
            symbol[r3] = 0;
            if (interleaveStreamIndex[r3] + 1 >= 0 && r3 != Nway - 1) {
                symbol[r3] = inBuffer.get(interleaveStreamIndex[r3] + 1);
            }
            if (r3 != Nway - 1) continue;
            symbol[r3] = inBuffer.get(inputSize - 1);
        }
        ByteBuffer ptr = CompressionUtils.slice(cp);
        RANSEncodingSymbol[][] ransEncodingSymbols = this.getEncodingSymbols();
        byte[] context = new byte[Nway];
        interleaveStreamIndex[Nway - 1] = inputSize - 2;
        while (interleaveStreamIndex[Nway - 1] > Nway * interleaveSize - 2 && interleaveStreamIndex[Nway - 1] >= 0) {
            context[Nway - 1] = inBuffer.get(interleaveStreamIndex[Nway - 1]);
            rans[Nway - 1] = ransEncodingSymbols[0xFF & context[Nway - 1]][0xFF & symbol[Nway - 1]].putSymbolNx16(rans[Nway - 1], ptr);
            symbol[Nway - 1] = context[Nway - 1];
            int n = Nway - 1;
            interleaveStreamIndex[n] = interleaveStreamIndex[n] - 1;
        }
        while (interleaveStreamIndex[0] >= 0) {
            for (r = 0; r < Nway; ++r) {
                context[Nway - 1 - r] = inBuffer.get(interleaveStreamIndex[Nway - 1 - r]);
                rans[Nway - 1 - r] = ransEncodingSymbols[0xFF & context[Nway - 1 - r]][0xFF & symbol[Nway - 1 - r]].putSymbolNx16(rans[Nway - 1 - r], ptr);
                symbol[Nway - 1 - r] = context[Nway - 1 - r];
            }
            r = 0;
            while (r < Nway) {
                int n = r++;
                interleaveStreamIndex[n] = interleaveStreamIndex[n] - 1;
            }
        }
        for (r = 0; r < Nway; ++r) {
            rans[Nway - 1 - r] = ransEncodingSymbols[0][0xFF & symbol[Nway - 1 - r]].putSymbolNx16(rans[Nway - 1 - r], ptr);
        }
        ptr.order(ByteOrder.BIG_ENDIAN);
        for (r = Nway - 1; r >= 0; --r) {
            ptr.putInt((int)rans[r]);
        }
        ptr.flip();
        int compressedBlobSize = ptr.limit();
        Utils.reverse(ptr);
        inBuffer.position(inBuffer.limit());
        outBuffer.rewind();
        outBuffer.limit(prefix_size + frequencyTableSize + compressedBlobSize);
    }

    private static int[] buildFrequenciesOrder0(ByteBuffer inBuffer) {
        int inSize = inBuffer.remaining();
        int[] F = new int[256];
        for (int i = 0; i < inSize; ++i) {
            int n = 0xFF & inBuffer.get();
            F[n] = F[n] + 1;
        }
        return F;
    }

    private static int[][] buildFrequenciesOrder1(ByteBuffer inBuffer, int Nway) {
        int inputSize = inBuffer.remaining();
        int[][] frequency = new int[257][256];
        int contextSymbol = 0;
        for (int i = 0; i < inputSize; ++i) {
            int[] nArray = frequency[256];
            int n = 0xFF & contextSymbol;
            nArray[n] = nArray[n] + 1;
            byte srcSymbol = inBuffer.get(i);
            int[] nArray2 = frequency[0xFF & contextSymbol];
            int n2 = 0xFF & srcSymbol;
            nArray2[n2] = nArray2[n2] + 1;
            contextSymbol = srcSymbol;
        }
        int[] nArray = frequency[256];
        int n = 0xFF & contextSymbol;
        nArray[n] = nArray[n] + 1;
        for (int n3 = 1; n3 < Nway; ++n3) {
            int symbol = Nway == 4 ? 0xFF & inBuffer.get(n3 * (inputSize >> 2)) : 0xFF & inBuffer.get(n3 * (inputSize >> 5));
            int[] nArray3 = frequency[0];
            int n4 = symbol;
            nArray3[n4] = nArray3[n4] + 1;
        }
        int[] nArray4 = frequency[256];
        nArray4[0] = nArray4[0] + (Nway - 1);
        return frequency;
    }

    private static int writeFrequenciesOrder0(ByteBuffer cp, int[] F) {
        int start = cp.position();
        RANSNx16Encode.writeAlphabet(cp, F);
        for (int j = 0; j < 256; ++j) {
            if (F[j] == 0) continue;
            if (F[j] < 128) {
                cp.put((byte)(F[j] & 0x7F));
                continue;
            }
            cp.put((byte)(0x80 | F[j] >> 7));
            cp.put((byte)(F[j] & 0x7F));
        }
        return cp.position() - start;
    }

    private static int writeFrequenciesOrder1(ByteBuffer cp, int[][] F) {
        int start = cp.position();
        RANSNx16Encode.writeAlphabet(cp, F[256]);
        for (int i = 0; i < 256; ++i) {
            if (F[256][i] == 0) continue;
            int run = 0;
            for (int j = 0; j < 256; ++j) {
                if (F[256][j] == 0) continue;
                if (run > 0) {
                    --run;
                    continue;
                }
                CompressionUtils.writeUint7(F[i][j], cp);
                if (F[i][j] != 0) continue;
                for (int k = j + 1; k < 256; ++k) {
                    if (F[256][k] == 0) continue;
                    if (F[i][k] != 0) break;
                    ++run;
                }
                cp.put((byte)run);
            }
        }
        return cp.position() - start;
    }

    private static void writeAlphabet(ByteBuffer cp, int[] F) {
        int rle = 0;
        for (int j = 0; j < 256; ++j) {
            if (F[j] == 0) continue;
            if (rle != 0) {
                --rle;
                continue;
            }
            cp.put((byte)j);
            if (rle != 0 || j == 0 || F[j - 1] == 0) continue;
            for (rle = j + 1; rle < 256 && F[rle] != 0; ++rle) {
            }
            cp.put((byte)(rle -= j + 1));
        }
        cp.put((byte)0);
    }

    private ByteBuffer encodeRLE(ByteBuffer inBuffer, ByteBuffer outBuffer, RANSNx16Params ransNx16Params) {
        int[] runCounts = new int[256];
        int inputSize = inBuffer.remaining();
        int lastSymbol = -1;
        for (int i = 0; i < inputSize; ++i) {
            int currentSymbol;
            int n = currentSymbol = inBuffer.get(i) & 0xFF;
            runCounts[n] = runCounts[n] + (currentSymbol == lastSymbol ? 1 : -1);
            lastSymbol = currentSymbol;
        }
        int numRLESymbols = 0;
        for (int i = 0; i < 256; ++i) {
            if (runCounts[i] <= 0) continue;
            ++numRLESymbols;
        }
        if (numRLESymbols == 0) {
            numRLESymbols = 1;
            runCounts[0] = 1;
        }
        ByteBuffer rleMetaData = CompressionUtils.allocateByteBuffer(numRLESymbols + 1 + inputSize);
        rleMetaData.put((byte)numRLESymbols);
        for (int i = 0; i < 256; ++i) {
            if (runCounts[i] <= 0) continue;
            rleMetaData.put((byte)i);
        }
        ByteBuffer encodedBuffer = CompressionUtils.allocateByteBuffer(inputSize);
        int encodedBufferIdx = 0;
        for (int i = 0; i < inputSize; ++i) {
            encodedBuffer.put(encodedBufferIdx++, inBuffer.get(i));
            if (runCounts[inBuffer.get(i) & 0xFF] <= 0) continue;
            lastSymbol = inBuffer.get(i) & 0xFF;
            int run = 0;
            while (i + run + 1 < inputSize && (inBuffer.get(i + run + 1) & 0xFF) == lastSymbol) {
                ++run;
            }
            CompressionUtils.writeUint7(run, rleMetaData);
            i += run;
        }
        encodedBuffer.limit(encodedBufferIdx);
        rleMetaData.limit(rleMetaData.position());
        rleMetaData.rewind();
        ByteBuffer compressedRleMetaData = CompressionUtils.allocateOutputBuffer(rleMetaData.remaining());
        this.compressOrder0WayN(rleMetaData, new RANSNx16Params(0 | ransNx16Params.getFormatFlags() & 4), compressedRleMetaData);
        CompressionUtils.writeUint7(rleMetaData.limit() * 2, outBuffer);
        CompressionUtils.writeUint7(encodedBufferIdx, outBuffer);
        CompressionUtils.writeUint7(compressedRleMetaData.limit(), outBuffer);
        outBuffer.put(compressedRleMetaData);
        inBuffer.position(inBuffer.limit());
        return encodedBuffer;
    }
}

