/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.cram.structure.CompressionHeaderEncodingMap;
import htsjdk.utils.ValidationUtils;

public class CRAMEncodingStrategy {
    public static final int DEFAULT_MINIMUM_SINGLE_REFERENCE_SLICE_THRESHOLD = 1000;
    public static final int DEFAULT_READS_PER_SLICE = 10000;
    private CompressionHeaderEncodingMap customCompressionHeaderEncodingMap;
    private int gzipCompressionLevel = Defaults.COMPRESSION_LEVEL;
    private int minimumSingleReferenceSliceSize = 1000;
    private int readsPerSlice = 10000;
    private int slicesPerContainer = 1;

    public CRAMEncodingStrategy setReadsPerSlice(int readsPerSlice) {
        ValidationUtils.validateArg(readsPerSlice > 0 && readsPerSlice >= this.minimumSingleReferenceSliceSize, String.format("Reads per slice must be > 0 and < minimum single reference slice size (%d)", this.minimumSingleReferenceSliceSize));
        this.readsPerSlice = readsPerSlice;
        return this;
    }

    public CRAMEncodingStrategy setMinimumSingleReferenceSliceSize(int minimumSingleReferenceSliceSize) {
        ValidationUtils.validateArg(minimumSingleReferenceSliceSize <= this.readsPerSlice, String.format("Minimm single reference slice size must be < the reads per slice size (%d)", this.readsPerSlice));
        this.minimumSingleReferenceSliceSize = minimumSingleReferenceSliceSize;
        return this;
    }

    public int getMinimumSingleReferenceSliceSize() {
        return this.minimumSingleReferenceSliceSize;
    }

    public CRAMEncodingStrategy setGZIPCompressionLevel(int compressionLevel) {
        ValidationUtils.validateArg(compressionLevel >= 0 && compressionLevel <= 10, "cram gzip compression level must be > 0 and <= 10");
        this.gzipCompressionLevel = compressionLevel;
        return this;
    }

    public CRAMEncodingStrategy setSlicesPerContainer(int slicesPerContainer) {
        ValidationUtils.validateArg(slicesPerContainer >= 0, "slicesPerContainer must be > 0");
        this.slicesPerContainer = slicesPerContainer;
        return this;
    }

    public void setCustomCompressionHeaderEncodingMap(CompressionHeaderEncodingMap encodingMap) {
        this.customCompressionHeaderEncodingMap = encodingMap;
    }

    public CompressionHeaderEncodingMap getCustomCompressionHeaderEncodingMap() {
        return this.customCompressionHeaderEncodingMap;
    }

    public int getGZIPCompressionLevel() {
        return this.gzipCompressionLevel;
    }

    public int getReadsPerSlice() {
        return this.readsPerSlice;
    }

    public int getSlicesPerContainer() {
        return this.slicesPerContainer;
    }

    public String toString() {
        return "CRAMEncodingStrategy{, customCompressionMap='" + String.valueOf(this.customCompressionHeaderEncodingMap) + "', gzipCompressionLevel=" + this.gzipCompressionLevel + ", readsPerSlice=" + this.readsPerSlice + ", slicesPerContainer=" + this.slicesPerContainer + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRAMEncodingStrategy that = (CRAMEncodingStrategy)o;
        if (this.gzipCompressionLevel != that.gzipCompressionLevel) {
            return false;
        }
        if (this.getMinimumSingleReferenceSliceSize() != that.getMinimumSingleReferenceSliceSize()) {
            return false;
        }
        if (this.getReadsPerSlice() != that.getReadsPerSlice()) {
            return false;
        }
        if (this.getSlicesPerContainer() != that.getSlicesPerContainer()) {
            return false;
        }
        return this.getCustomCompressionHeaderEncodingMap() != null ? this.getCustomCompressionHeaderEncodingMap().equals(that.getCustomCompressionHeaderEncodingMap()) : that.getCustomCompressionHeaderEncodingMap() == null;
    }

    public int hashCode() {
        int result = this.getCustomCompressionHeaderEncodingMap() != null ? this.getCustomCompressionHeaderEncodingMap().hashCode() : 0;
        result = 31 * result + this.gzipCompressionLevel;
        result = 31 * result + this.getMinimumSingleReferenceSliceSize();
        result = 31 * result + this.getReadsPerSlice();
        result = 31 * result + this.getSlicesPerContainer();
        return result;
    }
}

