/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.compression.RANSExternalCompressor;
import htsjdk.samtools.cram.compression.rans.RANSParams;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Decode;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Encode;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.samtools.util.Tuple;
import htsjdk.utils.ValidationUtils;
import java.util.HashMap;

public class CompressorCache {
    private final String argErrorMessage = "Invalid compression arg (%d) requested for CRAM %s compressor";
    private final HashMap<Tuple<BlockCompressionMethod, Integer>, ExternalCompressor> compressorCache = new HashMap();
    private RANS4x8Encode sharedRANSEncode;
    private RANS4x8Decode sharedRANSDecode;

    public ExternalCompressor getCompressorForMethod(BlockCompressionMethod compressionMethod, int compressorSpecificArg) {
        switch (compressionMethod) {
            case GZIP: {
                return this.getCachedCompressorForMethod(compressionMethod, compressorSpecificArg);
            }
            case BZIP2: 
            case RAW: 
            case LZMA: {
                ValidationUtils.validateArg(compressorSpecificArg == -1, String.format("Invalid compression arg (%d) requested for CRAM %s compressor", new Object[]{compressorSpecificArg, compressionMethod}));
                return this.getCachedCompressorForMethod(compressionMethod, compressorSpecificArg);
            }
            case RANS: {
                int ransArg = compressorSpecificArg == -1 ? RANSParams.ORDER.ZERO.ordinal() : compressorSpecificArg;
                Tuple<BlockCompressionMethod, Integer> compressorTuple = new Tuple<BlockCompressionMethod, Integer>(BlockCompressionMethod.RANS, ransArg);
                if (!this.compressorCache.containsKey(compressorTuple)) {
                    if (this.sharedRANSEncode == null) {
                        this.sharedRANSEncode = new RANS4x8Encode();
                    }
                    if (this.sharedRANSDecode == null) {
                        this.sharedRANSDecode = new RANS4x8Decode();
                    }
                    this.compressorCache.put(new Tuple<BlockCompressionMethod, Integer>(BlockCompressionMethod.RANS, ransArg), new RANSExternalCompressor(ransArg, this.sharedRANSEncode, this.sharedRANSDecode));
                }
                return this.getCachedCompressorForMethod((BlockCompressionMethod)((Object)compressorTuple.a), (Integer)compressorTuple.b);
            }
            case RANGE: {
                return this.getCachedCompressorForMethod(compressionMethod, compressorSpecificArg);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown compression method %s", new Object[]{compressionMethod}));
    }

    private ExternalCompressor getCachedCompressorForMethod(BlockCompressionMethod method, int compressorSpecificArg) {
        return this.compressorCache.computeIfAbsent(new Tuple<BlockCompressionMethod, Integer>(method, compressorSpecificArg), k -> ExternalCompressor.getCompressorForMethod(method, compressorSpecificArg));
    }
}

