/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.TextTagCodec;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.util.SequenceUtil;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;

public final class FastqEncoder {
    public static final BiConsumer<FastqRecord, SAMRecord> QUALITY_HEADER_TO_COMMENT_TAG = (record, samRecord) -> samRecord.setAttribute(SAMTag.CO, (Object)record.getBaseQualityHeader().replaceAll("\t", " "));
    public static final BiConsumer<FastqRecord, SAMRecord> QUALITY_HEADER_PARSE_SAM_TAGS = (record, samRecord) -> {
        String[] tokens = record.getBaseQualityHeader().split("\t");
        TextTagCodec codec = new TextTagCodec();
        for (String token : tokens) {
            Map.Entry<String, Object> tagValue = codec.decode(token);
            samRecord.setAttribute(tagValue.getKey(), tagValue.getValue());
        }
    };

    private FastqEncoder() {
    }

    public static String encode(FastqRecord record) {
        int capacity = record.getReadLength() * 2 + 5;
        if (record.getReadName() != null) {
            capacity += record.getReadName().length();
        }
        return FastqEncoder.write(new StringBuilder(capacity), record).toString();
    }

    public static Appendable write(Appendable out, FastqRecord record) {
        String readName = record.getReadName();
        String readString = record.getReadString();
        String qualHeader = record.getBaseQualityHeader();
        String qualityString = record.getBaseQualityString();
        try {
            return out.append("@").append(readName == null ? "" : readName).append('\n').append(readString == null ? "" : readString).append('\n').append("+").append(qualHeader == null ? "" : qualHeader).append('\n').append(qualityString == null ? "" : qualityString);
        }
        catch (IOException e) {
            throw new SAMException(e);
        }
    }

    public static String encode(SAMRecord record) {
        return FastqEncoder.encode(FastqEncoder.asFastqRecord(record));
    }

    public static FastqRecord asFastqRecord(SAMRecord record) {
        Object readName = record.getReadName();
        if (record.getReadPairedFlag() && (record.getFirstOfPairFlag() || record.getSecondOfPairFlag())) {
            readName = (String)readName + (record.getFirstOfPairFlag() ? "/1" : "/2");
        }
        return new FastqRecord((String)readName, record.getReadString(), record.getStringAttribute(SAMTag.CO), record.getBaseQualityString());
    }

    public static SAMRecord asSAMRecord(FastqRecord record, SAMFileHeader header) {
        return FastqEncoder.asSAMRecord(record, header, (s2, r) -> {});
    }

    public static SAMRecord asSAMRecord(FastqRecord record, SAMFileHeader header, BiConsumer<FastqRecord, SAMRecord> custom) {
        SAMRecord samRecord = new SAMRecord(header);
        samRecord.setReadUnmappedFlag(true);
        String readName = SequenceUtil.getSamReadNameFromFastqHeader(record.getReadName());
        samRecord.setReadName(readName);
        samRecord.setReadBases(record.getReadBases());
        samRecord.setBaseQualities(record.getBaseQualities());
        custom.accept(record, samRecord);
        return samRecord;
    }
}

