/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SnappyLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

class SnappyLoaderInternal {
    private static final Log logger = Log.getInstance(SnappyLoaderInternal.class);
    private static final int SNAPPY_BLOCK_SIZE = 32768;

    SnappyLoaderInternal() {
    }

    static boolean tryToLoadSnappy() {
        boolean tmpSnappyAvailable = false;
        try (SnappyOutputStream test = new SnappyOutputStream(new ByteArrayOutputStream(1000));){
            test.write("Hello World!".getBytes());
            tmpSnappyAvailable = true;
            logger.debug("Snappy successfully loaded.");
        }
        catch (IOException | ExceptionInInitializerError | IllegalStateException | SnappyError e) {
            logger.warn(e, "Snappy native library failed to load.");
        }
        boolean snappyAvailable = tmpSnappyAvailable;
        return snappyAvailable;
    }

    static SnappyLoader.IOFunction<InputStream, InputStream> getInputStreamWrapper() {
        return SnappyInputStream::new;
    }

    static SnappyLoader.IOFunction<OutputStream, OutputStream> getOutputStreamWrapper() {
        return stream -> new SnappyOutputStream((OutputStream)stream, 32768);
    }
}

