/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.htsget;

import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.htsget.HtsgetClass;
import htsjdk.samtools.util.htsget.HtsgetErrorResponse;
import htsjdk.samtools.util.htsget.HtsgetFormat;
import htsjdk.samtools.util.htsget.HtsgetRequestField;
import htsjdk.samtools.util.htsget.HtsgetResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class HtsgetRequest {
    private static final Log log = Log.getInstance(HtsgetRequest.class);
    public static final Interval UNMAPPED_UNPLACED_INTERVAL = new Interval("*", 1, Integer.MAX_VALUE);
    protected static final String PROTOCOL_VERSION = "vnd.ga4gh.htsget.v1.2.0";
    protected static final String ACCEPT_TYPE = "application/vnd.ga4gh.htsget.v1.2.0+json";
    private final URI endpoint;
    protected HtsgetFormat format;
    protected HtsgetClass dataClass;
    protected Locatable interval;
    protected final EnumSet<HtsgetRequestField> fields;
    protected final Set<String> tags;
    protected final Set<String> notags;

    public HtsgetRequest(URI endpoint) {
        this.endpoint = endpoint;
        this.fields = EnumSet.noneOf(HtsgetRequestField.class);
        this.tags = new HashSet<String>();
        this.notags = new HashSet<String>();
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public HtsgetFormat getFormat() {
        return this.format;
    }

    public HtsgetClass getDataClass() {
        return this.dataClass;
    }

    public Locatable getInterval() {
        return this.interval;
    }

    public Set<HtsgetRequestField> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public Set<String> getNoTags() {
        return Collections.unmodifiableSet(this.notags);
    }

    public void setFormat(HtsgetFormat format) {
        this.format = format;
    }

    public void setDataClass(HtsgetClass dataClass) {
        this.dataClass = dataClass;
    }

    public void setInterval(Locatable interval) {
        this.interval = interval;
    }

    public void addField(HtsgetRequestField field) {
        this.fields.add(field);
    }

    public void addFields(Collection<HtsgetRequestField> fields) {
        this.fields.addAll(fields);
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addTags(Collection<String> tags) {
        this.tags.addAll(tags);
    }

    public void addNotag(String notag) {
        this.notags.add(notag);
    }

    public void addNotags(Collection<String> notags) {
        this.notags.addAll(notags);
    }

    public HtsgetRequest withFormat(HtsgetFormat format) {
        this.format = format;
        return this;
    }

    public HtsgetRequest withDataClass(HtsgetClass dataClass) {
        this.dataClass = dataClass;
        return this;
    }

    public HtsgetRequest withInterval(Locatable interval) {
        this.interval = interval;
        return this;
    }

    public HtsgetRequest withField(HtsgetRequestField field) {
        this.fields.add(field);
        return this;
    }

    public HtsgetRequest withFields(Collection<HtsgetRequestField> fields) {
        this.fields.addAll(fields);
        return this;
    }

    public HtsgetRequest withTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public HtsgetRequest withTags(Collection<String> tags) {
        this.tags.addAll(tags);
        return this;
    }

    public HtsgetRequest withNotag(String notag) {
        this.notags.add(notag);
        return this;
    }

    public HtsgetRequest withNotags(Collection<String> notags) {
        this.notags.addAll(notags);
        return this;
    }

    public void validateRequest() {
        String intersections;
        if (!(this.dataClass == null || this.dataClass != HtsgetClass.header || this.interval == null && this.fields.isEmpty() && this.tags.isEmpty() && this.notags.isEmpty())) {
            throw new IllegalArgumentException("Invalid request: no query parameters except `format` may be specified when class=header");
        }
        if (this.format != null) {
            String path = this.endpoint.getPath();
            if ((path.endsWith(".bam") || path.endsWith(".cram")) && this.format != HtsgetFormat.BAM && this.format != HtsgetFormat.CRAM) {
                throw new IllegalArgumentException("Specified reads format: " + String.valueOf((Object)this.format) + " is incompatible with id's file extension " + path);
            }
            if (FileExtensions.VCF_LIST.stream().anyMatch(path::endsWith) && this.format != HtsgetFormat.VCF && this.format != HtsgetFormat.BCF) {
                throw new IllegalArgumentException("Specified variant format: " + String.valueOf((Object)this.format) + " is incompatible with id's file extension " + path);
            }
        }
        if (!(intersections = this.tags.stream().filter(this.getNoTags()::contains).collect(Collectors.joining(", "))).isEmpty()) {
            throw new IllegalArgumentException("Invalid request: tags and notags overlap in the following fields: " + intersections);
        }
    }

    public URI toURI() {
        this.validateRequest();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.format != null) {
            queryParams.put("format", this.format.toString());
        }
        if (this.dataClass != null) {
            queryParams.put("class", String.valueOf((Object)this.dataClass));
        }
        if (this.interval != null && this.interval.getContig() != null) {
            queryParams.put("referenceName", this.interval.getContig());
            if (!this.interval.getContig().equals("*")) {
                queryParams.put("start", String.valueOf(this.interval.getStart() - 1));
                if (this.interval.getEnd() != Integer.MAX_VALUE && this.interval.getEnd() != -1) {
                    queryParams.put("end", String.valueOf(this.interval.getEnd()));
                }
            }
        }
        if (!this.fields.isEmpty()) {
            queryParams.put("fields", this.fields.stream().map(Enum::toString).collect(Collectors.joining(",")));
        }
        if (!this.tags.isEmpty()) {
            queryParams.put("tags", String.join((CharSequence)",", this.tags));
        }
        if (!this.notags.isEmpty()) {
            queryParams.put("notags", String.join((CharSequence)",", this.notags));
        }
        try {
            String queryString = queryParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
            Object updatedQuery = this.endpoint.getQuery() == null ? (queryString.isEmpty() ? null : queryString) : this.endpoint.getQuery() + "&" + queryString;
            return new URI(this.endpoint.getScheme(), this.endpoint.getUserInfo(), this.endpoint.getHost(), this.endpoint.getPort(), this.endpoint.getPath(), (String)updatedQuery, this.endpoint.getFragment());
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException("Could not create URI for request", e2);
        }
    }

    protected HttpURLConnection getConnection() {
        URI reqURI = this.toURI();
        try {
            HttpURLConnection conn = (HttpURLConnection)reqURI.toURL().openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", ACCEPT_TYPE);
            conn.connect();
            return conn;
        }
        catch (IOException e) {
            throw new RuntimeIOException("IOException while attempting htsget download, request: " + String.valueOf(reqURI), e);
        }
    }

    public HtsgetResponse getResponse() {
        try {
            String line;
            HttpURLConnection conn = this.getConnection();
            InputStream is = conn.getInputStream();
            int statusCode = conn.getResponseCode();
            String respContentType = conn.getContentType();
            if (respContentType != null && !respContentType.isEmpty() && !respContentType.contains(PROTOCOL_VERSION)) {
                log.warn("Supported htsget protocol version: vnd.ga4gh.htsget.v1.2.0may not be compatible with received content type: " + respContentType);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            String json = out.toString();
            if (400 <= statusCode && statusCode < 500) {
                HtsgetErrorResponse err = HtsgetErrorResponse.parse(json);
                throw new IllegalArgumentException("Invalid request, received error code: " + statusCode + ", error type: " + err.getError() + ", message: " + err.getMessage());
            }
            if (statusCode == 200) {
                return HtsgetResponse.parse(json);
            }
            throw new IllegalStateException("Unrecognized status code: " + statusCode);
        }
        catch (IOException e) {
            throw new RuntimeIOException("IOException while attempting htsget download", e);
        }
    }
}

