/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gff;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.Log;
import htsjdk.tribble.AbstractFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.gff.Gff3BaseData;
import htsjdk.tribble.gff.Gff3Feature;
import htsjdk.tribble.gff.Gff3FeatureImpl;
import htsjdk.tribble.gff.Gff3Writer;
import htsjdk.tribble.gff.SequenceRegion;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.SynchronousLineReader;
import htsjdk.tribble.util.ParsingUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class Gff3Codec
extends AbstractFeatureCodec<Gff3Feature, LineIterator> {
    private static final int NUM_FIELDS = 9;
    private static final int CHROMOSOME_NAME_INDEX = 0;
    private static final int ANNOTATION_SOURCE_INDEX = 1;
    private static final int FEATURE_TYPE_INDEX = 2;
    private static final int START_LOCATION_INDEX = 3;
    private static final int END_LOCATION_INDEX = 4;
    private static final int SCORE_INDEX = 5;
    private static final int GENOMIC_STRAND_INDEX = 6;
    private static final int GENOMIC_PHASE_INDEX = 7;
    private static final int EXTRA_FIELDS_INDEX = 8;
    private static final String IS_CIRCULAR_ATTRIBUTE_KEY = "Is_circular";
    private static final String ARTEMIS_FASTA_MARKER = ">";
    private final Queue<Gff3FeatureImpl> activeFeatures = new ArrayDeque<Gff3FeatureImpl>();
    private final Queue<Gff3FeatureImpl> featuresToFlush = new ArrayDeque<Gff3FeatureImpl>();
    private final Map<String, Set<Gff3FeatureImpl>> activeFeaturesWithIDs = new HashMap<String, Set<Gff3FeatureImpl>>();
    private final Map<String, Set<Gff3FeatureImpl>> activeParentIDs = new HashMap<String, Set<Gff3FeatureImpl>>();
    private final Map<String, SequenceRegion> sequenceRegionMap = new LinkedHashMap<String, SequenceRegion>();
    private final Map<Integer, String> commentsWithLineNumbers = new LinkedHashMap<Integer, String>();
    private static final Log logger = Log.getInstance(Gff3Codec.class);
    private boolean reachedFasta = false;
    private DecodeDepth decodeDepth;
    private int currentLine = 0;
    private final Predicate<String> filterOutAttribute;

    public Gff3Codec() {
        this(DecodeDepth.DEEP);
    }

    public Gff3Codec(DecodeDepth decodeDepth) {
        this(decodeDepth, KEY -> false);
    }

    public Gff3Codec(DecodeDepth decodeDepth, Predicate<String> filterOutAttribute) {
        super(Gff3Feature.class);
        this.decodeDepth = decodeDepth;
        this.filterOutAttribute = filterOutAttribute;
        for (String key : new String[]{"Parent", "ID", "Name"}) {
            if (!filterOutAttribute.test(key)) continue;
            throw new IllegalArgumentException("Predicate should always accept " + key);
        }
    }

    @Override
    public Gff3Feature decode(LineIterator lineIterator) throws IOException {
        return this.decode(lineIterator, this.decodeDepth);
    }

    private Gff3Feature decode(LineIterator lineIterator, DecodeDepth depth) throws IOException {
        ++this.currentLine;
        if (!lineIterator.hasNext()) {
            this.prepareToFlushFeatures();
            return this.featuresToFlush.poll();
        }
        String line = (String)lineIterator.next();
        if (this.reachedFasta) {
            this.prepareToFlushFeatures();
            return this.featuresToFlush.poll();
        }
        if (line.startsWith(ARTEMIS_FASTA_MARKER)) {
            this.processDirective(Gff3Directive.FASTA_DIRECTIVE, null);
            return this.featuresToFlush.poll();
        }
        if (line.startsWith("#") && !line.startsWith("##")) {
            this.commentsWithLineNumbers.put(this.currentLine, line.substring("#".length()));
            return this.featuresToFlush.poll();
        }
        if (line.startsWith("##")) {
            this.parseDirective(line);
            return this.featuresToFlush.poll();
        }
        Gff3FeatureImpl thisFeature = new Gff3FeatureImpl(Gff3Codec.parseLine(line, this.currentLine, this.filterOutAttribute));
        this.activeFeatures.add(thisFeature);
        if (depth == DecodeDepth.DEEP) {
            List<String> parentIDs = thisFeature.getAttribute("Parent");
            String id = thisFeature.getID();
            for (String parentID : parentIDs) {
                Set<Gff3FeatureImpl> theseParents = this.activeFeaturesWithIDs.get(parentID);
                if (theseParents != null) {
                    for (Gff3FeatureImpl parent : theseParents) {
                        thisFeature.addParent(parent);
                    }
                }
                if (this.activeParentIDs.containsKey(parentID)) {
                    this.activeParentIDs.get(parentID).add(thisFeature);
                    continue;
                }
                this.activeParentIDs.put(parentID, new HashSet<Gff3FeatureImpl>(Collections.singleton(thisFeature)));
            }
            if (id != null) {
                if (this.activeFeaturesWithIDs.containsKey(id)) {
                    for (Gff3FeatureImpl coFeature : this.activeFeaturesWithIDs.get(id)) {
                        thisFeature.addCoFeature(coFeature);
                    }
                    this.activeFeaturesWithIDs.get(id).add(thisFeature);
                } else {
                    this.activeFeaturesWithIDs.put(id, new HashSet<Gff3FeatureImpl>(Collections.singleton(thisFeature)));
                }
            }
            if (this.activeParentIDs.containsKey(thisFeature.getID())) {
                for (Gff3FeatureImpl child : this.activeParentIDs.get(thisFeature.getID())) {
                    child.addParent(thisFeature);
                }
            }
        }
        this.validateFeature(thisFeature);
        if (depth == DecodeDepth.SHALLOW) {
            this.prepareToFlushFeatures();
        }
        return this.featuresToFlush.poll();
    }

    private static Map<String, List<String>> parseAttributes(String attributesString) throws UnsupportedEncodingException {
        if (attributesString.equals(".")) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> attributes = new LinkedHashMap<String, List<String>>();
        List<String> splitLine = ParsingUtils.split(attributesString, ';');
        for (String attribute : splitLine) {
            List<String> key_value = ParsingUtils.split(attribute, '=');
            if (key_value.size() != 2) {
                throw new TribbleException("Attribute string " + attributesString + " is invalid");
            }
            attributes.put(URLDecoder.decode(key_value.get(0).trim(), "UTF-8"), Gff3Codec.decodeAttributeValue(key_value.get(1).trim()));
        }
        return attributes;
    }

    private static Gff3BaseData parseLine(String line, int currentLine, Predicate<String> filterOutAttribute) {
        List<String> splitLine = ParsingUtils.split(line, '\t');
        if (splitLine.size() != 9) {
            throw new TribbleException("Found an invalid number of columns in the given Gff3 file at line + " + currentLine + " - Given: " + splitLine.size() + " Expected: 9 : " + line);
        }
        try {
            String contig = URLDecoder.decode(splitLine.get(0), "UTF-8");
            String source = URLDecoder.decode(splitLine.get(1), "UTF-8");
            String type = URLDecoder.decode(splitLine.get(2), "UTF-8");
            int start = Integer.parseInt(splitLine.get(3));
            int end = Integer.parseInt(splitLine.get(4));
            double score = splitLine.get(5).equals(".") ? -1.0 : Double.parseDouble(splitLine.get(5));
            int phase = splitLine.get(7).equals(".") ? -1 : Integer.parseInt(splitLine.get(7));
            Strand strand = Strand.decode(splitLine.get(6));
            Map<String, List<String>> attributes = Gff3Codec.parseAttributes(splitLine.get(8));
            attributes.keySet().removeIf(filterOutAttribute);
            return new Gff3BaseData(contig, source, type, start, end, score, strand, phase, attributes);
        }
        catch (NumberFormatException ex) {
            throw new TribbleException("Cannot read integer value for start/end position from line " + currentLine + ".  Line is: " + line, ex);
        }
        catch (IOException ex) {
            throw new TribbleException("Cannot decode feature info from line " + currentLine + ".  Line is: " + line, ex);
        }
    }

    public List<SequenceRegion> getSequenceRegions() {
        return Collections.unmodifiableList(new ArrayList<SequenceRegion>(this.sequenceRegionMap.values()));
    }

    public Map<Integer, String> getCommentsWithLineNumbers() {
        return Collections.unmodifiableMap(new LinkedHashMap<Integer, String>(this.commentsWithLineNumbers));
    }

    public List<String> getCommentTexts() {
        return Collections.unmodifiableList(new ArrayList<String>(this.commentsWithLineNumbers.values()));
    }

    private void validateFeature(Gff3Feature feature) {
        if (this.sequenceRegionMap.containsKey(feature.getContig())) {
            SequenceRegion region = this.sequenceRegionMap.get(feature.getContig());
            if (feature.getStart() == region.getStart() && feature.getEnd() == region.getEnd()) {
                boolean isCircular = Boolean.parseBoolean(Gff3Codec.extractSingleAttribute(feature.getAttribute(IS_CIRCULAR_ATTRIBUTE_KEY)));
                region.setCircular(isCircular);
            }
            if (region.isCircular() ? !region.overlaps(feature) : !region.contains(feature)) {
                throw new TribbleException("feature at " + feature.getContig() + ":" + feature.getStart() + "-" + feature.getEnd() + " not contained in specified sequence region (" + region.getContig() + ":" + region.getStart() + "-" + region.getEnd());
            }
        }
    }

    @Override
    public Feature decodeLoc(LineIterator lineIterator) throws IOException {
        return this.decode(lineIterator, DecodeDepth.SHALLOW);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canDecode(String inputFilePath) {
        try {
            Path p = IOUtil.getPath(inputFilePath);
            boolean canDecode = FileExtensions.GFF3.stream().anyMatch(fe -> p.toString().endsWith((String)fe));
            if (!canDecode) return canDecode;
            InputStream inputStream = IOUtil.hasGzipFileExtension(p) ? new GZIPInputStream(Files.newInputStream(p, new OpenOption[0])) : Files.newInputStream(p, new OpenOption[0]);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line = br.readLine();
                if (Gff3Directive.toDirective(line) != Gff3Directive.VERSION3_DIRECTIVE) {
                    boolean bl = false;
                    return bl;
                }
                while (line.startsWith("#")) {
                    line = br.readLine();
                    if (line != null) continue;
                    boolean bl = false;
                    return bl;
                }
                List<String> fields = ParsingUtils.split(line, '\t');
                if (!(canDecode &= fields.size() == 9)) return canDecode;
                try {
                    int start = Integer.parseInt(fields.get(3));
                    int n = Integer.parseInt(fields.get(4));
                }
                catch (NullPointerException | NumberFormatException nfe) {
                    boolean bl = false;
                    br.close();
                    return bl;
                }
                String strand = fields.get(6);
                canDecode &= strand.equals(Strand.POSITIVE.toString()) || strand.equals(Strand.NEGATIVE.toString()) || strand.equals(Strand.NONE.toString()) || strand.equals("?");
                return canDecode;
            }
        }
        catch (FileNotFoundException ex) {
            logger.error(inputFilePath + " not found.");
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    static List<String> decodeAttributeValue(String attributeValue) {
        List<String> splitValues = ParsingUtils.split(attributeValue, ',');
        ArrayList<String> decodedValues = new ArrayList<String>();
        for (String encodedValue : splitValues) {
            try {
                decodedValues.add(URLDecoder.decode(encodedValue.trim(), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new TribbleException("Error decoding attribute " + encodedValue, ex);
            }
        }
        return decodedValues;
    }

    static String extractSingleAttribute(List<String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() != 1) {
            throw new TribbleException("Attribute has multiple values when only one expected");
        }
        return values.get(0);
    }

    @Override
    public FeatureCodecHeader readHeader(LineIterator lineIterator) {
        String line;
        ArrayList<String> header = new ArrayList<String>();
        while (lineIterator.hasNext() && (line = lineIterator.peek()).startsWith("#")) {
            header.add(line);
            lineIterator.next();
        }
        return new FeatureCodecHeader(header, 0L);
    }

    private void parseDirective(String directiveLine) throws IOException {
        Gff3Directive directive = Gff3Directive.toDirective(directiveLine);
        if (directive != null) {
            this.processDirective(directive, directive.decode(directiveLine));
        } else {
            logger.warn("ignoring directive " + directiveLine);
        }
    }

    private void processDirective(Gff3Directive directive, Object decodedResult) {
        switch (directive) {
            case VERSION3_DIRECTIVE: {
                break;
            }
            case SEQUENCE_REGION_DIRECTIVE: {
                SequenceRegion newRegion = (SequenceRegion)decodedResult;
                if (this.sequenceRegionMap.containsKey(newRegion.getContig())) {
                    throw new TribbleException("directive for sequence-region " + newRegion.getContig() + " included more than once.");
                }
                this.sequenceRegionMap.put(newRegion.getContig(), newRegion);
                break;
            }
            case FLUSH_DIRECTIVE: {
                this.prepareToFlushFeatures();
                break;
            }
            case FASTA_DIRECTIVE: {
                this.reachedFasta = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Directive " + String.valueOf((Object)directive) + " has been added to Gff3Directive, but is not being handled by Gff3Codec::processDirective.  This is a BUG.");
            }
        }
    }

    private void prepareToFlushFeatures() {
        this.featuresToFlush.addAll(this.activeFeatures);
        this.activeFeaturesWithIDs.clear();
        this.activeFeatures.clear();
        this.activeParentIDs.clear();
    }

    @Override
    public LineIterator makeSourceFromStream(InputStream bufferedInputStream) {
        return new LineIteratorImpl(new SynchronousLineReader(bufferedInputStream));
    }

    @Override
    public LocationAware makeIndexableSourceFromStream(InputStream bufferedInputStream) {
        return new AsciiLineReaderIterator(AsciiLineReader.from(bufferedInputStream));
    }

    @Override
    public boolean isDone(LineIterator lineIterator) {
        return !lineIterator.hasNext() && this.activeFeatures.isEmpty() && this.featuresToFlush.isEmpty();
    }

    @Override
    public void close(LineIterator lineIterator) {
        this.featuresToFlush.clear();
        this.activeFeaturesWithIDs.clear();
        this.activeFeatures.clear();
        this.activeParentIDs.clear();
        CloserUtil.close(lineIterator);
    }

    @Override
    public TabixFormat getTabixFormat() {
        return TabixFormat.GFF;
    }

    public static enum DecodeDepth {
        DEEP,
        SHALLOW;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Gff3Directive {
        VERSION3_DIRECTIVE("##gff-version\\s+3(?:\\.\\d*)*$"){

            @Override
            protected Object decode(String line) throws IOException {
                String[] splitLine = line.split("\\s+");
                return splitLine[1];
            }

            @Override
            String encode(Object object) {
                if (object == null) {
                    throw new TribbleException("Cannot encode null in VERSION3_DIRECTIVE");
                }
                if (!(object instanceof String)) {
                    throw new TribbleException("Cannot encode object of type " + String.valueOf(object.getClass()) + " in VERSION3_DIRECTIVE");
                }
                String versionLine = "##gff-version " + (String)object;
                if (!this.regexPattern.matcher(versionLine).matches()) {
                    throw new TribbleException("Version " + (String)object + " is not a valid version");
                }
                return versionLine;
            }
        }
        ,
        SEQUENCE_REGION_DIRECTIVE("##sequence-region\\s+.+ \\d+ \\d+$"){
            private final int CONTIG_INDEX = 1;
            private final int START_INDEX = 2;
            private final int END_INDEX = 3;

            @Override
            protected Object decode(String line) throws IOException {
                String[] splitLine = line.split("\\s+");
                String contig = URLDecoder.decode(splitLine[1], "UTF-8");
                int start = Integer.parseInt(splitLine[2]);
                int end = Integer.parseInt(splitLine[3]);
                return new SequenceRegion(contig, start, end);
            }

            @Override
            String encode(Object object) {
                if (object == null) {
                    throw new TribbleException("Cannot encode null in SEQUENCE_REGION_DIRECTIVE");
                }
                if (!(object instanceof SequenceRegion)) {
                    throw new TribbleException("Cannot encode object of type " + String.valueOf(object.getClass()) + " in SEQUENCE_REGION_DIRECTIVE");
                }
                SequenceRegion sequenceRegion = (SequenceRegion)object;
                return "##sequence-region " + Gff3Writer.encodeString(sequenceRegion.getContig()) + " " + sequenceRegion.getStart() + " " + sequenceRegion.getEnd();
            }
        }
        ,
        FLUSH_DIRECTIVE("###$"){

            @Override
            String encode(Object object) {
                return "###";
            }
        }
        ,
        FASTA_DIRECTIVE("##FASTA$"){

            @Override
            String encode(Object object) {
                return "##FASTA";
            }
        };

        protected final Pattern regexPattern;

        private Gff3Directive(String regex) {
            this.regexPattern = Pattern.compile(regex);
        }

        public static Gff3Directive toDirective(String line) {
            for (Gff3Directive directive : Gff3Directive.values()) {
                if (!directive.regexPattern.matcher(line).matches()) continue;
                return directive;
            }
            return null;
        }

        protected Object decode(String line) throws IOException {
            return null;
        }

        abstract String encode(Object var1);
    }
}

