/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gff;

import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.gff.Gff3Codec;
import htsjdk.tribble.gff.Gff3Feature;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Gff3Writer
implements Closeable {
    private final OutputStream out;
    private static final String version = "3.1.25";

    public Gff3Writer(Path path) throws IOException {
        if (FileExtensions.GFF3.stream().noneMatch(e -> path.toString().endsWith((String)e))) {
            throw new TribbleException("File " + String.valueOf(path) + " does not have extension consistent with gff3");
        }
        OutputStream outputStream = IOUtil.hasGzipFileExtension(path) ? new BlockCompressedOutputStream(path.toFile()) : Files.newOutputStream(path, new OpenOption[0]);
        this.out = new BufferedOutputStream(outputStream);
        this.initialize();
    }

    public Gff3Writer(OutputStream stream) {
        this.out = stream;
        this.initialize();
    }

    private void initialize() {
        try {
            this.writeWithNewLine(Gff3Codec.Gff3Directive.VERSION3_DIRECTIVE.encode(version));
        }
        catch (IOException ex) {
            throw new TribbleException("Error writing version directive", ex);
        }
    }

    private void writeWithNewLine(String txt) throws IOException {
        this.out.write(txt.getBytes());
        this.out.write(10);
    }

    private void tryToWrite(String string) {
        try {
            this.out.write(string.getBytes());
        }
        catch (IOException ex) {
            throw new TribbleException("Error writing out string " + string, ex);
        }
    }

    private void writeFirstEightFields(Gff3Feature feature) throws IOException {
        this.writeJoinedByDelimiter('\t', this::tryToWrite, Arrays.asList(this.escapeString(feature.getContig()), this.escapeString(feature.getSource()), this.escapeString(feature.getType()), Integer.toString(feature.getStart()), Integer.toString(feature.getEnd()), feature.getScore() < 0.0 ? "." : Double.toString(feature.getScore()), feature.getStrand().toString(), feature.getPhase() < 0 ? "." : Integer.toString(feature.getPhase())));
    }

    void writeAttributes(Map<String, List<String>> attributes) throws IOException {
        if (attributes.isEmpty()) {
            this.out.write(".".getBytes());
        }
        this.writeJoinedByDelimiter(';', e -> this.writeKeyValuePair((String)e.getKey(), (List)e.getValue()), attributes.entrySet());
    }

    void writeKeyValuePair(String key, List<String> values) {
        try {
            this.tryToWrite(key);
            this.out.write(61);
            this.writeJoinedByDelimiter(',', v -> this.tryToWrite(this.escapeString((String)v)), values);
        }
        catch (IOException ex) {
            throw new TribbleException("error writing out key value pair " + key + " " + String.valueOf(values));
        }
    }

    private <T> void writeJoinedByDelimiter(char delimiter, Consumer<T> consumer, Collection<T> fields) throws IOException {
        boolean isNotFirstField = false;
        for (T field : fields) {
            if (isNotFirstField) {
                this.out.write(delimiter);
            } else {
                isNotFirstField = true;
            }
            consumer.accept(field);
        }
    }

    public void addFeature(Gff3Feature feature) throws IOException {
        this.writeFirstEightFields(feature);
        this.out.write(9);
        this.writeAttributes(feature.getAttributes());
        this.out.write(10);
    }

    protected String escapeString(String s2) {
        return Gff3Writer.encodeString(s2);
    }

    static String encodeString(String s2) {
        try {
            return URLEncoder.encode(s2, "UTF-8").replace("+", " ");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TribbleException("Encoding failure", ex);
        }
    }

    public void addDirective(Gff3Codec.Gff3Directive directive, Object object) throws IOException {
        if (directive == Gff3Codec.Gff3Directive.VERSION3_DIRECTIVE) {
            throw new TribbleException("VERSION3_DIRECTIVE is automatically added and should not be added manually.");
        }
        this.writeWithNewLine(directive.encode(object));
    }

    public void addDirective(Gff3Codec.Gff3Directive directive) throws IOException {
        if (directive == Gff3Codec.Gff3Directive.VERSION3_DIRECTIVE) {
            throw new TribbleException("VERSION3_DIRECTIVE is automatically added and should not be added manually.");
        }
        this.addDirective(directive, null);
    }

    public void addComment(String comment) throws IOException {
        this.out.write("#".getBytes());
        this.writeWithNewLine(comment);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

