/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantJEXLContext;
import java.util.HashMap;
import java.util.Map;

public class GenotypeJEXLContext
extends VariantJEXLContext {
    private Genotype g;
    private static Map<String, AttributeGetter> attributes = new HashMap<String, AttributeGetter>();

    public GenotypeJEXLContext(VariantContext vc, Genotype g2) {
        super(vc);
        this.g = g2;
    }

    @Override
    public Object get(String name) {
        if (attributes.containsKey(name)) {
            return attributes.get(name).get(this.g);
        }
        if (this.g.hasAnyAttribute(name)) {
            return this.g.getAnyAttribute(name);
        }
        if (this.g.getFilters() != null && this.g.getFilters().contains(name)) {
            return "1";
        }
        return super.get(name);
    }

    static {
        attributes.put("g", g2 -> g2);
        attributes.put("GT", Genotype::getGenotypeString);
        attributes.put("isHom", g2 -> g2.isHom() ? "1" : "0");
        attributes.put("isHomRef", g2 -> g2.isHomRef() ? "1" : "0");
        attributes.put("isHet", g2 -> g2.isHet() ? "1" : "0");
        attributes.put("isHomVar", g2 -> g2.isHomVar() ? "1" : "0");
        attributes.put("isCalled", g2 -> g2.isCalled() ? "1" : "0");
        attributes.put("isNoCall", g2 -> g2.isNoCall() ? "1" : "0");
        attributes.put("isMixed", g2 -> g2.isMixed() ? "1" : "0");
        attributes.put("isAvailable", g2 -> g2.isAvailable() ? "1" : "0");
        attributes.put("isPassFT", g2 -> g2.isFiltered() ? "0" : "1");
        attributes.put("FT", g2 -> g2.isFiltered() ? g2.getFilters() : "PASS");
        attributes.put("GQ", Genotype::getGQ);
    }

    private static interface AttributeGetter {
        public Object get(Genotype var1);
    }
}

