/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.bcf2.BCF2Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class BCF2Encoder {
    public static final int WRITE_BUFFER_INITIAL_SIZE = 16384;
    private ByteArrayOutputStream encodeStream = new ByteArrayOutputStream(16384);

    public byte[] getRecordBytes() {
        byte[] bytes = this.encodeStream.toByteArray();
        this.encodeStream.reset();
        return bytes;
    }

    public final void encodeTypedMissing(BCF2Type type) throws IOException {
        this.encodeType(0, type);
    }

    public final void encodeTyped(Object value, BCF2Type type) throws IOException {
        if (value == null) {
            this.encodeTypedMissing(type);
        } else {
            switch (type) {
                case INT8: 
                case INT16: 
                case INT32: {
                    this.encodeTypedInt((Integer)value, type);
                    break;
                }
                case FLOAT: {
                    this.encodeTypedFloat((Double)value);
                    break;
                }
                case CHAR: {
                    this.encodeTypedString((String)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal type encountered " + String.valueOf((Object)type));
                }
            }
        }
    }

    public final void encodeTypedInt(int v) throws IOException {
        BCF2Type type = BCF2Utils.determineIntegerType(v);
        this.encodeTypedInt(v, type);
    }

    public final void encodeTypedInt(int v, BCF2Type type) throws IOException {
        this.encodeType(1, type);
        this.encodeRawInt(v, type);
    }

    public final void encodeTypedString(String s2) throws IOException {
        this.encodeTypedString(s2.getBytes());
    }

    public final void encodeTypedString(byte[] s2) throws IOException {
        if (s2 == null) {
            this.encodeType(0, BCF2Type.CHAR);
        } else {
            this.encodeType(s2.length, BCF2Type.CHAR);
            for (int i = 0; i < s2.length; ++i) {
                this.encodeRawChar(s2[i]);
            }
        }
    }

    public final void encodeTypedFloat(double d) throws IOException {
        this.encodeType(1, BCF2Type.FLOAT);
        this.encodeRawFloat(d);
    }

    public final void encodeTyped(List<? extends Object> v, BCF2Type type) throws IOException {
        if (type == BCF2Type.CHAR && !v.isEmpty()) {
            String s2 = BCF2Utils.collapseStringList(v);
            v = this.stringToBytes(s2);
        }
        this.encodeType(v.size(), type);
        this.encodeRawValues(v, type);
    }

    public final <T> void encodeRawValues(Collection<T> v, BCF2Type type) throws IOException {
        for (T v1 : v) {
            this.encodeRawValue(v1, type);
        }
    }

    public final <T> void encodeRawValue(T value, BCF2Type type) throws IOException {
        try {
            if (value == type.getMissingJavaValue()) {
                this.encodeRawMissingValue(type);
            } else {
                switch (type) {
                    case INT8: 
                    case INT16: 
                    case INT32: {
                        this.encodeRawBytes((Integer)value, type);
                        break;
                    }
                    case FLOAT: {
                        this.encodeRawFloat((Double)value);
                        break;
                    }
                    case CHAR: {
                        this.encodeRawChar((Byte)value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal type encountered " + String.valueOf((Object)type));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw new ClassCastException("BUG: invalid type cast to " + String.valueOf((Object)type) + " from " + String.valueOf(value));
        }
    }

    public final void encodeRawMissingValue(BCF2Type type) throws IOException {
        this.encodeRawBytes(type.getMissingBytes(), type);
    }

    public final void encodeRawMissingValues(int size, BCF2Type type) throws IOException {
        for (int i = 0; i < size; ++i) {
            this.encodeRawMissingValue(type);
        }
    }

    public final void encodeRawChar(byte c) throws IOException {
        this.encodeStream.write(c);
    }

    public final void encodeRawFloat(double value) throws IOException {
        this.encodeRawBytes(Float.floatToIntBits((float)value), BCF2Type.FLOAT);
    }

    public final void encodeType(int size, BCF2Type type) throws IOException {
        if (size <= 14) {
            byte typeByte = BCF2Utils.encodeTypeDescriptor(size, type);
            this.encodeStream.write(typeByte);
        } else {
            byte typeByte = BCF2Utils.encodeTypeDescriptor(15, type);
            this.encodeStream.write(typeByte);
            this.encodeTypedInt(size);
        }
    }

    public final void encodeRawInt(int value, BCF2Type type) throws IOException {
        type.write(value, this.encodeStream);
    }

    public final void encodeRawBytes(int value, BCF2Type type) throws IOException {
        type.write(value, this.encodeStream);
    }

    public void encodeRawString(String s2, int sizeToWrite) throws IOException {
        byte[] bytes = s2.getBytes();
        for (int i = 0; i < sizeToWrite; ++i) {
            if (i < bytes.length) {
                this.encodeRawChar(bytes[i]);
                continue;
            }
            this.encodeRawMissingValue(BCF2Type.CHAR);
        }
    }

    public final BCF2Type encode(Object o) throws IOException {
        if (o == null) {
            throw new IllegalArgumentException("Generic encode cannot deal with null values");
        }
        if (o instanceof List) {
            BCF2Type type = this.determineBCFType(((List)o).get(0));
            this.encodeTyped((List)o, type);
            return type;
        }
        BCF2Type type = this.determineBCFType(o);
        this.encodeTyped(o, type);
        return type;
    }

    private final BCF2Type determineBCFType(Object arg) {
        Object toType;
        Object object = toType = arg instanceof List ? ((List)arg).get(0) : arg;
        if (toType instanceof Integer) {
            return BCF2Utils.determineIntegerType((Integer)toType);
        }
        if (toType instanceof String) {
            return BCF2Type.CHAR;
        }
        if (toType instanceof Double) {
            return BCF2Type.FLOAT;
        }
        throw new IllegalArgumentException("No native encoding for Object of type " + arg.getClass().getSimpleName());
    }

    private final List<Byte> stringToBytes(String v) throws IOException {
        if (v == null || v.equals("")) {
            return Collections.emptyList();
        }
        byte[] bytes = v.getBytes();
        ArrayList<Byte> l = new ArrayList<Byte>(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            l.add(bytes[i]);
        }
        return l;
    }
}

