/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.bcf2.BCF2Utils;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.BCF2Encoder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BCF2FieldEncoder {
    final VCFCompoundHeaderLine headerLine;
    final BCF2Type staticType;
    final int dictionaryOffset;
    final BCF2Type dictionaryOffsetType;

    private BCF2FieldEncoder(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict, BCF2Type staticType) {
        this.headerLine = headerLine;
        this.staticType = staticType;
        Integer offset = dict.get(this.getField());
        if (offset == null) {
            throw new IllegalStateException("Format error: could not find string " + this.getField() + " in header as required by BCF");
        }
        this.dictionaryOffset = offset;
        this.dictionaryOffsetType = BCF2Utils.determineIntegerType(offset);
    }

    public final String getField() {
        return this.headerLine.getID();
    }

    public final void writeFieldKey(BCF2Encoder encoder) throws IOException {
        encoder.encodeTypedInt(this.dictionaryOffset, this.dictionaryOffsetType);
    }

    public String toString() {
        return "BCF2FieldEncoder for " + this.getField() + " with count " + String.valueOf((Object)this.getCountType()) + " encoded with " + this.getClass().getSimpleName();
    }

    protected final VCFHeaderLineCount getCountType() {
        return this.headerLine.getCountType();
    }

    public boolean hasConstantNumElements() {
        return this.getCountType() == VCFHeaderLineCount.INTEGER;
    }

    public boolean hasValueDeterminedNumElements() {
        return this.getCountType() == VCFHeaderLineCount.UNBOUNDED;
    }

    public boolean hasContextDeterminedNumElements() {
        return !this.hasConstantNumElements() && !this.hasValueDeterminedNumElements();
    }

    public int numElements() {
        return this.headerLine.getCount();
    }

    public int numElements(Object value) {
        return this.numElementsFromValue(value);
    }

    public int numElements(VariantContext vc) {
        return this.headerLine.getCount(vc);
    }

    public final int numElements(VariantContext vc, Object value) {
        if (this.hasConstantNumElements()) {
            return this.numElements();
        }
        if (this.hasContextDeterminedNumElements()) {
            return this.numElements(vc);
        }
        return this.numElements(value);
    }

    protected int numElementsFromValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof List) {
            return ((List)value).size();
        }
        return 1;
    }

    public final boolean isStaticallyTyped() {
        return !this.isDynamicallyTyped();
    }

    public final boolean isDynamicallyTyped() {
        return this.staticType == null;
    }

    public final BCF2Type getType(Object value) {
        return this.isDynamicallyTyped() ? this.getDynamicType(value) : this.getStaticType();
    }

    public final BCF2Type getStaticType() {
        return this.staticType;
    }

    public BCF2Type getDynamicType(Object value) {
        throw new IllegalStateException("BUG: cannot get dynamic type for statically typed BCF2 field " + this.getField());
    }

    public abstract void encodeValue(BCF2Encoder var1, Object var2, BCF2Type var3, int var4) throws IOException;

    public static class GenericInts
    extends BCF2FieldEncoder {
        public GenericInts(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, null);
        }

        @Override
        public BCF2Type getDynamicType(Object value) {
            return value == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType(BCF2Utils.toList(Integer.class, value));
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            for (Integer i : BCF2Utils.toList(Integer.class, value)) {
                if (i == null) continue;
                encoder.encodeRawInt(i, type);
                ++count;
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class AtomicInt
    extends BCF2FieldEncoder {
        public AtomicInt(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, null);
        }

        @Override
        public BCF2Type getDynamicType(Object value) {
            return value == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType((Integer)value);
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            if (value != null) {
                encoder.encodeRawInt((Integer)value, type);
                ++count;
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class IntArray
    extends BCF2FieldEncoder {
        public IntArray(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, null);
        }

        @Override
        protected int numElementsFromValue(Object value) {
            return value == null ? 0 : ((int[])value).length;
        }

        @Override
        public BCF2Type getDynamicType(Object value) {
            return value == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType((int[])value);
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            if (value != null) {
                for (int i : (int[])value) {
                    encoder.encodeRawInt(i, type);
                    ++count;
                }
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class Float
    extends BCF2FieldEncoder {
        final boolean isAtomic = this.hasConstantNumElements() && this.numElements() == 1;

        public Float(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, BCF2Type.FLOAT);
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            if (this.isAtomic) {
                if (value != null) {
                    encoder.encodeRawFloat((Double)value);
                    ++count;
                }
            } else {
                List<Double> doubles = BCF2Utils.toList(Double.class, value);
                for (Double d : doubles) {
                    if (d == null) continue;
                    encoder.encodeRawFloat(d);
                    ++count;
                }
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class Flag
    extends BCF2FieldEncoder {
        public Flag(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, BCF2Type.INT8);
            if (!headerLine.isFixedCount() || headerLine.getCount() != 0) {
                throw new IllegalStateException("Flag encoder only supports atomic flags for field " + this.getField());
            }
        }

        @Override
        public int numElements() {
            return 1;
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            encoder.encodeRawBytes(1, this.getStaticType());
        }
    }

    public static class StringOrCharacter
    extends BCF2FieldEncoder {
        public StringOrCharacter(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, BCF2Type.CHAR);
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            String s2 = this.javaStringToBCF2String(value);
            encoder.encodeRawString(s2, Math.max(s2.length(), minValues));
        }

        @Override
        public boolean hasConstantNumElements() {
            return false;
        }

        @Override
        public boolean hasContextDeterminedNumElements() {
            return false;
        }

        @Override
        public boolean hasValueDeterminedNumElements() {
            return true;
        }

        @Override
        protected int numElementsFromValue(Object value) {
            return value == null ? 0 : this.javaStringToBCF2String(value).length();
        }

        private String javaStringToBCF2String(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof List) {
                List l = (List)value;
                return BCF2Utils.collapseStringList(l);
            }
            if (value.getClass().isArray()) {
                ArrayList<String> l = new ArrayList<String>();
                Collections.addAll(l, (String[])value);
                return BCF2Utils.collapseStringList(l);
            }
            return (String)value;
        }
    }
}

