/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.PriorityBlockingQueue;

@Deprecated
abstract class SortingVariantContextWriterBase
implements VariantContextWriter {
    private final VariantContextWriter innerWriter;
    private final Queue<VCFRecord> queue;
    protected Integer mostUpstreamWritableLoc;
    protected static final int BEFORE_MOST_UPSTREAM_LOC = 0;
    private final Set<String> finishedChromosomes;
    private final boolean takeOwnershipOfInner;

    public SortingVariantContextWriterBase(VariantContextWriter innerWriter, boolean takeOwnershipOfInner) {
        this.innerWriter = innerWriter;
        this.finishedChromosomes = new TreeSet<String>();
        this.takeOwnershipOfInner = takeOwnershipOfInner;
        this.queue = new PriorityBlockingQueue<VCFRecord>(50, new VariantContextComparator());
        this.mostUpstreamWritableLoc = 0;
    }

    public SortingVariantContextWriterBase(VariantContextWriter innerWriter) {
        this(innerWriter, false);
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.innerWriter.writeHeader(header);
    }

    @Override
    public void close() {
        this.stopWaitingToSort();
        if (this.takeOwnershipOfInner) {
            this.innerWriter.close();
        }
    }

    @Override
    public synchronized void add(VariantContext vc) {
        VCFRecord firstRec = this.queue.peek();
        if (firstRec != null && !vc.getContig().equals(firstRec.vc.getContig())) {
            if (this.finishedChromosomes.contains(vc.getContig())) {
                throw new IllegalArgumentException("Added a record at " + vc.getContig() + ":" + vc.getStart() + ", but already finished with chromosome" + vc.getContig());
            }
            this.finishedChromosomes.add(firstRec.vc.getContig());
            this.stopWaitingToSort();
        }
        this.noteCurrentRecord(vc);
        this.queue.add(new VCFRecord(vc));
        this.emitSafeRecords();
    }

    @Override
    public void setHeader(VCFHeader header) {
        this.innerWriter.setHeader(header);
    }

    public String toString() {
        return this.getClass().getName();
    }

    private synchronized void stopWaitingToSort() {
        this.emitRecords(true);
        this.mostUpstreamWritableLoc = 0;
    }

    protected synchronized void emitSafeRecords() {
        this.emitRecords(false);
    }

    protected void noteCurrentRecord(VariantContext vc) {
        if (this.mostUpstreamWritableLoc != null && vc.getStart() < this.mostUpstreamWritableLoc) {
            throw new IllegalArgumentException("Permitted to write any record upstream of position " + this.mostUpstreamWritableLoc + ", but a record at " + vc.getContig() + ":" + vc.getStart() + " was just added.");
        }
    }

    private synchronized void emitRecords(boolean emitUnsafe) {
        while (!this.queue.isEmpty()) {
            VCFRecord firstRec = this.queue.peek();
            if (!emitUnsafe && this.mostUpstreamWritableLoc != null && firstRec.vc.getStart() > this.mostUpstreamWritableLoc) break;
            this.queue.poll();
            this.innerWriter.add(firstRec.vc);
        }
    }

    private static class VariantContextComparator
    implements Comparator<VCFRecord>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private VariantContextComparator() {
        }

        @Override
        public int compare(VCFRecord r1, VCFRecord r2) {
            return r1.vc.getStart() - r2.vc.getStart();
        }
    }

    private static class VCFRecord {
        public VariantContext vc;

        public VCFRecord(VariantContext vc) {
            this.vc = vc;
        }
    }
}

