/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Doclet;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.BarclayDocletOption;
import org.broadinstitute.barclay.help.BashTabCompletionDocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.HelpDoclet;

public class BashTabCompletionDoclet
extends HelpDoclet {
    private static final String CALLER_SCRIPT_NAME = "-caller-script-name";
    private static final String CALLER_SCRIPT_PREFIX_LEGAL_ARGS = "-caller-pre-legal-args";
    private static final String CALLER_SCRIPT_PREFIX_ARG_VALUE_TYPES = "-caller-pre-arg-val-types";
    private static final String CALLER_SCRIPT_PREFIX_MUTEX_ARGS = "-caller-pre-mutex-args";
    private static final String CALLER_SCRIPT_PREFIX_ALIAS_ARGS = "-caller-pre-alias-args";
    private static final String CALLER_SCRIPT_PREFIX_ARG_MIN_OCCURRENCES = "-caller-pre-arg-min-occurs";
    private static final String CALLER_SCRIPT_PREFIX_ARG_MAX_OCCURRENCES = "-caller-pre-arg-max-occurs";
    private static final String CALLER_SCRIPT_POSTFIX_LEGAL_ARGS = "-caller-post-legal-args";
    private static final String CALLER_SCRIPT_POSTFIX_ARG_VALUE_TYPES = "-caller-post-arg-val-types";
    private static final String CALLER_SCRIPT_POSTFIX_MUTEX_ARGS = "-caller-post-mutex-args";
    private static final String CALLER_SCRIPT_POSTFIX_ALIAS_ARGS = "-caller-post-alias-args";
    private static final String CALLER_SCRIPT_POSTFIX_ARG_MIN_OCCURRENCES = "-caller-post-arg-min-occurs";
    private static final String CALLER_SCRIPT_POSTFIX_ARG_MAX_OCCURRENCES = "-caller-post-arg-max-occurs";
    private String callerScriptName = null;
    private String callerScriptPrefixLegalArgs = "";
    private String callerScriptPrefixArgValueTypes = "";
    private String callerScriptPrefixMutexArgs = "";
    private String callerScriptPrefixAliasArgs = "";
    private String callerScriptPrefixMinOccurrences = "";
    private String callerScriptPrefixMaxOccurrences = "";
    private String callerScriptPostfixLegalArgs = "";
    private String callerScriptPostfixArgValueTypes = "";
    private String callerScriptPostfixMutexArgs = "";
    private String callerScriptPostfixAliasArgs = "";
    private String callerScriptPostfixMinOccurrences = "";
    private String callerScriptPostfixMaxOccurrences = "";
    private boolean hasCallerScriptPostfixArgs = false;

    private String quoteEachWord(String sentence) {
        return this.quoteEachWord(sentence, " ");
    }

    private String quoteEachWord(String sentence, String sep) {
        return Stream.of(sentence.split(sep)).map(s2 -> String.format("\"%s\"", s2)).collect(Collectors.joining(sep));
    }

    @Override
    protected void validateDocletStartingState() {
        if (this.callerScriptName == null) {
            throw new RuntimeException("ERROR: You must specify a caller script name using the option: -caller-script-name");
        }
    }

    public Set<Doclet.Option> getSupportedOptions() {
        LinkedHashSet<Doclet.Option> tabCompletionOptions = new LinkedHashSet<Doclet.Option>(){
            {
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_NAME){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        int lastDotIndex = arguments.get(0).lastIndexOf(46);
                        BashTabCompletionDoclet.this.callerScriptName = lastDotIndex != -1 ? arguments.get(0).substring(0, lastDotIndex) : arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_PREFIX_LEGAL_ARGS){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPrefixLegalArgs = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_PREFIX_ARG_VALUE_TYPES){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPrefixArgValueTypes = BashTabCompletionDoclet.this.quoteEachWord(arguments.get(0));
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_PREFIX_MUTEX_ARGS){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPrefixMutexArgs = BashTabCompletionDoclet.this.quoteEachWord(arguments.get(0));
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_PREFIX_ALIAS_ARGS){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPrefixAliasArgs = BashTabCompletionDoclet.this.quoteEachWord(arguments.get(0));
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_PREFIX_ARG_MIN_OCCURRENCES){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPrefixMinOccurrences = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_PREFIX_ARG_MAX_OCCURRENCES){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPrefixMaxOccurrences = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_POSTFIX_LEGAL_ARGS){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPostfixLegalArgs = arguments.get(0);
                        BashTabCompletionDoclet.this.hasCallerScriptPostfixArgs = !BashTabCompletionDoclet.this.callerScriptPostfixLegalArgs.isEmpty();
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_POSTFIX_ARG_VALUE_TYPES){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPostfixArgValueTypes = BashTabCompletionDoclet.this.quoteEachWord(arguments.get(0));
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_POSTFIX_MUTEX_ARGS){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPostfixMutexArgs = BashTabCompletionDoclet.this.quoteEachWord(arguments.get(0));
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_POSTFIX_ALIAS_ARGS){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPostfixAliasArgs = BashTabCompletionDoclet.this.quoteEachWord(arguments.get(0));
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_POSTFIX_ARG_MIN_OCCURRENCES){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPostfixMinOccurrences = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption(BashTabCompletionDoclet.CALLER_SCRIPT_POSTFIX_ARG_MAX_OCCURRENCES){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        BashTabCompletionDoclet.this.callerScriptPostfixMaxOccurrences = arguments.get(0);
                        return true;
                    }
                });
            }
        };
        tabCompletionOptions.addAll(super.getSupportedOptions());
        return tabCompletionOptions;
    }

    @Override
    public boolean includeInDocs(DocumentedFeature documentedFeature, Class<?> clazz) {
        return super.includeInDocs(documentedFeature, clazz) && clazz.getAnnotation(CommandLineProgramProperties.class) != null;
    }

    @Override
    public DocWorkUnit createWorkUnit(Element targetElement, Class<?> clazz, DocumentedFeature documentedFeature) {
        return new DocWorkUnit(new BashTabCompletionDocWorkUnitHandler(this), targetElement, clazz, documentedFeature);
    }

    @Override
    protected void processWorkUnitTemplate(Configuration cfg, DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
    }

    @Override
    protected void processIndexTemplate(Configuration cfg, List<DocWorkUnit> workUnitList, List<Map<String, String>> groupMaps) throws IOException {
        HashMap propertiesMap = new HashMap();
        this.workUnits.stream().forEach(workUnit -> propertiesMap.put(workUnit.getName(), workUnit.getRootMap()));
        HashMap rootMap = new HashMap();
        rootMap.put("tools", propertiesMap);
        HashMap<String, String> callerScriptOptionsMap = new HashMap<String, String>();
        callerScriptOptionsMap.put("callerScriptName", this.callerScriptName);
        callerScriptOptionsMap.put("callerScriptPrefixLegalArgs", this.callerScriptPrefixLegalArgs);
        callerScriptOptionsMap.put("callerScriptPrefixArgValueTypes", this.callerScriptPrefixArgValueTypes);
        callerScriptOptionsMap.put("callerScriptPrefixMutexArgs", this.callerScriptPrefixMutexArgs);
        callerScriptOptionsMap.put("callerScriptPrefixAliasArgs", this.callerScriptPrefixAliasArgs);
        callerScriptOptionsMap.put("callerScriptPrefixMinOccurrences", this.callerScriptPrefixMinOccurrences);
        callerScriptOptionsMap.put("callerScriptPrefixMaxOccurrences", this.callerScriptPrefixMaxOccurrences);
        callerScriptOptionsMap.put("callerScriptPostfixLegalArgs", this.callerScriptPostfixLegalArgs);
        callerScriptOptionsMap.put("callerScriptPostfixArgValueTypes", this.callerScriptPostfixArgValueTypes);
        callerScriptOptionsMap.put("callerScriptPostfixMutexArgs", this.callerScriptPostfixMutexArgs);
        callerScriptOptionsMap.put("callerScriptPostfixAliasArgs", this.callerScriptPostfixAliasArgs);
        callerScriptOptionsMap.put("callerScriptPostfixMinOccurrences", this.callerScriptPostfixMinOccurrences);
        callerScriptOptionsMap.put("callerScriptPostfixMaxOccurrences", this.callerScriptPostfixMaxOccurrences);
        if (this.hasCallerScriptPostfixArgs) {
            callerScriptOptionsMap.put("hasCallerScriptPostfixArgs", "true");
        } else {
            callerScriptOptionsMap.put("hasCallerScriptPostfixArgs", "false");
        }
        rootMap.put("callerScriptOptions", callerScriptOptionsMap);
        Template template = cfg.getTemplate(this.getIndexTemplateName());
        File indexFile = new File(this.getDestinationDir(), this.getIndexBaseFileName() + "." + this.getIndexFileExtension());
        try (FileOutputStream fileOutStream = new FileOutputStream(indexFile);
             OutputStreamWriter outWriter = new OutputStreamWriter(fileOutStream);){
            template.process(rootMap, outWriter);
        }
        catch (TemplateException e) {
            throw new DocException("Freemarker Template Exception during documentation index creation", e);
        }
    }

    @Override
    public String getIndexTemplateName() {
        return "bash-completion.ftl";
    }

    @Override
    public String getIndexBaseFileName() {
        return this.callerScriptName + "-completion";
    }
}

