/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.CommandLinePluginProvider;
import org.broadinstitute.barclay.argparser.CommandLineProgramGroup;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.NamedArgumentDefinition;
import org.broadinstitute.barclay.argparser.PositionalArgumentDefinition;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocletUtils;
import org.broadinstitute.barclay.help.GSONArgument;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.scanners.JavaLanguageModelScanners;
import org.broadinstitute.barclay.utils.Utils;

public class DefaultDocWorkUnitHandler
extends DocWorkUnitHandler {
    protected static final Logger logger = LogManager.getLogger(DefaultDocWorkUnitHandler.class);
    private static final String NAME_FOR_POSITIONAL_ARGS = "[NA - Positional]";
    private static final String DEFAULT_FREEMARKER_TEMPLATE_NAME = "generic.html.ftl";

    public DefaultDocWorkUnitHandler(HelpDoclet doclet) {
        super(doclet);
    }

    @Override
    public String getTemplateName(DocWorkUnit workUnit) {
        return DEFAULT_FREEMARKER_TEMPLATE_NAME;
    }

    @Override
    public String getSummaryForWorkUnit(DocWorkUnit workUnit) {
        String summary = workUnit.getDocumentedFeature().summary();
        if (summary == null || summary.isEmpty()) {
            CommandLineProgramProperties commandLineProperties = workUnit.getCommandLineProperties();
            if (commandLineProperties != null) {
                summary = commandLineProperties.oneLineSummary();
            }
            if (summary == null || summary.isEmpty()) {
                summary = JavaLanguageModelScanners.getDocCommentFirstSentence(this.getDoclet().getDocletEnv(), workUnit.getDocElement());
            }
        }
        return summary == null ? "" : summary;
    }

    @Override
    public String getGroupNameForWorkUnit(DocWorkUnit workUnit) {
        String groupName = workUnit.getDocumentedFeature().groupName();
        if (groupName == null || groupName.isEmpty()) {
            CommandLineProgramGroup clpGroup = workUnit.getCommandLineProgramGroup();
            if (clpGroup != null) {
                groupName = clpGroup.getName();
            }
            if (groupName == null || groupName.isEmpty()) {
                logger.warn("No group name declared for: " + workUnit.getClazz().getCanonicalName());
                groupName = "";
            }
        }
        return groupName;
    }

    @Override
    public String getGroupSummaryForWorkUnit(DocWorkUnit workUnit) {
        String groupSummary = workUnit.getDocumentedFeature().groupSummary();
        CommandLineProgramGroup clpGroup = workUnit.getCommandLineProgramGroup();
        if (groupSummary == null || groupSummary.isEmpty()) {
            if (clpGroup != null) {
                groupSummary = clpGroup.getDescription();
            }
            if (groupSummary == null || groupSummary.isEmpty()) {
                logger.warn("No group summary declared for: " + workUnit.getClazz().getCanonicalName());
                groupSummary = "";
            }
        }
        return groupSummary;
    }

    protected String getDescription(DocWorkUnit currentWorkUnit) {
        return JavaLanguageModelScanners.getDocComment(this.getDoclet().getDocletEnv(), currentWorkUnit.getDocElement());
    }

    @Override
    public void processWorkUnit(DocWorkUnit workUnit, List<Map<String, String>> featureMaps, List<Map<String, String>> groupMaps) {
        CommandLineArgumentParser clp = null;
        List<Object> pluginDescriptors = new ArrayList();
        try {
            Object argumentContainer = workUnit.getClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (argumentContainer instanceof CommandLinePluginProvider) {
                pluginDescriptors = ((CommandLinePluginProvider)argumentContainer).getPluginDescriptors();
                clp = new CommandLineArgumentParser(argumentContainer, pluginDescriptors, Collections.emptySet());
            } else {
                clp = new CommandLineArgumentParser(argumentContainer);
            }
            workUnit.setProperty("groups", groupMaps);
            workUnit.setProperty("data", featureMaps);
            this.addHighLevelBindings(workUnit);
            this.addCommandLineArgumentBindings(workUnit, clp);
            this.addDefaultPlugins(workUnit, pluginDescriptors);
            this.addExtraDocsBindings(workUnit);
            this.addCustomBindings(workUnit);
        }
        catch (NoSuchMethodException e) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("DocumentedFeature class %s does not have the required no argument constructor", workUnit.getClazz()), e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("DocumentedFeature class %s cannot be instantiated", workUnit.getClazz()), e);
        }
    }

    protected void addHighLevelBindings(DocWorkUnit workUnit) {
        workUnit.setProperty("name", workUnit.getName());
        workUnit.setProperty("group", workUnit.getGroupName());
        workUnit.setProperty("summary", workUnit.getSummary());
        workUnit.setProperty("beta", workUnit.isBetaFeature());
        workUnit.setProperty("experimental", workUnit.isExperimentalFeature());
        workUnit.setProperty("deprecated", workUnit.isDeprecatedFeature());
        workUnit.setProperty("deprecationDetail", workUnit.getDeprecationDetail());
        workUnit.setProperty("description", this.getDescription(workUnit));
        workUnit.setProperty("version", this.getDoclet().getBuildVersion());
        workUnit.setProperty("timestamp", this.getDoclet().getBuildTimeStamp());
    }

    protected void addCustomBindings(DocWorkUnit currentWorkUnit) {
        String tagFilterPrefix = this.getTagPrefix();
        if (tagFilterPrefix != null) {
            Map<String, List<String>> parts = JavaLanguageModelScanners.getUnknownInlineTags(this.getDoclet().getDocletEnv(), currentWorkUnit.getDocElement());
            parts.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(tagFilterPrefix.substring(1))).forEach(e -> currentWorkUnit.setProperty(((String)e.getKey()).substring(tagFilterPrefix.substring(1).length()), String.join((CharSequence)" ", (Iterable)e.getValue())));
        }
    }

    protected String getTagFilterPrefix() {
        return "";
    }

    protected void addExtraDocsBindings(DocWorkUnit currentWorkUnit) {
        ArrayList<1> extraDocsData = new ArrayList<1>();
        for (Class<?> extraDocClass : currentWorkUnit.getDocumentedFeature().extraDocs()) {
            final DocWorkUnit otherUnit = this.getDoclet().findWorkUnitForClass(extraDocClass);
            if (otherUnit == null) {
                String msg = String.format("An \"extradocs\" value (%s) was specified for (%s), but the target was not included in the source list for this javadoc run, or the target has no documentation.", extraDocClass, currentWorkUnit.getName());
                throw new DocException(msg);
            }
            extraDocsData.add(new HashMap<String, Object>(){
                static final long serialVersionUID = 0L;
                {
                    this.put("name", otherUnit.getName());
                    this.put("filename", otherUnit.getTargetFileName());
                }
            });
        }
        currentWorkUnit.setProperty("extradocs", extraDocsData);
    }

    protected void addCommandLineArgumentBindings(DocWorkUnit currentWorkUnit, CommandLineArgumentParser clp) {
        Map<String, List<Map<String, Object>>> argMap = this.createArgumentMap();
        currentWorkUnit.setProperty("arguments", argMap);
        if (clp != null) {
            this.processPositionalArguments(clp, argMap);
            clp.getNamedArgumentDefinitions().stream().forEach(argDef -> this.processNamedArgument(currentWorkUnit, argMap, (NamedArgumentDefinition)argDef));
            argMap.entrySet().stream().forEach(entry -> entry.setValue(this.sortArguments((List)entry.getValue())));
            ArrayList<GSONArgument> allGSONArgs = new ArrayList<GSONArgument>();
            for (Map<String, Object> detailMap : argMap.get("all")) {
                allGSONArgs.add(new GSONArgument(detailMap));
            }
            currentWorkUnit.setProperty("gson-arguments", allGSONArgs);
        }
    }

    private String getTagPrefix() {
        String customPrefix = this.getTagFilterPrefix();
        return customPrefix == null || customPrefix.length() == 0 ? null : "@" + customPrefix + ".";
    }

    protected void addDefaultPlugins(DocWorkUnit currentWorkUnit, List<? extends CommandLinePluginDescriptor<?>> pluginDescriptors) {
        for (CommandLinePluginDescriptor<?> descriptor : pluginDescriptors) {
            String descriptorName = descriptor.getDisplayName();
            HashSet defaultsForPlugins = new HashSet();
            currentWorkUnit.setProperty(descriptorName, defaultsForPlugins);
            for (Object plugin : descriptor.getDefaultInstances()) {
                HashMap<String, String> pluginDetails = new HashMap<String, String>();
                pluginDetails.put("name", plugin.getClass().getSimpleName());
                pluginDetails.put("filename", DocletUtils.phpFilenameForClass(plugin.getClass(), this.getDoclet().getOutputFileExtension()));
                defaultsForPlugins.add(pluginDetails);
            }
        }
    }

    protected void processNamedArgument(DocWorkUnit currentWorkUnit, Map<String, List<Map<String, Object>>> args, NamedArgumentDefinition argDef) {
        if (!(argDef.isControlledByPlugin() || argDef.isHidden() && !this.getDoclet().showHiddenFeatures())) {
            HashMap<String, Object> argMap = new HashMap<String, Object>();
            String commentText = this.getDocCommentForField(currentWorkUnit, argDef);
            String argKind = this.processNamedArgument(argMap, argDef, commentText);
            args.get(argKind).add(argMap);
            args.get("all").add(argMap);
            if (argDef.isDeprecated()) {
                args.get("deprecated").add(argMap);
            }
        }
    }

    private String getDocCommentForField(DocWorkUnit workUnit, NamedArgumentDefinition argDef) {
        String className;
        Class<?> containingClass;
        Element fieldElement = JavaLanguageModelScanners.getElementForField(this.getDoclet().getDocletEnv(), workUnit.getDocElement(), argDef.getUnderlyingField(), ElementKind.FIELD);
        if (fieldElement == null && (containingClass = argDef.getUnderlyingField().getDeclaringClass()) != null && (className = containingClass.getCanonicalName()) != null) {
            TypeElement classElement = this.getDoclet().getDocletEnv().getElementUtils().getTypeElement(className);
            fieldElement = JavaLanguageModelScanners.getElementForField(this.getDoclet().getDocletEnv(), classElement, argDef.getUnderlyingField(), ElementKind.FIELD);
        }
        String comment = "";
        if (fieldElement != null) {
            comment = JavaLanguageModelScanners.getDocCommentWithoutTags(this.getDoclet().getDocletEnv(), fieldElement);
        }
        return comment;
    }

    protected void processPositionalArguments(CommandLineArgumentParser clp, Map<String, List<Map<String, Object>>> args) {
        PositionalArgumentDefinition positionalArgDef = clp.getPositionalArgumentDefinition();
        if (positionalArgDef != null) {
            HashMap<String, Object> argBindings = new HashMap<String, Object>();
            argBindings.put("kind", "positional");
            argBindings.put("name", NAME_FOR_POSITIONAL_ARGS);
            argBindings.put("summary", positionalArgDef.getPositionalArgumentsAnnotation().doc());
            argBindings.put("fulltext", positionalArgDef.getPositionalArgumentsAnnotation().doc());
            argBindings.put("otherArgumentRequired", "NA");
            argBindings.put("synonyms", "NA");
            argBindings.put("exclusiveOf", "NA");
            argBindings.put("type", this.argumentTypeString(positionalArgDef.getUnderlyingField().getGenericType()));
            argBindings.put("options", this.getPossibleValues(positionalArgDef, "positional"));
            argBindings.put("attributes", "NA");
            argBindings.put("required", "yes");
            argBindings.put("minRecValue", "NA");
            argBindings.put("maxRecValue", "NA");
            argBindings.put("minValue", "NA");
            argBindings.put("maxValue", "NA");
            argBindings.put("defaultValue", "NA");
            argBindings.put("minElements", positionalArgDef.getPositionalArgumentsAnnotation().minElements());
            argBindings.put("maxElements", positionalArgDef.getPositionalArgumentsAnnotation().maxElements());
            argBindings.put("collection", positionalArgDef.isCollection());
            argBindings.put("deprecated", positionalArgDef.isDeprecated());
            if (positionalArgDef.isDeprecated()) {
                argBindings.put("deprecationDetail", positionalArgDef.getDeprecationDetail());
                args.get("deprecated").add(argBindings);
            }
            args.get("positional").add(argBindings);
            args.get("all").add(argBindings);
        }
    }

    private String docKindOfArg(NamedArgumentDefinition argumentDefinition) {
        if (argumentDefinition.isControlledByPlugin()) {
            return "dependent";
        }
        if (!argumentDefinition.isOptional()) {
            return "required";
        }
        if (argumentDefinition.isCommon()) {
            return "common";
        }
        if (argumentDefinition.isAdvanced()) {
            return "advanced";
        }
        if (argumentDefinition.isHidden()) {
            return "hidden";
        }
        return "optional";
    }

    private Map<String, List<Map<String, Object>>> createArgumentMap() {
        HashMap<String, List<Map<String, Object>>> args = new HashMap<String, List<Map<String, Object>>>();
        args.put("all", new ArrayList());
        args.put("common", new ArrayList());
        args.put("positional", new ArrayList());
        args.put("required", new ArrayList());
        args.put("optional", new ArrayList());
        args.put("advanced", new ArrayList());
        args.put("dependent", new ArrayList());
        args.put("hidden", new ArrayList());
        args.put("deprecated", new ArrayList());
        return args;
    }

    private List<Map<String, Object>> sortArguments(List<Map<String, Object>> unsorted) {
        Collections.sort(unsorted, new CompareArgumentsByName());
        return unsorted;
    }

    private Object prettyPrintValueString(Object value) {
        if (value instanceof String) {
            return value.equals("") ? "\"\"" : value;
        }
        return value.toString();
    }

    private Pair<String, String> displayNames(String s1, String s2) {
        s1 = s1 == null || s1.length() == 0 ? null : "-" + s1;
        String string = s2 = s2 == null || s2.length() == 0 ? null : "--" + s2;
        if (s1 == null) {
            return Pair.of(s2, null);
        }
        if (s2 == null) {
            return Pair.of(s1, null);
        }
        return Pair.of(s2, s1);
    }

    protected String argumentTypeString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ArrayList<String> subs = new ArrayList<String>();
            for (Type actualType : parameterizedType.getActualTypeArguments()) {
                subs.add(this.argumentTypeString(actualType));
            }
            return this.argumentTypeString(((ParameterizedType)type).getRawType()) + "[" + String.join((CharSequence)",", subs) + "]";
        }
        if (type instanceof GenericArrayType) {
            return this.argumentTypeString(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof WildcardType) {
            throw new RuntimeException("We don't support wildcards in arguments: " + type);
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        throw new DocException("Unknown type: " + type);
    }

    protected String processNamedArgument(Map<String, Object> argBindings, NamedArgumentDefinition argDef, String fieldCommentText) {
        Object fieldValue = argDef.getArgumentValue();
        argBindings.put("defaultValue", fieldValue == null ? argDef.getDefaultValueAsString() : this.prettyPrintValueString(fieldValue));
        if (fieldValue instanceof Number) {
            argBindings.put("minValue", argDef.getMinValue());
            argBindings.put("maxValue", argDef.getMaxValue());
            argBindings.put("minRecValue", argDef.getMinRecommendedValue() != Double.NEGATIVE_INFINITY ? argDef.getMinRecommendedValue() : "NA");
            argBindings.put("maxRecValue", argDef.getMaxRecommendedValue() != Double.POSITIVE_INFINITY ? argDef.getMaxRecommendedValue() : "NA");
        } else {
            argBindings.put("minValue", "NA");
            argBindings.put("maxValue", "NA");
            argBindings.put("minRecValue", "NA");
            argBindings.put("maxRecValue", "NA");
        }
        argBindings.put("minElements", argDef.getMinElements());
        argBindings.put("maxElements", argDef.getMaxElements());
        String kind = this.docKindOfArg(argDef);
        argBindings.put("kind", kind);
        Pair<String, String> names = this.displayNames(argDef.getShortName(), argDef.getLongName());
        argBindings.put("name", names.getLeft());
        argBindings.put("synonyms", names.getRight() != null ? names.getRight() : "NA");
        argBindings.put("required", argDef.isOptional() ? "no" : "yes");
        argBindings.put("type", this.argumentTypeString(argDef.getUnderlyingField().getGenericType()));
        argBindings.put("summary", argDef.getDocString() != null ? argDef.getDocString() : "");
        argBindings.put("fulltext", fieldCommentText);
        if (argDef.isControlledByPlugin()) {
            argBindings.put("otherArgumentRequired", argDef.getContainingObject().getClass().getSimpleName().length() == 0 ? argDef.getContainingObject().getClass().getName() : argDef.getContainingObject().getClass().getSimpleName());
        } else {
            argBindings.put("otherArgumentRequired", "NA");
        }
        argBindings.put("exclusiveOf", argDef.getMutexTargetList() != null && !argDef.getMutexTargetList().isEmpty() ? String.join((CharSequence)", ", argDef.getMutexTargetList()) : "NA");
        argBindings.put("options", this.getPossibleValues(argDef, argDef.getLongName()));
        ArrayList<String> attributes = new ArrayList<String>();
        if (!argDef.isOptional()) {
            attributes.add("required");
        }
        argBindings.put("deprecated", argDef.isDeprecated());
        if (argDef.isDeprecated()) {
            argBindings.put("deprecationDetail", argDef.getDeprecationDetail());
            attributes.add("deprecated");
        }
        argBindings.put("attributes", attributes.size() > 0 ? String.join((CharSequence)", ", attributes) : "NA");
        argBindings.put("collection", argDef.isCollection());
        return kind;
    }

    private List<Map<String, String>> getPossibleValues(ArgumentDefinition argDef, String displayName) {
        Utils.nonNull(argDef);
        Field underlyingField = argDef.getUnderlyingField();
        Class<?> targetClass = underlyingField.getType();
        if (argDef.isCollection() && underlyingField.getGenericType() instanceof ParameterizedType) {
            Type typeParamType = underlyingField.getGenericType();
            ParameterizedType pType = (ParameterizedType)typeParamType;
            Type[] genericTypes = pType.getActualTypeArguments();
            if (genericTypes.length != 1 || genericTypes[0] instanceof ParameterizedType) {
                return Collections.emptyList();
            }
            try {
                targetClass = Class.forName(genericTypes[0].getTypeName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("No class found for type parameter (%s) used for argument (%s)", genericTypes[0].getTypeName(), displayName), e);
            }
        }
        return targetClass.isEnum() ? this.docForEnumArgument(argDef, targetClass) : Collections.emptyList();
    }

    private <T extends Enum<T>> List<Map<String, String>> docForEnumArgument(ArgumentDefinition argDef, Class<?> enumClass) {
        ArrayList<Map<String, String>> bindings;
        block5: {
            Enum[] enumConstants;
            block4: {
                bindings = new ArrayList<Map<String, String>>();
                enumConstants = (Enum[])enumClass.getEnumConstants();
                if (!CommandLineParser.ClpEnum.class.isAssignableFrom(enumClass)) break block4;
                for (Enum enumConst : enumConstants) {
                    bindings.add(this.createPossibleValuesMap(enumConst.name(), ((CommandLineParser.ClpEnum)((Object)enumConst)).getHelpDoc()));
                }
                break block5;
            }
            String canonicalClassName = enumClass.getCanonicalName();
            TypeElement enumClassElement = this.getDoclet().getDocletEnv().getElementUtils().getTypeElement(canonicalClassName);
            if (enumClassElement == null) break block5;
            for (Enum enumConst : enumConstants) {
                Field enumConstField = this.getFieldForEnumConstant(enumClass, enumConst.name());
                if (enumConstField != null) {
                    Element fieldElement = JavaLanguageModelScanners.getElementForField(this.getDoclet().getDocletEnv(), enumClassElement, enumConstField, ElementKind.ENUM_CONSTANT);
                    if (fieldElement != null) {
                        String comment = JavaLanguageModelScanners.getDocCommentWithoutTags(this.getDoclet().getDocletEnv(), fieldElement);
                        bindings.add(this.createPossibleValuesMap(enumConst.name(), comment));
                        continue;
                    }
                    bindings.add(this.createPossibleValuesMap(enumConst.name(), ""));
                    continue;
                }
                bindings.add(this.createPossibleValuesMap(enumConst.name(), "No documentation available"));
            }
        }
        return bindings;
    }

    private <T> Field getFieldForEnumConstant(Class<?> enumClass, String enumConstantName) {
        for (Field enumClassField : enumClass.getFields()) {
            if (!enumClassField.getName().equals(enumConstantName)) continue;
            return enumClassField;
        }
        return null;
    }

    private HashMap<String, String> createPossibleValuesMap(final String name, final String summary) {
        return new HashMap<String, String>(){
            static final long serialVersionUID = 0L;
            {
                this.put("name", name);
                this.put("summary", summary);
            }
        };
    }

    private Set<String> enumConstantsNames(Class<?> enumClass) {
        HashSet<String> enumConstantFieldNames = new HashSet<String>();
        for (Field field : enumClass.getFields()) {
            if (!field.isEnumConstant()) continue;
            enumConstantFieldNames.add(field.getName());
        }
        return enumConstantFieldNames;
    }

    private class CompareArgumentsByName
    implements Comparator<Map<String, Object>> {
        private CompareArgumentsByName() {
        }

        @Override
        public int compare(Map<String, Object> x, Map<String, Object> y) {
            return this.elt(x).compareTo(this.elt(y));
        }

        private String elt(Map<String, Object> m4) {
            String v = m4.get("name").toString().toLowerCase();
            if (v.startsWith("--")) {
                return v.substring(2);
            }
            if (v.startsWith("-")) {
                return v.substring(1);
            }
            if (v.equals(DefaultDocWorkUnitHandler.NAME_FOR_POSITIONAL_ARGS.toLowerCase())) {
                return "Positional";
            }
            throw new RuntimeException("Expect to see arguments beginning with at least one -, but found " + v);
        }
    }
}

