/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramGroup;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.DeprecatedFeature;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.utils.Utils;

public class DocWorkUnit
implements Comparable<DocWorkUnit> {
    protected static final Logger logger = LogManager.getLogger(DocWorkUnit.class);
    private final String name;
    private final Class<?> clazz;
    private final Element docElement;
    private final DocWorkUnitHandler workUnitHandler;
    private final DocumentedFeature documentedFeature;
    private final CommandLineProgramProperties commandLineProperties;
    private final ExperimentalFeature experimentalFeature;
    private final BetaFeature betaFeature;
    private final DeprecatedFeature deprecatedFeature;
    private Map<String, Object> propertyMap = new HashMap<String, Object>();
    protected String summary;
    protected String groupName;
    protected String groupSummary;

    public DocWorkUnit(DocWorkUnitHandler workUnitHandler, Element docElement, Class<?> clazz, DocumentedFeature documentedFeatureAnnotation) {
        Utils.nonNull(workUnitHandler, "workUnitHandler cannot be null");
        Utils.nonNull(documentedFeatureAnnotation, "DocumentedFeature annotation cannot be null");
        Utils.nonNull(docElement, "classDoc cannot be null");
        Utils.nonNull(clazz, "class cannot be null");
        this.name = clazz.getSimpleName();
        this.documentedFeature = documentedFeatureAnnotation;
        this.commandLineProperties = clazz.getAnnotation(CommandLineProgramProperties.class);
        this.experimentalFeature = clazz.getAnnotation(ExperimentalFeature.class);
        this.betaFeature = clazz.getAnnotation(BetaFeature.class);
        this.deprecatedFeature = clazz.getAnnotation(DeprecatedFeature.class);
        this.checkForMultipleMutexAnnotations();
        this.workUnitHandler = workUnitHandler;
        this.docElement = docElement;
        this.clazz = clazz;
        this.summary = workUnitHandler.getSummaryForWorkUnit(this);
        this.groupName = workUnitHandler.getGroupNameForWorkUnit(this);
        this.groupSummary = workUnitHandler.getGroupSummaryForWorkUnit(this);
    }

    private void checkForMultipleMutexAnnotations() {
        int count = (this.experimentalFeature != null ? 1 : 0) + (this.betaFeature != null ? 1 : 0) + (this.deprecatedFeature != null ? 1 : 0);
        if (count > 1) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("Multiple annotations detected on class %s. The Deprecated, Beta, and Experimental annotations are mutually exclusive.", this.clazz.getSimpleName()));
        }
    }

    public Map<String, Object> getRootMap() {
        return this.propertyMap;
    }

    public void setProperty(String key, Object value) {
        this.propertyMap.put(key, value);
    }

    public Object getProperty(String key) {
        return this.propertyMap.get(key);
    }

    public DocumentedFeature getDocumentedFeature() {
        return this.documentedFeature;
    }

    public Element getDocElement() {
        return this.docElement;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupSummary() {
        return this.groupSummary;
    }

    public String getSummary() {
        return this.summary;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void processDoc(List<Map<String, String>> featureMaps, List<Map<String, String>> groupMaps) {
        this.workUnitHandler.processWorkUnit(this, featureMaps, groupMaps);
    }

    public String getTemplateName() {
        return this.workUnitHandler.getTemplateName(this);
    }

    public String getTargetFileName() {
        return this.workUnitHandler.getDestinationFilename(this);
    }

    public String getJSONFileName() {
        return this.workUnitHandler.getJSONFilename(this);
    }

    public CommandLineProgramProperties getCommandLineProperties() {
        return this.commandLineProperties;
    }

    public boolean isBetaFeature() {
        return this.betaFeature != null;
    }

    public boolean isExperimentalFeature() {
        return this.experimentalFeature != null;
    }

    public boolean isDeprecatedFeature() {
        return this.deprecatedFeature != null;
    }

    public String getDeprecationDetail() {
        return this.isDeprecatedFeature() ? this.deprecatedFeature.detail() : null;
    }

    public CommandLineProgramGroup getCommandLineProgramGroup() {
        if (this.commandLineProperties != null) {
            try {
                return this.commandLineProperties.programGroup().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("Command line program class %s does not have the required no argument constructor", this.getClazz()), e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                logger.warn(String.format("Can't instantiate program group class to retrieve summary for group %s for class %s", this.commandLineProperties.programGroup().getName(), this.clazz.getName()));
            }
        }
        return null;
    }

    @Override
    public int compareTo(DocWorkUnit other) {
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocWorkUnit)) {
            return false;
        }
        DocWorkUnit that = (DocWorkUnit)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.clazz.equals(that.clazz)) {
            return false;
        }
        if (!this.docElement.equals(that.docElement)) {
            return false;
        }
        if (this.documentedFeature != null ? !this.documentedFeature.equals(that.documentedFeature) : that.documentedFeature != null) {
            return false;
        }
        if (this.commandLineProperties != null ? !this.commandLineProperties.equals(that.commandLineProperties) : that.commandLineProperties != null) {
            return false;
        }
        if (this.experimentalFeature != null ? !this.experimentalFeature.equals(that.experimentalFeature) : that.experimentalFeature != null) {
            return false;
        }
        if (this.betaFeature != null ? !this.betaFeature.equals(that.betaFeature) : that.betaFeature != null) {
            return false;
        }
        if (!this.propertyMap.equals(that.propertyMap)) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(that.summary) : that.summary != null) {
            return false;
        }
        if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) {
            return false;
        }
        return this.groupSummary != null ? this.groupSummary.equals(that.groupSummary) : that.groupSummary == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + this.docElement.hashCode();
        result = 31 * result + (this.documentedFeature != null ? this.documentedFeature.hashCode() : 0);
        result = 31 * result + (this.commandLineProperties != null ? this.commandLineProperties.hashCode() : 0);
        result = 31 * result + (this.experimentalFeature != null ? this.experimentalFeature.hashCode() : 0);
        result = 31 * result + (this.betaFeature != null ? this.betaFeature.hashCode() : 0);
        result = 31 * result + this.propertyMap.hashCode();
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
        result = 31 * result + (this.groupSummary != null ? this.groupSummary.hashCode() : 0);
        return result;
    }
}

