/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help.scanners;

import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreeScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jdk.javadoc.doclet.DocletEnvironment;
import org.broadinstitute.barclay.utils.Utils;

class CommentScannerWithTagFilter
extends DocTreeScanner<Void, Void> {
    final DocTree docTree;
    final DocletEnvironment docEnv;
    private final List<String> targetDocCommentParts = new ArrayList<String>();

    CommentScannerWithTagFilter(DocletEnvironment docEnv, DocTree docTree) {
        Utils.nonNull(docEnv, "doclet environment");
        Utils.nonNull(docTree, "docTree");
        this.docEnv = docEnv;
        this.docTree = docTree;
    }

    @Override
    public Void scan(DocTree t2, Void unused) {
        Utils.nonNull(this.docTree, "DocTree");
        if (t2.getKind().equals((Object)DocTree.Kind.TEXT)) {
            this.targetDocCommentParts.add(t2.toString());
            return null;
        }
        return (Void)super.scan(t2, null);
    }

    String getCommentWithoutTags() {
        return this.targetDocCommentParts.stream().collect(Collectors.joining(" "));
    }
}

