/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.http.nio;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Set;
import org.broadinstitute.http.nio.HttpAbstractFileSystemProvider;
import org.broadinstitute.http.nio.HttpPath;
import org.broadinstitute.http.nio.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpFileSystem
extends FileSystem {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpAbstractFileSystemProvider provider;
    private final String authority;

    HttpFileSystem(HttpAbstractFileSystemProvider provider, String authority) {
        this.provider = Utils.nonNull(provider, () -> "null provider");
        this.authority = Utils.nonNull(authority, () -> "null authority");
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    public String getAuthority() {
        return this.authority;
    }

    @Override
    public void close() {
        this.logger.warn("{} is always open (not closed)", (Object)this.getClass());
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(new HttpPath(this, "", null, null));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public HttpPath getPath(String first, String ... more) {
        String path = Utils.nonNull(first, () -> "null first") + String.join((CharSequence)this.getSeparator(), Utils.nonNull(more, () -> "null more"));
        if (!path.isEmpty() && !path.startsWith(this.getSeparator())) {
            throw new InvalidPathException(path, "Cannot construct a relative http/s path", 0);
        }
        try {
            return this.getPath(new URI(path));
        }
        catch (URISyntaxException e) {
            throw new InvalidPathException(e.getInput(), e.getReason(), e.getIndex());
        }
    }

    HttpPath getPath(URI uri) {
        return new HttpPath(this, uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getSimpleName(), this.provider, this.hashCode());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpFileSystem) {
            HttpFileSystem ofs = (HttpFileSystem)other;
            return this.provider() == ofs.provider() && this.getAuthority().equalsIgnoreCase(ofs.getAuthority());
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.provider.hashCode() + this.getAuthority().toLowerCase().hashCode();
    }
}

