/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.http.nio;

import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Collection;
import java.util.function.Predicate;
import org.broadinstitute.http.nio.RetryHandler;
import org.broadinstitute.http.nio.utils.Utils;

public record HttpFileSystemProviderSettings(Duration timeout, HttpClient.Redirect redirect, RetrySettings retrySettings) {
    public static final RetrySettings DEFAULT_RETRY_SETTINGS = new RetrySettings(3, RetryHandler.DEFAULT_RETRYABLE_HTTP_CODES, RetryHandler.DEFAULT_RETRYABLE_EXCEPTIONS, RetryHandler.DEFALT_RETRYABLE_MESSAGES, e -> false);
    public static final HttpFileSystemProviderSettings DEFAULT_SETTINGS = new HttpFileSystemProviderSettings(Duration.ofSeconds(10L), HttpClient.Redirect.NORMAL, DEFAULT_RETRY_SETTINGS);

    public HttpFileSystemProviderSettings {
        Utils.nonNull(timeout, () -> "timeout");
        Utils.nonNull(redirect, () -> "redirect");
        Utils.nonNull(retrySettings, () -> "retrySettings");
    }

    public record RetrySettings(int maxRetries, Collection<Integer> retryableHttpCodes, Collection<Class<? extends Exception>> retryableExceptions, Collection<String> retryableMessages, Predicate<Throwable> retryPredicate) {
        public RetrySettings {
            Utils.validateArg(maxRetries >= 0, "maxRetries must be >= 0");
            Utils.nonNull(retryableHttpCodes, () -> "retryableHttpCodes");
            Utils.nonNull(retryableExceptions, () -> "retryableExceptions");
            Utils.nonNull(retryableMessages, () -> "retryableMessages");
            Utils.nonNull(retryPredicate, () -> "retryPredicate");
        }
    }
}

