/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.http.nio.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import org.broadinstitute.http.nio.HttpFileSystemProviderSettings;
import org.broadinstitute.http.nio.RetryHandler;
import org.broadinstitute.http.nio.UnexpectedHttpResponseException;
import org.broadinstitute.http.nio.utils.ExceptionCauseIterator;
import org.broadinstitute.http.nio.utils.Utils;

public final class HttpUtils {
    public static final String HTTP_PATH_SEPARATOR_STRING = "/";
    public static final char HTTP_PATH_SEPARATOR_CHAR = '/';
    public static final Charset HTTP_PATH_CHARSET = StandardCharsets.UTF_8;

    private HttpUtils() {
    }

    public static boolean exists(URI uri, HttpFileSystemProviderSettings settings) throws IOException {
        Utils.nonNull(uri, () -> "null uri");
        HttpClient client = HttpUtils.getClient(settings);
        HttpRequest request = HttpRequest.newBuilder(uri).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
        RetryHandler retryHandler = new RetryHandler(settings.retrySettings(), uri);
        return retryHandler.runWithRetries(() -> {
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                return switch (response.statusCode()) {
                    case 200, 206 -> true;
                    case 404 -> false;
                    case 407 -> throw new AccessDeniedException("Access was denied to " + uri + "\nHttp status: " + response.statusCode() + "\n" + response.body());
                    default -> throw new UnexpectedHttpResponseException(response.statusCode(), "Unexpected response from " + uri + "\nHttp status: " + response.statusCode() + "\n" + response.body());
                };
            }
            catch (ConnectException e) {
                for (Throwable cause : new ExceptionCauseIterator(e)) {
                    if (!(cause instanceof UnresolvedAddressException)) continue;
                    return false;
                }
                throw e;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Connection thread was unexpectedly interrupted while checking existence of " + uri + ".");
            }
        });
    }

    public static HttpClient getClient(HttpFileSystemProviderSettings settings) {
        return HttpClient.newBuilder().followRedirects(settings.redirect()).connectTimeout(settings.timeout()).build();
    }
}

