/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.api.scripting;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Formatter {
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern FS_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    private Formatter() {
    }

    static String format(String format, Object[] args) {
        Matcher m4 = FS_PATTERN.matcher(format);
        int positionalParameter = 1;
        while (m4.find()) {
            int index = Formatter.index(m4.group(1));
            boolean previous = Formatter.isPreviousArgument(m4.group(2));
            char conversion = m4.group(6).charAt(0);
            if (index < 0 || previous || conversion == 'n' || conversion == '%') continue;
            if (index == 0) {
                index = positionalParameter++;
            }
            if (index > args.length) continue;
            Object arg = args[index - 1];
            if (m4.group(5) != null) {
                if (!(arg instanceof Double)) continue;
                args[index - 1] = ((Double)arg).longValue();
                continue;
            }
            switch (conversion) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    if (arg instanceof Double) {
                        args[index - 1] = ((Double)arg).longValue();
                        break;
                    }
                    if (!(arg instanceof String) || ((String)arg).length() <= 0) break;
                    args[index - 1] = (int)((String)arg).charAt(0);
                    break;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    if (!(arg instanceof Integer)) break;
                    args[index - 1] = ((Integer)arg).doubleValue();
                    break;
                }
                case 'c': {
                    if (arg instanceof Double) {
                        args[index - 1] = ((Double)arg).intValue();
                        break;
                    }
                    if (!(arg instanceof String) || ((String)arg).length() <= 0) break;
                    args[index - 1] = (int)((String)arg).charAt(0);
                    break;
                }
            }
        }
        return String.format(format, args);
    }

    private static int index(String s2) {
        int index = -1;
        if (s2 != null) {
            try {
                index = Integer.parseInt(s2.substring(0, s2.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            index = 0;
        }
        return index;
    }

    private static boolean isPreviousArgument(String s2) {
        return s2 != null && s2.indexOf(60) >= 0;
    }
}

