/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.AdapterUtility;
import picard.analysis.AlignmentSummaryMetrics;
import picard.analysis.AlignmentSummaryMetricsCollector;
import picard.analysis.ChimeraUtil;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.util.RExecutor;

@CommandLineProgramProperties(summary="<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  This tool takes a SAM/BAM file input and produces metrics detailing the quality of the read alignments as well as the proportion of the reads that passed machine signal-to-noise threshold quality filters. Note that these quality filters are specific to Illumina data; for additional information, please see the corresponding <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. </p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentSummaryMetrics \\<br />          R=reference_sequence.fasta \\<br />          I=input.bam \\<br />          O=output.txt</pre><p>Please see the CollectAlignmentSummaryMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#AlignmentSummaryMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr />", oneLineSummary="<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  ", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CollectAlignmentSummaryMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "<b>Produces a summary of alignment metrics from a SAM or BAM file.</b>  ";
    static final String USAGE_DETAILS = "This tool takes a SAM/BAM file input and produces metrics detailing the quality of the read alignments as well as the proportion of the reads that passed machine signal-to-noise threshold quality filters. Note that these quality filters are specific to Illumina data; for additional information, please see the corresponding <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. </p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>    java -jar picard.jar CollectAlignmentSummaryMetrics \\<br />          R=reference_sequence.fasta \\<br />          I=input.bam \\<br />          O=output.txt</pre><p>Please see the CollectAlignmentSummaryMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#AlignmentSummaryMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr />";
    private static final Log log = Log.getInstance(CollectAlignmentSummaryMetrics.class);
    private static final String HISTOGRAM_R_SCRIPT = "picard/analysis/readLengthDistribution.R";
    @Argument(shortName="H", doc="If Provided, file to write read-length chart pdf.", optional=true)
    public File HISTOGRAM_FILE;
    @Argument(doc="Paired-end reads above this insert size will be considered chimeric along with inter-chromosomal pairs.")
    public int MAX_INSERT_SIZE = ChimeraUtil.DEFAULT_INSERT_SIZE_LIMIT;
    @Argument(doc="Paired-end reads that do not have this expected orientation will be considered chimeric.")
    public Set<SamPairUtil.PairOrientation> EXPECTED_PAIR_ORIENTATIONS = EnumSet.copyOf(ChimeraUtil.DEFAULT_EXPECTED_ORIENTATIONS);
    @Argument(doc="List of adapter sequences to use when processing the alignment metrics.")
    public List<String> ADAPTER_SEQUENCE = AdapterUtility.DEFAULT_ADAPTER_SEQUENCE;
    @Argument(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Argument(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Argument(doc="A flag to disable the collection of actual alignment information. If false, tool will only count READS, PF_READS, and NOISE_READS. (For backwards compatibility).")
    public boolean COLLECT_ALIGNMENT_INFORMATION = true;
    private AlignmentSummaryMetricsCollector collector;

    @Override
    protected String[] customCommandLineValidation() {
        if (!CollectAlignmentSummaryMetrics.checkRInstallation(this.HISTOGRAM_FILE != null)) {
            return new String[]{"R is not installed on this machine. It is required for creating the chart."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (this.HISTOGRAM_FILE != null) {
            if (!this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.ALL_READS)) {
                log.error("ReadLength histogram is calculated on all reads only, but ALL_READS were not included in the Metric Accumulation Levels. Histogram will not be generated.");
                this.HISTOGRAM_FILE = null;
            } else {
                IOUtil.assertFileIsWritable(this.HISTOGRAM_FILE);
            }
        }
        if (header.getSequenceDictionary().isEmpty()) {
            log.warn(String.valueOf(this.INPUT.getAbsoluteFile()) + " has no sequence dictionary. If any reads in the file are aligned, then alignment summary metrics collection will fail.");
        }
        if (this.REFERENCE_SEQUENCE == null && this.COLLECT_ALIGNMENT_INFORMATION) {
            log.warn("Without a REFERENCE_SEQUENCE, metrics pertaining to mismatch rates will not be collected!");
        }
        this.collector = new AlignmentSummaryMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, header.getReadGroups(), this.COLLECT_ALIGNMENT_INFORMATION, this.ADAPTER_SEQUENCE, this.MAX_INSERT_SIZE, this.EXPECTED_PAIR_ORIENTATIONS, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.collector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        this.collector.finish();
        MetricsFile<AlignmentSummaryMetrics, Integer> file = this.getMetricsFile();
        this.collector.addAllLevelsToFile(file);
        AlignmentSummaryMetricsCollector.GroupAlignmentSummaryMetricsPerUnitMetricCollector allReadsGroupCollector = (AlignmentSummaryMetricsCollector.GroupAlignmentSummaryMetricsPerUnitMetricCollector)this.collector.getAllReadsCollector();
        if (allReadsGroupCollector != null) {
            CollectAlignmentSummaryMetrics.addAllHistogramToMetrics(file, "PAIRED_TOTAL_LENGTH_COUNT", allReadsGroupCollector.pairCollector);
            CollectAlignmentSummaryMetrics.addAlignedHistogramToMetrics(file, "PAIRED_ALIGNED_LENGTH_COUNT", allReadsGroupCollector.pairCollector);
            CollectAlignmentSummaryMetrics.addAllHistogramToMetrics(file, "UNPAIRED_TOTAL_LENGTH_COUNT", allReadsGroupCollector.unpairedCollector);
            CollectAlignmentSummaryMetrics.addAlignedHistogramToMetrics(file, "UNPAIRED_ALIGNED_LENGTH_COUNT", allReadsGroupCollector.unpairedCollector);
        }
        file.write(this.OUTPUT);
        if (this.HISTOGRAM_FILE != null) {
            if (file.getNumHistograms() == 0 || file.getAllHistograms().stream().allMatch(Histogram::isEmpty)) {
                log.warn("No Read length histograms to plot.");
            } else {
                ArrayList plotArgs = new ArrayList();
                Collections.addAll(plotArgs, this.OUTPUT.getAbsolutePath(), this.HISTOGRAM_FILE.getAbsolutePath().replaceAll("%", "%%"), this.INPUT.getName());
                int rResult = RExecutor.executeFromClasspath(HISTOGRAM_R_SCRIPT, plotArgs.toArray(new String[0]));
                if (rResult != 0) {
                    throw new PicardException("R script picard/analysis/readLengthDistribution.R failed with return code " + rResult);
                }
            }
        }
    }

    private static void addAllHistogramToMetrics(MetricsFile<AlignmentSummaryMetrics, Integer> file, String label, AlignmentSummaryMetricsCollector.IndividualAlignmentSummaryMetricsCollector metricsCollector) {
        if (metricsCollector != null) {
            CollectAlignmentSummaryMetrics.addHistogramToMetrics(file, label, metricsCollector.getReadHistogram());
        }
    }

    private static void addAlignedHistogramToMetrics(MetricsFile<AlignmentSummaryMetrics, Integer> file, String label, AlignmentSummaryMetricsCollector.IndividualAlignmentSummaryMetricsCollector metricsCollector) {
        if (metricsCollector != null) {
            CollectAlignmentSummaryMetrics.addHistogramToMetrics(file, label, metricsCollector.getAlignedReadHistogram());
        }
    }

    private static void addHistogramToMetrics(MetricsFile<AlignmentSummaryMetrics, Integer> file, String label, Histogram<Integer> readHistogram) {
        readHistogram.setBinLabel("READ_LENGTH");
        readHistogram.setValueLabel(label);
        file.addHistogram(readHistogram);
    }

    @Override
    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return new CollectAlignmentRefArgCollection();
    }

    public static class CollectAlignmentRefArgCollection
    implements ReferenceArgumentCollection {
        @Argument(shortName="R", doc="Reference sequence file. Note that while this argument isn't required, without it a small subset (MISMATCH-related) of the metrics cannot be calculated. Note also that if a reference sequence is provided, it must be accompanied by a sequence dictionary.", optional=true)
        public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;

        @Override
        public File getReferenceFile() {
            return this.REFERENCE_SEQUENCE;
        }
    }
}

