/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.Vector;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.MergeableMetricBase;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.flow.FlowBasedArgumentCollection;
import picard.flow.FlowBasedKeyCodec;
import picard.flow.FlowBasedRead;
import picard.flow.FlowReadGroupInfo;
import picard.util.SeriesStats;

@CommandLineProgramProperties(summary="Collect metrics about reads that pass quality thresholds from flow based read files.  This tool evaluates the overall quality of reads within a bam file containing one read group. The output indicates the total numbers of flows within a read group that pass a minimum base quality score threshold <h4>Usage Example:</h4><pre>java -jar picard.jar CollectQualityYieldMetricsFlow \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre><hr />", oneLineSummary="Collect metrics about reads that pass quality thresholds from flow based read files.  ", programGroup=DiagnosticsAndQCProgramGroup.class)
@ExperimentalFeature
public class CollectQualityYieldMetricsFlow
extends SinglePassSamProgram {
    private static final byte MIN_QUAL = 0;
    private static final byte MAX_QUAL = 100;
    private final Log log = Log.getInstance(CollectQualityYieldMetricsFlow.class);
    private static final int CYCLE_LENGTH = 4;
    private QualityYieldMetricsCollectorFlow collector = null;
    public Histogram<Integer> qualityHistogram = new Histogram("KEY", "QUAL_COUNT");
    private Vector<SeriesStats> flowQualityStats = new Vector();
    static final String USAGE_SUMMARY = "Collect metrics about reads that pass quality thresholds from flow based read files.  ";
    static final String USAGE_DETAILS = "This tool evaluates the overall quality of reads within a bam file containing one read group. The output indicates the total numbers of flows within a read group that pass a minimum base quality score threshold <h4>Usage Example:</h4><pre>java -jar picard.jar CollectQualityYieldMetricsFlow \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre><hr />";
    @Argument(doc="If true, include bases from secondary alignments in metrics. Setting to true may cause double-counting of bases if there are secondary alignments in the input file.")
    public boolean INCLUDE_SECONDARY_ALIGNMENTS = false;
    @Argument(doc="If true, include bases from supplemental alignments in metrics. Setting to true may cause double-counting of bases if there are supplemental alignments in the input file.")
    public boolean INCLUDE_SUPPLEMENTAL_ALIGNMENTS = false;
    @Argument(doc="Determines whether to include the flow quality histogram in the metrics file.")
    public boolean INCLUDE_BQ_HISTOGRAM = false;
    @ArgumentCollection(doc="flow based args")
    public FlowBasedArgumentCollection fbargs = new FlowBasedArgumentCollection();

    @Override
    protected boolean usesNoRefReads() {
        return true;
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable(this.OUTPUT);
        this.collector = new QualityYieldMetricsCollectorFlow(this.INCLUDE_SECONDARY_ALIGNMENTS, this.INCLUDE_SUPPLEMENTAL_ALIGNMENTS, this.fbargs);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.collector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        MetricsFile<QualityYieldMetricsFlow, Integer> metricsFile = this.getMetricsFile();
        this.collector.finish();
        this.collector.addMetricsToFile(metricsFile);
        if (this.INCLUDE_BQ_HISTOGRAM) {
            metricsFile.addHistogram(this.qualityHistogram);
            this.collector.addHistograms(metricsFile);
        }
        metricsFile.write(this.OUTPUT);
    }

    public class QualityYieldMetricsCollectorFlow {
        private final boolean includeSecondaryAlignments;
        public final boolean includeSupplementalAlignments;
        private final QualityYieldMetricsFlow metrics;
        private final FlowBasedArgumentCollection fbargs;

        public QualityYieldMetricsCollectorFlow(boolean includeSecondaryAlignments, boolean includeSupplementalAlignments, FlowBasedArgumentCollection fbargs) {
            this.includeSecondaryAlignments = includeSecondaryAlignments;
            this.includeSupplementalAlignments = includeSupplementalAlignments;
            this.fbargs = fbargs;
            this.metrics = new QualityYieldMetricsFlow();
        }

        public void acceptRecord(SAMRecord rec, ReferenceSequence ref) {
            boolean isPfRead;
            if (rec.getReadLength() == 0) {
                return;
            }
            if (!this.includeSecondaryAlignments && rec.isSecondaryAlignment()) {
                return;
            }
            if (!this.includeSupplementalAlignments && rec.getSupplementaryAlignmentFlag()) {
                return;
            }
            ++this.metrics.TOTAL_READS;
            boolean bl = isPfRead = !rec.getReadFailsVendorQualityCheckFlag();
            if (!isPfRead) {
                return;
            }
            FlowReadGroupInfo info = FlowBasedKeyCodec.getReadGroupInfo(rec.getHeader(), rec);
            if (!info.isFlowPlatform) {
                throw new PicardException("Reads should originate from a flow based platform");
            }
            FlowBasedRead fread = new FlowBasedRead(rec, info.flowOrder, info.maxClass, this.fbargs);
            ++this.metrics.PF_READS;
            this.metrics.PF_FLOWS += (long)fread.getKey().length;
            byte[] quals = this.getFlowQualities(fread);
            int cycleCount = CollectQualityYieldMetricsFlow.this.INCLUDE_BQ_HISTOGRAM ? (int)Math.ceil((float)quals.length / 4.0f) : 0;
            int[] cycleQualCount = CollectQualityYieldMetricsFlow.this.INCLUDE_BQ_HISTOGRAM ? new int[cycleCount] : null;
            int[] cycleQualSum = CollectQualityYieldMetricsFlow.this.INCLUDE_BQ_HISTOGRAM ? new int[cycleCount] : null;
            int flow = 0;
            for (byte qual : quals) {
                this.metrics.PF_Q20_EQUIVALENT_YIELD += (long)qual;
                if (qual >= 30) {
                    ++this.metrics.PF_Q20_FLOWS;
                    ++this.metrics.PF_Q30_FLOWS;
                } else if (qual >= 20) {
                    ++this.metrics.PF_Q20_FLOWS;
                }
                if (CollectQualityYieldMetricsFlow.this.INCLUDE_BQ_HISTOGRAM) {
                    int cycle;
                    CollectQualityYieldMetricsFlow.this.qualityHistogram.increment(Integer.valueOf(qual));
                    int n = cycle = flow / 4;
                    cycleQualCount[n] = cycleQualCount[n] + 1;
                    int n2 = cycle;
                    cycleQualSum[n2] = cycleQualSum[n2] + qual;
                }
                ++flow;
            }
            if (CollectQualityYieldMetricsFlow.this.INCLUDE_BQ_HISTOGRAM) {
                while (CollectQualityYieldMetricsFlow.this.flowQualityStats.size() < cycleCount) {
                    CollectQualityYieldMetricsFlow.this.flowQualityStats.add(new SeriesStats());
                }
                for (int cycle = 0; cycle < cycleCount; ++cycle) {
                    int id = !rec.getReadNegativeStrandFlag() ? cycle : cycleCount - 1 - cycle;
                    CollectQualityYieldMetricsFlow.this.flowQualityStats.get(id).add((double)cycleQualSum[cycle] / (double)cycleQualCount[cycle]);
                }
            }
        }

        private byte[] getFlowQualities(FlowBasedRead fread) {
            double[] errorProbs = this.computeErrorProb(fread);
            byte[] quals = new byte[errorProbs.length];
            for (int i = 0; i < errorProbs.length; ++i) {
                if (errorProbs[i] == 0.0) {
                    CollectQualityYieldMetricsFlow.this.log.warn(fread.getReadName() + ": zero errorProb on flow: " + i);
                    quals[i] = 100;
                    continue;
                }
                long q = Math.round(-10.0 * Math.log10(errorProbs[i]));
                if (q < 0L || q > 100L) {
                    CollectQualityYieldMetricsFlow.this.log.warn(fread.getReadName() + ": qual " + q + " is out of range on flow: " + i);
                    q = Math.max(0L, Math.min(100L, q));
                }
                quals[i] = (byte)q;
            }
            return quals;
        }

        private double[] computeErrorProb(FlowBasedRead flowRead) {
            int[] key = flowRead.getKey();
            double[] probCol = new double[flowRead.getMaxHmer() + 1];
            double[] result = new double[key.length];
            for (int i = 0; i < key.length; ++i) {
                int j;
                double sum = 0.0;
                for (j = 0; j < probCol.length; ++j) {
                    probCol[j] = flowRead.getProb(i, j);
                    sum += probCol[j];
                }
                j = 0;
                while (j < probCol.length) {
                    int n = j++;
                    probCol[n] = probCol[n] / sum;
                }
                result[i] = 1.0 - probCol[Math.min(key[i], flowRead.getMaxHmer())];
            }
            return result;
        }

        public void finish() {
            this.metrics.PF_Q20_EQUIVALENT_YIELD /= 20L;
            this.metrics.calculateDerivedFields();
        }

        public void addMetricsToFile(MetricsFile<QualityYieldMetricsFlow, Integer> metricsFile) {
            metricsFile.addMetric(this.metrics);
        }

        public void addHistograms(MetricsFile<QualityYieldMetricsFlow, Integer> metricsFile) {
            Histogram<Integer> meanHist = new Histogram<Integer>("KEY", "MEAN_CYCLE_QUAL");
            Histogram<Integer> medianHist = new Histogram<Integer>("KEY", "MEDIAN_CYCLE_QUAL");
            Histogram<Integer> q25Hist = new Histogram<Integer>("KEY", "Q25_CYCLE_QUAL");
            Histogram<Integer> q75Hist = new Histogram<Integer>("KEY", "Q75_CYCLE_QUAL");
            for (int i = 0; i < CollectQualityYieldMetricsFlow.this.flowQualityStats.size(); ++i) {
                SeriesStats ss = CollectQualityYieldMetricsFlow.this.flowQualityStats.get(i);
                meanHist.increment(i, ss.getMean());
                medianHist.increment(i, ss.getMedian());
                q25Hist.increment(i, ss.getPercentile(25.0));
                q75Hist.increment(i, ss.getPercentile(75.0));
            }
            metricsFile.addHistogram(meanHist);
            metricsFile.addHistogram(medianHist);
            metricsFile.addHistogram(q25Hist);
            metricsFile.addHistogram(q75Hist);
        }
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class QualityYieldMetricsFlow
    extends MergeableMetricBase {
        @MergeableMetricBase.MergeByAdding
        public long TOTAL_READS = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_READS = 0L;
        @MergeableMetricBase.NoMergingIsDerived
        public int MEAN_PF_READ_NUMBER_OF_FLOWS = 0;
        @MergeableMetricBase.MergeByAdding
        public long PF_FLOWS = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q20_FLOWS = 0L;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q20_FLOWS = 0.0;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q30_FLOWS = 0L;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q30_FLOWS = 0.0;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q20_EQUIVALENT_YIELD = 0L;

        @Override
        public void calculateDerivedFields() {
            super.calculateDerivedFields();
            this.MEAN_PF_READ_NUMBER_OF_FLOWS = this.PF_READS == 0L ? 0 : (int)(this.PF_FLOWS / this.PF_READS);
            this.PCT_PF_Q20_FLOWS = this.PF_FLOWS == 0L ? 0.0 : (double)this.PF_Q20_FLOWS / (double)this.PF_FLOWS;
            this.PCT_PF_Q30_FLOWS = this.PF_FLOWS == 0L ? 0.0 : (double)this.PF_Q30_FLOWS / (double)this.PF_FLOWS;
        }

        @Override
        public MergeableMetricBase merge(MergeableMetricBase other) {
            if (!(other instanceof QualityYieldMetricsFlow)) {
                throw new PicardException("Only objects of the same type can be merged");
            }
            QualityYieldMetricsFlow otherMetric = (QualityYieldMetricsFlow)other;
            super.merge(otherMetric);
            this.calculateDerivedFields();
            return this;
        }
    }
}

