/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.Vector;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.MergeableMetricBase;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.util.SeriesStats;

@CommandLineProgramProperties(summary="Collect SNVQ metrics about reads that pass quality thresholds and other filters (such as vendor fail, etc).  This tool evaluates the overall SNVQ quality of reads within a bam file containing one read group. The output indicates the total numbers of bases within a read group that pass a minimum base quality score threshold and (in the case of Illumina data) pass Illumina quality filters as described in the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. <br /><h4>Usage Example:</h4><pre>java -jar picard.jar CollectSNVQualityYieldMetrics \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectSNVQualityYieldMetrics.QualityYieldMetrics'>the QualityYieldMetrics documentation</a> for details and explanations of the output metrics.<hr />", oneLineSummary="Collect SNVQ metrics about reads that pass quality thresholds and other filters (such as vendor fail, etc).  ", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CollectQualityYieldMetricsSNVQ
extends SinglePassSamProgram {
    public static final String SNVQ_BASE_ORDER = "ACGT";
    private QualityYieldMetricsCollector collector = null;
    public Histogram<Integer> qualityHistogram = new Histogram("KEY", "BQ_COUNT");
    private Vector<SeriesStats> readPositionQualityStats = new Vector();
    public Histogram<Integer> snvqHistogram = new Histogram("KEY", "SNVQ_COUNT");
    private Vector<SeriesStats> readPositionSnvqStats = new Vector();
    final byte[] baseOrder = "ACGT".getBytes();
    static final String USAGE_SUMMARY = "Collect SNVQ metrics about reads that pass quality thresholds and other filters (such as vendor fail, etc).  ";
    static final String USAGE_DETAILS = "This tool evaluates the overall SNVQ quality of reads within a bam file containing one read group. The output indicates the total numbers of bases within a read group that pass a minimum base quality score threshold and (in the case of Illumina data) pass Illumina quality filters as described in the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. <br /><h4>Usage Example:</h4><pre>java -jar picard.jar CollectSNVQualityYieldMetrics \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectSNVQualityYieldMetrics.QualityYieldMetrics'>the QualityYieldMetrics documentation</a> for details and explanations of the output metrics.<hr />";
    @Argument(shortName="AQA", doc="Use an alternative  tag instead of base quality (QUAL) scores ", optional=true)
    public String ALTERNATE_QUALITY_ATTRIBUTE = null;
    @Argument(doc="If true, include bases from secondary alignments in metrics. Setting to true may cause double-counting of bases if there are secondary alignments in the input file.")
    public boolean INCLUDE_SECONDARY_ALIGNMENTS = false;
    @Argument(doc="If true, include bases from supplemental alignments in metrics. Setting to true may cause double-counting of bases if there are supplemental alignments in the input file.")
    public boolean INCLUDE_SUPPLEMENTAL_ALIGNMENTS = false;
    @Argument(doc="Determines whether to include the base quality histogram in the metrics file.")
    public boolean INCLUDE_BQ_HISTOGRAM = false;

    @Override
    protected boolean usesNoRefReads() {
        return true;
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable(this.OUTPUT);
        this.collector = new QualityYieldMetricsCollector(this.ALTERNATE_QUALITY_ATTRIBUTE, this.INCLUDE_SECONDARY_ALIGNMENTS, this.INCLUDE_SUPPLEMENTAL_ALIGNMENTS);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.collector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        MetricsFile<QualityYieldMetrics, Integer> metricsFile = this.getMetricsFile();
        this.collector.finish();
        this.collector.addMetricsToFile(metricsFile);
        if (this.INCLUDE_BQ_HISTOGRAM) {
            metricsFile.addHistogram(this.qualityHistogram);
            metricsFile.addHistogram(this.snvqHistogram);
            this.collector.addHistograms(metricsFile);
        }
        metricsFile.write(this.OUTPUT);
    }

    public class QualityYieldMetricsCollector {
        private final String alternateQualityAttribute;
        private final boolean includeSecondaryAlignments;
        public final boolean includeSupplementalAlignments;
        private final QualityYieldMetrics metrics;

        public QualityYieldMetricsCollector(String alternateQualityAttribute, boolean includeSecondaryAlignments, boolean includeSupplementalAlignments) {
            this.alternateQualityAttribute = alternateQualityAttribute;
            this.includeSecondaryAlignments = includeSecondaryAlignments;
            this.includeSupplementalAlignments = includeSupplementalAlignments;
            this.metrics = new QualityYieldMetrics(alternateQualityAttribute);
        }

        public void acceptRecord(SAMRecord rec, ReferenceSequence ref) {
            byte[] quals;
            boolean isPfRead;
            if (!this.includeSecondaryAlignments && rec.isSecondaryAlignment()) {
                return;
            }
            if (!this.includeSupplementalAlignments && rec.getSupplementaryAlignmentFlag()) {
                return;
            }
            int length = rec.getReadLength();
            ++this.metrics.TOTAL_READS;
            this.metrics.TOTAL_BASES += (long)length;
            boolean bl = isPfRead = !rec.getReadFailsVendorQualityCheckFlag();
            if (isPfRead) {
                ++this.metrics.PF_READS;
                this.metrics.PF_BASES += (long)length;
            }
            if (this.alternateQualityAttribute != null) {
                byte[] tmp = rec.getStringAttribute(this.alternateQualityAttribute).getBytes();
                if (tmp == null) {
                    tmp = rec.getBaseQualities();
                } else {
                    SAMUtils.fastqToPhred(tmp);
                }
                quals = tmp;
            } else {
                quals = rec.getBaseQualities();
            }
            if (quals.length != rec.getReadBases().length) {
                throw new PicardException("quality string length does not match bases string");
            }
            byte[][] snvq = new byte[4][];
            for (int i = 0; i < snvq.length; ++i) {
                snvq[i] = rec.getStringAttribute(String.format("q%c", Character.toLowerCase(CollectQualityYieldMetricsSNVQ.this.baseOrder[i]))).getBytes();
            }
            byte[] bases = rec.getReadBases();
            int readPosition = 0;
            for (byte qual : quals) {
                if (qual >= 40) {
                    ++this.metrics.Q20_BASES;
                    ++this.metrics.Q30_BASES;
                    ++this.metrics.Q40_BASES;
                } else if (qual >= 30) {
                    ++this.metrics.Q20_BASES;
                    ++this.metrics.Q30_BASES;
                } else if (qual >= 20) {
                    ++this.metrics.Q20_BASES;
                }
                if (isPfRead) {
                    if (qual >= 40) {
                        ++this.metrics.PF_Q20_BASES;
                        ++this.metrics.PF_Q30_BASES;
                        ++this.metrics.PF_Q40_BASES;
                    } else if (qual >= 30) {
                        ++this.metrics.PF_Q20_BASES;
                        ++this.metrics.PF_Q30_BASES;
                    } else if (qual >= 20) {
                        ++this.metrics.PF_Q20_BASES;
                    }
                }
                byte base = bases[readPosition];
                for (int i = 0; i < CollectQualityYieldMetricsSNVQ.this.baseOrder.length; ++i) {
                    if (base == CollectQualityYieldMetricsSNVQ.this.baseOrder[i]) continue;
                    int q = SAMUtils.fastqToPhred((char)snvq[i][readPosition]);
                    ++this.metrics.TOTAL_SNVQ;
                    if (isPfRead) {
                        ++this.metrics.PF_SNVQ;
                    }
                    if (q >= 40) {
                        ++this.metrics.Q20_SNVQ;
                        ++this.metrics.Q30_SNVQ;
                        ++this.metrics.Q40_SNVQ;
                        if (isPfRead) {
                            ++this.metrics.PF_Q20_SNVQ;
                            ++this.metrics.PF_Q30_SNVQ;
                            ++this.metrics.PF_Q40_SNVQ;
                        }
                    } else if (q >= 30) {
                        ++this.metrics.Q20_SNVQ;
                        ++this.metrics.Q30_SNVQ;
                        if (isPfRead) {
                            ++this.metrics.PF_Q20_SNVQ;
                            ++this.metrics.PF_Q30_SNVQ;
                        }
                    } else if (q >= 20) {
                        ++this.metrics.Q20_SNVQ;
                        if (isPfRead) {
                            ++this.metrics.PF_Q20_SNVQ;
                        }
                    }
                    if (!CollectQualityYieldMetricsSNVQ.this.INCLUDE_BQ_HISTOGRAM) continue;
                    CollectQualityYieldMetricsSNVQ.this.snvqHistogram.increment(q);
                    while (CollectQualityYieldMetricsSNVQ.this.readPositionSnvqStats.size() <= readPosition) {
                        CollectQualityYieldMetricsSNVQ.this.readPositionSnvqStats.add(new SeriesStats());
                    }
                    CollectQualityYieldMetricsSNVQ.this.readPositionSnvqStats.get(readPosition).add(q);
                }
                if (CollectQualityYieldMetricsSNVQ.this.INCLUDE_BQ_HISTOGRAM) {
                    CollectQualityYieldMetricsSNVQ.this.qualityHistogram.increment(Integer.valueOf(qual));
                    while (CollectQualityYieldMetricsSNVQ.this.readPositionQualityStats.size() <= readPosition) {
                        CollectQualityYieldMetricsSNVQ.this.readPositionQualityStats.add(new SeriesStats());
                    }
                    CollectQualityYieldMetricsSNVQ.this.readPositionQualityStats.get(readPosition).add(qual);
                }
                ++readPosition;
            }
        }

        public void finish() {
            this.metrics.calculateDerivedFields();
        }

        public void addMetricsToFile(MetricsFile<QualityYieldMetrics, Integer> metricsFile) {
            metricsFile.addMetric(this.metrics);
        }

        public void addHistograms(MetricsFile<QualityYieldMetrics, Integer> metricsFile) {
            Histogram<Integer> h1 = new Histogram<Integer>("KEY", "READ_INDEX_MEAN_BQ");
            for (int i = 0; i < CollectQualityYieldMetricsSNVQ.this.readPositionQualityStats.size(); ++i) {
                SeriesStats ss = CollectQualityYieldMetricsSNVQ.this.readPositionQualityStats.get(i);
                h1.increment(i, ss.getMean());
            }
            metricsFile.addHistogram(h1);
            Histogram<Integer> h2 = new Histogram<Integer>("KEY", "READ_INDEX_MEAN_SNVQ");
            for (int i = 0; i < CollectQualityYieldMetricsSNVQ.this.readPositionSnvqStats.size(); ++i) {
                SeriesStats ss = CollectQualityYieldMetricsSNVQ.this.readPositionSnvqStats.get(i);
                h2.increment(i, ss.getMean());
            }
            metricsFile.addHistogram(h2);
        }
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class QualityYieldMetrics
    extends MergeableMetricBase {
        @MergeableMetricBase.MergeByAdding
        public long TOTAL_READS = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_READS = 0L;
        @MergeableMetricBase.NoMergingIsDerived
        public int READ_LENGTH = 0;
        @MergeableMetricBase.MergeByAdding
        public long TOTAL_BASES = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_BASES = 0L;
        @MergeableMetricBase.MergeByAdding
        public long Q20_BASES = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q20_BASES = 0L;
        @MergeableMetricBase.MergeByAdding
        public long Q30_BASES = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q30_BASES = 0L;
        @MergeableMetricBase.MergeByAdding
        public long Q40_BASES = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q40_BASES = 0L;
        @MergeableMetricBase.MergingIsManual
        public double PCT_Q20_BASES = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_Q30_BASES = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_Q40_BASES = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q20_BASES = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q30_BASES = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q40_BASES = 0.0;
        @MergeableMetricBase.MergeByAdding
        public long TOTAL_SNVQ = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_SNVQ = 0L;
        @MergeableMetricBase.MergeByAdding
        public long Q20_SNVQ = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q20_SNVQ = 0L;
        @MergeableMetricBase.MergeByAdding
        public long Q30_SNVQ = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q30_SNVQ = 0L;
        @MergeableMetricBase.MergeByAdding
        public long Q40_SNVQ = 0L;
        @MergeableMetricBase.MergeByAdding
        public long PF_Q40_SNVQ = 0L;
        @MergeableMetricBase.MergingIsManual
        public double PCT_Q20_SNVQ = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_Q30_SNVQ = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_Q40_SNVQ = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q20_SNVQ = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q30_SNVQ = 0.0;
        @MergeableMetricBase.MergingIsManual
        public double PCT_PF_Q40_SNVQ = 0.0;
        @MergeableMetricBase.MergeByAssertEquals
        protected final String alternateQualityAttribute;

        public QualityYieldMetrics() {
            this(null);
        }

        public QualityYieldMetrics(String alternateQualityAttribute) {
            this.alternateQualityAttribute = alternateQualityAttribute;
        }

        @Override
        public void calculateDerivedFields() {
            super.calculateDerivedFields();
            this.READ_LENGTH = this.TOTAL_READS == 0L ? 0 : (int)(this.TOTAL_BASES / this.TOTAL_READS);
            this.PCT_Q20_BASES = this.TOTAL_BASES == 0L ? 0.0 : (double)this.Q20_BASES / (double)this.TOTAL_BASES;
            this.PCT_Q30_BASES = this.TOTAL_BASES == 0L ? 0.0 : (double)this.Q30_BASES / (double)this.TOTAL_BASES;
            this.PCT_Q40_BASES = this.TOTAL_BASES == 0L ? 0.0 : (double)this.Q40_BASES / (double)this.TOTAL_BASES;
            this.PCT_PF_Q20_BASES = this.PF_BASES == 0L ? 0.0 : (double)this.PF_Q20_BASES / (double)this.PF_BASES;
            this.PCT_PF_Q30_BASES = this.PF_BASES == 0L ? 0.0 : (double)this.PF_Q30_BASES / (double)this.PF_BASES;
            this.PCT_PF_Q40_BASES = this.PF_BASES == 0L ? 0.0 : (double)this.PF_Q40_BASES / (double)this.PF_BASES;
            this.PCT_Q20_SNVQ = this.TOTAL_SNVQ == 0L ? 0.0 : (double)this.Q20_SNVQ / (double)this.TOTAL_SNVQ;
            this.PCT_Q30_SNVQ = this.TOTAL_SNVQ == 0L ? 0.0 : (double)this.Q30_SNVQ / (double)this.TOTAL_SNVQ;
            this.PCT_Q40_SNVQ = this.TOTAL_SNVQ == 0L ? 0.0 : (double)this.Q40_SNVQ / (double)this.TOTAL_SNVQ;
            this.PCT_PF_Q20_SNVQ = this.PF_SNVQ == 0L ? 0.0 : (double)this.PF_Q20_SNVQ / (double)this.PF_SNVQ;
            this.PCT_PF_Q30_SNVQ = this.PF_SNVQ == 0L ? 0.0 : (double)this.PF_Q30_SNVQ / (double)this.PF_SNVQ;
            this.PCT_PF_Q40_SNVQ = this.PF_SNVQ == 0L ? 0.0 : (double)this.PF_Q40_SNVQ / (double)this.PF_SNVQ;
        }

        @Override
        public MergeableMetricBase merge(MergeableMetricBase other) {
            if (!(other instanceof QualityYieldMetrics)) {
                throw new PicardException("Only objects of the same type can be merged");
            }
            QualityYieldMetrics otherMetric = (QualityYieldMetrics)other;
            super.merge(otherMetric);
            this.calculateDerivedFields();
            return this;
        }
    }
}

